/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaI18nUtil
extends I18nUtil {
    public static final PropertyCreationHandler DEFAULT_PROPERTY_CREATION_HANDLER = new PropertyCreationHandler(){

        @Override
        public void createProperty(Project project, Collection<PropertiesFile> propertiesFiles, String key, String value, PsiExpression[] parameters) throws IncorrectOperationException {
            I18nUtil.createProperty((Project)project, propertiesFiles, (String)key, (String)value, (boolean)true);
        }
    };

    private JavaI18nUtil() {
    }

    @Nullable
    public static TextRange getSelectedRange(Editor editor, PsiFile psiFile) {
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        if (selectedText != null) {
            return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        }
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null || psiElement instanceof PsiWhiteSpace) {
            return null;
        }
        return psiElement.getTextRange();
    }

    public static boolean mustBePropertyKey(@NotNull PsiExpression expression, @NotNull Map<String, Object> annotationAttributeValues) {
        PsiAnnotation annotation;
        PsiElement parent;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(0);
        }
        if (annotationAttributeValues == null) {
            JavaI18nUtil.$$$reportNull$$$0(1);
        }
        if ((parent = expression.getParent()) instanceof PsiVariable && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiVariable)parent), (String[])new String[]{"org.jetbrains.annotations.PropertyKey"})) != null) {
            return JavaI18nUtil.processAnnotationAttributes(annotationAttributeValues, annotation);
        }
        return JavaI18nUtil.isPassedToAnnotatedParam(expression, "org.jetbrains.annotations.PropertyKey", annotationAttributeValues, null);
    }

    static boolean isPassedToAnnotatedParam(@NotNull PsiExpression expression, String annFqn, @Nullable Map<String, Object> annotationAttributeValues, @Nullable Set<PsiModifierListOwner> nonNlsTargets) {
        PsiMethod method;
        PsiElement parent;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(2);
        }
        if (!((parent = (expression = JavaI18nUtil.getTopLevelExpression(expression)).getParent()) instanceof PsiExpressionList)) {
            return false;
        }
        int idx = -1;
        PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = args[i];
            if (!PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)expression, (boolean)false)) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return false;
        }
        PsiElement grParent = parent.getParent();
        if (grParent instanceof PsiAnonymousClass) {
            grParent = grParent.getParent();
        }
        return grParent instanceof PsiCall && (method = ((PsiCall)grParent).resolveMethod()) != null && JavaI18nUtil.isMethodParameterAnnotatedWith(method, idx, null, annFqn, annotationAttributeValues, nonNlsTargets);
    }

    @NotNull
    static PsiExpression getTopLevelExpression(@NotNull PsiExpression expression) {
        PsiExpression parent;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(3);
        }
        while (!(!(expression.getParent() instanceof PsiExpression) || (parent = (PsiExpression)expression.getParent()) instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() == expression || (expression = parent) instanceof PsiAssignmentExpression)) {
        }
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            JavaI18nUtil.$$$reportNull$$$0(4);
        }
        return psiExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isMethodParameterAnnotatedWith(PsiMethod method, int idx, @Nullable Collection<PsiMethod> processed, String annFqn, @Nullable Map<String, Object> annotationAttributeValues, @Nullable Set<PsiModifierListOwner> nonNlsTargets) {
        PsiMethod[] superMethods;
        PsiAnnotation annotation;
        PsiParameter param;
        if (processed != null) {
            if (processed.contains(method)) {
                return false;
            }
        } else {
            processed = new THashSet();
        }
        processed.add(method);
        PsiParameter[] params = method.getParameterList().getParameters();
        if (idx >= params.length) {
            if (params.length == 0) {
                return false;
            }
            PsiParameter lastParam = params[params.length - 1];
            if (!lastParam.isVarArgs()) return false;
            param = lastParam;
        } else {
            param = params[idx];
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)param, (String[])new String[]{annFqn})) != null) {
            return JavaI18nUtil.processAnnotationAttributes(annotationAttributeValues, annotation);
        }
        if (nonNlsTargets != null) {
            nonNlsTargets.add((PsiModifierListOwner)param);
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            if (!JavaI18nUtil.isMethodParameterAnnotatedWith(superMethod, idx, (Collection<PsiMethod>)processed, annFqn, annotationAttributeValues, null)) continue;
            return true;
        }
        return false;
    }

    private static boolean processAnnotationAttributes(@Nullable Map<String, Object> annotationAttributeValues, @NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JavaI18nUtil.$$$reportNull$$$0(5);
        }
        if (annotationAttributeValues != null) {
            PsiNameValuePair[] attributes;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameterList.getAttributes()) {
                String name = attribute.getName();
                if (!annotationAttributeValues.containsKey(name)) continue;
                annotationAttributeValues.put(name, attribute.getValue());
            }
        }
        return true;
    }

    static boolean isValidPropertyReference(@NotNull Project project, @NotNull PsiExpression expression, @NotNull String key, @NotNull Ref<String> outResourceBundle) {
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(7);
        }
        if (key == null) {
            JavaI18nUtil.$$$reportNull$$$0(8);
        }
        if (outResourceBundle == null) {
            JavaI18nUtil.$$$reportNull$$$0(9);
        }
        HashMap<String, Object> annotationAttributeValues = new HashMap<String, Object>();
        annotationAttributeValues.put("resourceBundle", null);
        if (JavaI18nUtil.mustBePropertyKey(expression, annotationAttributeValues)) {
            Object resourceBundleName = annotationAttributeValues.get("resourceBundle");
            if (!(resourceBundleName instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expr = (PsiExpression)resourceBundleName;
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
            Object value = constantEvaluationHelper.computeConstantExpression((PsiElement)expr);
            if (value == null) {
                PsiElement resolve;
                if (expr instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && (value = constantEvaluationHelper.computeConstantExpression((PsiElement)((PsiField)resolve).getInitializer())) == null) {
                    return false;
                }
                if (value == null) {
                    ResourceBundle resourceBundle = JavaI18nUtil.resolveResourceBundleByKey(key, project);
                    if (resourceBundle == null) {
                        return false;
                    }
                    PropertiesFile defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile();
                    String bundleName = BundleNameEvaluator.DEFAULT.evaluateBundleName(defaultPropertiesFile.getContainingFile());
                    if (bundleName == null) {
                        return false;
                    }
                    value = bundleName;
                }
            }
            String bundleName = value.toString();
            outResourceBundle.set((Object)bundleName);
            return JavaI18nUtil.isPropertyRef(expression, key, bundleName);
        }
        return true;
    }

    @Nullable
    private static ResourceBundle resolveResourceBundleByKey(@NotNull String key, @NotNull Project project) {
        if (key == null) {
            JavaI18nUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(11);
        }
        Ref bundleRef = Ref.create();
        boolean r = PropertiesReferenceManager.getInstance((Project)project).processAllPropertiesFiles((baseName, propertiesFile) -> {
            if (key == null) {
                JavaI18nUtil.$$$reportNull$$$0(18);
            }
            if (propertiesFile.findPropertyByKey(key) != null) {
                if (bundleRef.get() == null) {
                    bundleRef.set((Object)propertiesFile.getResourceBundle());
                } else if (!((ResourceBundle)bundleRef.get()).equals(propertiesFile.getResourceBundle())) {
                    return false;
                }
            }
            return true;
        });
        return r ? (ResourceBundle)bundleRef.get() : null;
    }

    static boolean isPropertyRef(PsiExpression expression, String key, String resourceBundleName) {
        if (resourceBundleName == null) {
            return !PropertiesImplUtil.findPropertiesByKey((Project)expression.getProject(), (String)key).isEmpty();
        }
        List propertiesFiles = JavaI18nUtil.propertiesFilesByBundleName((String)resourceBundleName, (PsiElement)expression);
        boolean containedInPropertiesFile = false;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            containedInPropertiesFile |= propertiesFile.findPropertyByKey(key) != null;
        }
        return containedInPropertiesFile;
    }

    public static Set<String> suggestExpressionOfType(PsiClassType type, PsiLiteralExpression context) {
        PsiExpression[] expressions;
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt((PsiElement)context, (String)"");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PsiVariable var : variables) {
            PsiType varType = var.getType();
            if (type != null && !type.isAssignableFrom(varType)) continue;
            result.add(var.getNameIdentifier().getText());
        }
        for (PsiExpression expression : expressions = MacroUtil.getStandardExpressionsOfType((PsiElement)context, (PsiType)type)) {
            result.add(expression.getText());
        }
        if (type != null) {
            JavaI18nUtil.addAvailableMethodsOfType(type, context, result);
        }
        return result;
    }

    private static void addAvailableMethodsOfType(final PsiClassType type, PsiLiteralExpression context, final Collection<String> result) {
        PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                PsiMethod method;
                PsiType returnType;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof PsiMethod && (returnType = (method = (PsiMethod)element).getReturnType()) != null && TypeConversionUtil.isAssignable((PsiType)type, (PsiType)returnType) && method.getParameterList().isEmpty()) {
                    result.add(method.getName() + "()");
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/i18n/JavaI18nUtil$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (PsiElement)context, null);
    }

    public static int getPropertyValuePlaceholdersCount(@NotNull String propertyValue) {
        if (propertyValue == null) {
            JavaI18nUtil.$$$reportNull$$$0(12);
        }
        try {
            return new MessageFormat(propertyValue).getFormatsByArgumentIndex().length;
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    public static int getPropertyValueParamsMaxCount(@NotNull PsiExpression expression) {
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(13);
        }
        return JavaI18nUtil.getPropertyValueParamsMaxCount(expression, null);
    }

    private static int getPropertyValueParamsMaxCount(@NotNull PsiExpression expression, @Nullable String resourceBundleName) {
        SortedSet<Integer> paramsCount;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(14);
        }
        if ((paramsCount = JavaI18nUtil.getPropertyValueParamsCount(expression, resourceBundleName)).isEmpty()) {
            return -1;
        }
        return paramsCount.last();
    }

    @NotNull
    static SortedSet<Integer> getPropertyValueParamsCount(@NotNull PsiExpression expression, @Nullable String resourceBundleName) {
        PsiLiteralExpression literalExpression;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(15);
        }
        if (expression instanceof PsiLiteralExpression) {
            literalExpression = (PsiLiteralExpression)expression;
        } else if (expression instanceof PsiReferenceExpression) {
            PsiElement resolved = ((PsiReferenceExpression)expression).resolve();
            PsiField field = resolved == null ? null : (PsiField)resolved;
            literalExpression = field != null && field.hasModifierProperty("final") && field.getInitializer() instanceof PsiLiteralExpression ? (PsiLiteralExpression)field.getInitializer() : null;
        } else {
            literalExpression = null;
        }
        TreeSet<Integer> paramsCount = new TreeSet<Integer>();
        if (literalExpression == null) {
            TreeSet<Integer> treeSet = paramsCount;
            if (treeSet == null) {
                JavaI18nUtil.$$$reportNull$$$0(16);
            }
            return treeSet;
        }
        for (PsiReference reference : literalExpression.getReferences()) {
            if (!(reference instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                if (!result.isValidResult() || !(result.getElement() instanceof IProperty)) continue;
                try {
                    String propertyValue;
                    PsiFile file;
                    IProperty property = (IProperty)result.getElement();
                    if (resourceBundleName != null && !resourceBundleName.equals(BundleNameEvaluator.DEFAULT.evaluateBundleName(file = property.getPropertiesFile().getContainingFile())) || (propertyValue = property.getValue()) == null) continue;
                    paramsCount.add(JavaI18nUtil.getPropertyValuePlaceholdersCount(propertyValue));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        TreeSet<Integer> treeSet = paramsCount;
        if (treeSet == null) {
            JavaI18nUtil.$$$reportNull$$$0(17);
        }
        return treeSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationAttributeValues";
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/JavaI18nUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outResourceBundle";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/JavaI18nUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyValueParamsCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mustBePropertyKey";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPassedToAnnotatedParam";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelExpression";
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAnnotationAttributes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyReference";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundleByKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValuePlaceholdersCount";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValueParamsMaxCount";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValueParamsCount";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveResourceBundleByKey$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

