/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class MultiProjectHtmlReporter
extends HtmlReporter {
    private static final String INDEX_NAME = "index.html";
    private final File dir;

    public MultiProjectHtmlReporter(LintCliClient client, File dir, LintCliFlags flags) throws IOException {
        super(client, new File(dir, INDEX_NAME), flags);
        this.dir = dir;
    }

    @Override
    public void write(Reporter.Stats stats, List<Warning> allIssues) throws IOException {
        HashMap projectToWarnings = new HashMap();
        for (Warning warning : allIssues) {
            List list = (List)projectToWarnings.get(warning.project);
            if (list == null) {
                list = new ArrayList();
                projectToWarnings.put(warning.project, list);
            }
            list.add(warning);
        }
        HashSet unique = Sets.newHashSet();
        unique.add(INDEX_NAME.toLowerCase(Locale.US));
        ArrayList projects = Lists.newArrayList();
        for (Project project : projectToWarnings.keySet()) {
            String relative;
            boolean deleted;
            String fileName;
            String lowercase;
            String projectName = project.getName();
            int number = 1;
            while (true) {
                String numberString;
                if (!unique.contains(lowercase = (fileName = String.format("%1$s%2$s.html", projectName, numberString = number > 1 ? Integer.toString(number) : "")).toLowerCase(Locale.US))) break;
                ++number;
            }
            unique.add(lowercase);
            File output = new File(this.dir, fileName);
            if (output.exists() && !(deleted = output.delete())) {
                this.client.log(null, "Could not delete old file %1$s", new Object[]{output});
                continue;
            }
            if (!output.getParentFile().canWrite()) {
                this.client.log(null, "Cannot write output file %1$s", new Object[]{output});
                continue;
            }
            Reporter reporter = Reporter.createHtmlReporter(this.client, output, this.flags, this.simpleFormat);
            reporter.setBundleResources(this.bundleResources);
            reporter.setSimpleFormat(this.simpleFormat);
            reporter.setUrlMap(this.urlMap);
            List issues = (List)projectToWarnings.get(project);
            int projectErrorCount = 0;
            int projectWarningCount = 0;
            for (Warning warning : issues) {
                if (warning.severity.isError()) {
                    ++projectErrorCount;
                    continue;
                }
                if (warning.severity != Severity.WARNING) continue;
                ++projectWarningCount;
            }
            String prefix = project.getReferenceDir().getPath();
            String path = project.getDir().getPath();
            if (path.startsWith(prefix) && path.length() > prefix.length()) {
                int i = prefix.length();
                if (path.charAt(i) == File.separatorChar) {
                    ++i;
                }
                relative = path.substring(i);
            } else {
                relative = projectName;
            }
            reporter.setTitle(String.format("Lint Report for %1$s", relative));
            reporter.setStripPrefix(relative);
            reporter.write(stats, issues);
            projects.add(new ProjectEntry(fileName, projectErrorCount, projectWarningCount, relative));
        }
        this.writer.close();
        Collections.sort(projects);
        Reporter reporter = Reporter.createHtmlReporter(this.client, this.output, this.flags, this.simpleFormat);
        reporter.writeProjectList(stats, projects);
        if (!(this.client.getFlags().isQuiet() || stats.errorCount <= 0 && stats.warningCount <= 0)) {
            File index = new File(this.dir, INDEX_NAME);
            String url = SdkUtils.fileToUrlString((File)index.getAbsoluteFile());
            System.out.println(String.format("Wrote overview index to %1$s", url));
        }
    }

    static class ProjectEntry
    implements Comparable<ProjectEntry> {
        public final int errorCount;
        public final int warningCount;
        public final String fileName;
        public final String path;

        public ProjectEntry(String fileName, int errorCount, int warningCount, String path) {
            this.fileName = fileName;
            this.errorCount = errorCount;
            this.warningCount = warningCount;
            this.path = path;
        }

        @Override
        public int compareTo(ProjectEntry other) {
            int delta = other.errorCount - this.errorCount;
            if (delta != 0) {
                return delta;
            }
            delta = other.warningCount - this.warningCount;
            if (delta != 0) {
                return delta;
            }
            return this.path.compareTo(other.path);
        }
    }
}

