/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiBinaryClass;
import com.android.tools.lint.psi.EcjPsiField;
import com.android.tools.lint.psi.EcjPsiJavaEvaluator;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiMethod;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

class EcjPsiClass
extends EcjPsiSourceElement
implements PsiClass {
    private final int mEcjModifiers;
    private final String mName;
    private String mQualifiedName;
    private EcjPsiModifierList mModifierList;
    private TypeReference mSuperClassReference;
    private PsiClass mSuperClass;
    private TypeReference[] mSuperInterfaceReferences;
    private PsiClass[] mSuperInterfaces;
    private PsiIdentifier mIdentifier;
    private PsiTypeParameterList mTypeParameterList;
    private List<PsiClassInitializer> mInitializers;
    private List<EcjPsiMethod> mMethods;
    private EcjPsiClass[] mInnerClasses;
    private List<EcjPsiField> mFields;
    private PsiReferenceList mExtendsList;
    private PsiReferenceList mImplementsList;

    EcjPsiClass(EcjPsiManager manager, TypeDeclaration declaration, String name) {
        super(manager, (ASTNode)declaration);
        this.mEcjModifiers = declaration.modifiers;
        this.mName = name;
        if (declaration.binding != null && declaration.binding.compoundName != null) {
            this.mQualifiedName = EcjPsiManager.getTypeName((ReferenceBinding)declaration.binding);
        }
        this.mManager.registerElement((Binding)declaration.binding, this);
    }

    void setNameIdentifier(PsiIdentifier identifier) {
        this.mIdentifier = identifier;
    }

    void setSuperClass(TypeReference superclass) {
        this.mSuperClassReference = superclass;
    }

    void setSuperInterfaces(TypeReference[] superInterfaces) {
        this.mSuperInterfaceReferences = superInterfaces;
    }

    void setFields(List<EcjPsiField> fields) {
        this.mFields = fields;
    }

    void setInitializers(List<PsiClassInitializer> initializers) {
        this.mInitializers = initializers;
    }

    void setMethods(List<EcjPsiMethod> methods) {
        this.mMethods = methods;
    }

    void setTypeParameterList(PsiTypeParameterList typeParameterList) {
        this.mTypeParameterList = typeParameterList;
    }

    void setInnerClasses(EcjPsiClass[] innerClasses) {
        this.mInnerClasses = innerClasses;
    }

    void setExtendsList(PsiReferenceList extendsList) {
        this.mExtendsList = extendsList;
    }

    void setImplementsList(PsiReferenceList implementsList) {
        this.mImplementsList = implementsList;
    }

    public String getQualifiedName() {
        return this.mQualifiedName;
    }

    private boolean isPlainClass() {
        return TypeDeclaration.kind((int)this.mEcjModifiers) == 1;
    }

    public boolean isInterface() {
        return TypeDeclaration.kind((int)this.mEcjModifiers) == 2;
    }

    public boolean isAnnotationType() {
        return TypeDeclaration.kind((int)this.mEcjModifiers) == 4;
    }

    public boolean isEnum() {
        return TypeDeclaration.kind((int)this.mEcjModifiers) == 3;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public PsiClass getContainingClass() {
        return this.mParent instanceof EcjPsiClass ? (EcjPsiClass)this.mParent : null;
    }

    public PsiModifierList getModifierList() {
        return this.mModifierList;
    }

    public void setModifierList(EcjPsiModifierList modifierList) {
        this.mModifierList = modifierList;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.mModifierList != null && this.mModifierList.hasModifierProperty(s);
    }

    public boolean hasTypeParameters() {
        return this.mTypeParameterList != null;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.mTypeParameterList;
    }

    public PsiTypeParameter[] getTypeParameters() {
        return this.mTypeParameterList != null ? this.mTypeParameterList.getTypeParameters() : PsiTypeParameter.EMPTY_ARRAY;
    }

    public PsiReferenceList getExtendsList() {
        return this.mExtendsList;
    }

    public PsiReferenceList getImplementsList() {
        return this.mImplementsList;
    }

    public PsiClassType[] getExtendsListTypes() {
        return this.mExtendsList != null ? this.mExtendsList.getReferencedTypes() : PsiClassType.EMPTY_ARRAY;
    }

    public PsiClassType[] getImplementsListTypes() {
        return this.mImplementsList != null ? this.mImplementsList.getReferencedTypes() : PsiClassType.EMPTY_ARRAY;
    }

    public PsiClass getSuperClass() {
        if (this.mSuperClass == null) {
            if (this.mSuperClassReference != null) {
                this.mSuperClass = this.mManager.findClass(this.mSuperClassReference);
            } else if (this.isPlainClass()) {
                this.mSuperClass = this.mManager.findClass(TypeConstants.JAVA_LANG_OBJECT);
            } else if (this.isInterface()) {
                this.mSuperClass = null;
            } else if (this.isEnum()) {
                this.mSuperClass = this.mManager.findClass(TypeConstants.JAVA_LANG_ENUM);
            } else if (this.isAnnotationType()) {
                this.mSuperClass = this.mManager.findClass(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION);
            }
        }
        return this.mSuperClass;
    }

    public PsiClass[] getInterfaces() {
        if (this.mSuperInterfaces == null) {
            if (this.mSuperInterfaceReferences != null && this.mSuperInterfaceReferences.length > 0) {
                ArrayList interfaces = Lists.newArrayListWithCapacity((int)this.mSuperInterfaceReferences.length);
                for (TypeReference ref : this.mSuperInterfaceReferences) {
                    PsiClass cls = this.mManager.findClass(ref);
                    if (cls == null) continue;
                    interfaces.add(cls);
                }
                this.mSuperInterfaces = interfaces.toArray(PsiClass.EMPTY_ARRAY);
            } else {
                this.mSuperInterfaces = PsiClass.EMPTY_ARRAY;
            }
        }
        return this.mSuperInterfaces;
    }

    public PsiClass[] getSupers() {
        PsiClass superClass = this.getSuperClass();
        PsiClass[] interfaces = this.getInterfaces();
        if (superClass == null) {
            return interfaces;
        }
        if (interfaces == null || interfaces.length == 0) {
            return new PsiClass[]{superClass};
        }
        PsiClass[] result = new PsiClass[interfaces.length + 1];
        System.arraycopy(interfaces, 0, result, 1, interfaces.length);
        result[0] = superClass;
        return result;
    }

    public PsiClassType[] getSuperTypes() {
        return this.mManager.getClassTypes(this.getSupers());
    }

    public PsiField[] getFields() {
        return this.mFields != null ? this.mFields.toArray(PsiField.EMPTY_ARRAY) : PsiField.EMPTY_ARRAY;
    }

    public PsiMethod[] getMethods() {
        return this.mMethods != null ? this.mMethods.toArray(PsiMethod.EMPTY_ARRAY) : PsiMethod.EMPTY_ARRAY;
    }

    public PsiMethod[] getConstructors() {
        if (this.mMethods != null) {
            ArrayList constructors = Lists.newArrayList();
            for (PsiMethod psiMethod : this.mMethods) {
                if (!psiMethod.isConstructor()) continue;
                constructors.add(psiMethod);
            }
            return constructors.toArray(PsiMethod.EMPTY_ARRAY);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiClass[] getInnerClasses() {
        return this.mInnerClasses != null ? this.mInnerClasses : PsiClass.EMPTY_ARRAY;
    }

    public PsiClassInitializer[] getInitializers() {
        return this.mInitializers != null ? this.mInitializers.toArray(new PsiClassInitializer[0]) : PsiClassInitializer.EMPTY_ARRAY;
    }

    public PsiField[] getAllFields() {
        PsiField[] fields = this.getFields();
        PsiField[] superFields = PsiField.EMPTY_ARRAY;
        PsiClass superClass = this.getSuperClass();
        if (superClass != null) {
            superFields = superClass.getAllFields();
        }
        if (superFields.length == 0) {
            return fields;
        }
        if (fields.length == 0) {
            return superFields;
        }
        ArrayList merged = Lists.newArrayListWithCapacity((int)(fields.length + superFields.length));
        Collections.addAll(merged, fields);
        block0: for (PsiField superField : superFields) {
            String superName = superField.getName();
            if (superName != null) {
                for (PsiField field : fields) {
                    if (superName.equals(field.getName())) continue block0;
                }
            }
            merged.add(superField);
        }
        return merged.toArray(PsiField.EMPTY_ARRAY);
    }

    public PsiMethod[] getAllMethods() {
        PsiMethod[] methods = this.getMethods();
        PsiMethod[] superMethods = PsiMethod.EMPTY_ARRAY;
        PsiClass superClass = this.getSuperClass();
        if (superClass != null) {
            superMethods = superClass.getAllMethods();
        }
        if (superMethods.length == 0) {
            return methods;
        }
        if (methods.length == 0) {
            return superMethods;
        }
        ArrayList merged = Lists.newArrayListWithCapacity((int)(methods.length + superMethods.length));
        Collections.addAll(merged, methods);
        block0: for (PsiMethod superMethod : superMethods) {
            String superName = superMethod.getName();
            PsiParameterList superParameterList = superMethod.getParameterList();
            int superParameterCount = superParameterList.getParametersCount();
            PsiParameter[] superParameters = superParameterList.getParameters();
            block1: for (PsiMethod method : methods) {
                PsiParameterList parameterList;
                if (method.getName().equals(superName) || (parameterList = method.getParameterList()).getParametersCount() != superParameterCount) continue;
                PsiParameter[] parameters = parameterList.getParameters();
                for (int i = 0; i < superParameters.length; ++i) {
                    PsiParameter superParameter = superParameters[i];
                    PsiParameter parameter = parameters[i];
                    if (!superParameter.getType().equals(parameter.getType())) continue block1;
                }
                continue block0;
            }
            merged.add(superMethod);
        }
        return merged.toArray(PsiMethod.EMPTY_ARRAY);
    }

    public PsiClass[] getAllInnerClasses() {
        PsiClass[] innerClasses = this.getInnerClasses();
        PsiClass superClass = this.getSuperClass();
        if (superClass == null) {
            return innerClasses;
        }
        PsiClass[] superInnerClasses = superClass.getAllInnerClasses();
        if (innerClasses.length == 0) {
            return superInnerClasses;
        }
        if (superInnerClasses.length == 0) {
            return innerClasses;
        }
        PsiClass[] all = new PsiClass[innerClasses.length + superInnerClasses.length];
        System.arraycopy(innerClasses, 0, all, 0, innerClasses.length);
        System.arraycopy(superInnerClasses, 0, all, innerClasses.length, superInnerClasses.length);
        return all;
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        PsiClass superClass;
        if (this.mFields != null) {
            for (EcjPsiField field : this.mFields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        if (checkBases && (superClass = this.getSuperClass()) != null) {
            return superClass.findFieldByName(name, true);
        }
        return null;
    }

    public PsiMethod findMethodBySignature(PsiMethod psiMethod, boolean checkBases) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod[] findMethodsBySignature(PsiMethod psiMethod, boolean checkBases) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiClass superClass;
        PsiMethod match = null;
        List<PsiMethod> all = null;
        for (PsiMethod method : this.getMethods()) {
            if (!name.equals(method.getName())) continue;
            if (match == null) {
                match = method;
                continue;
            }
            if (all == null) {
                all = Lists.newArrayList();
                all.add(match);
            }
            all.add(method);
        }
        if (checkBases && (superClass = this.getSuperClass()) != null) {
            PsiMethod[] superMatches = superClass.findMethodsByName(name, true);
            if (match == null) {
                return superMatches;
            }
            if (superMatches.length == 0) {
                if (all != null) {
                    return all.toArray(PsiMethod.EMPTY_ARRAY);
                }
                return new PsiMethod[]{match};
            }
            ArrayList methods = Lists.newArrayList();
            if (all == null) {
                all = Collections.singletonList(match);
            }
            methods.addAll(all);
            for (PsiMethod fromSuper : superMatches) {
                PsiParameterList parameterList = fromSuper.getParameterList();
                PsiParameter[] parameters = parameterList.getParameters();
                boolean masked = false;
                for (PsiMethod local : all) {
                    PsiParameterList superParameterList = local.getParameterList();
                    if (parameterList.getParametersCount() != superParameterList.getParametersCount()) continue;
                    boolean matches = true;
                    PsiParameter[] superParams = superParameterList.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        PsiParameter parameter = parameters[i];
                        PsiParameter superParam = superParams[i];
                        if (Objects.equal((Object)parameter.getType(), (Object)superParam.getType())) continue;
                        matches = false;
                        break;
                    }
                    if (matches) continue;
                    masked = true;
                    break;
                }
                if (masked) continue;
                methods.add(fromSuper);
            }
        }
        if (all != null) {
            return all.toArray(PsiMethod.EMPTY_ARRAY);
        }
        if (match != null) {
            return new PsiMethod[]{match};
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String s, boolean b) {
        throw new UnimplementedLintPsiApiException();
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        PsiClass superClass;
        for (PsiClass cls : this.getInnerClasses()) {
            if (!name.equals(cls.getName())) continue;
            return cls;
        }
        if (checkBases && (superClass = this.getSuperClass()) != null) {
            return superClass.findInnerClassByName(name, true);
        }
        return null;
    }

    public PsiElement getLBrace() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiElement getRBrace() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiElement getScope() {
        throw new UnimplementedLintPsiApiException();
    }

    public boolean isInheritor(PsiClass baseClass, boolean checkDeep) {
        String qualifiedName = baseClass.getQualifiedName();
        return qualifiedName != null && new EcjPsiJavaEvaluator(this.mManager).inheritsFrom(this, qualifiedName, false);
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        throw new UnimplementedLintPsiApiException();
    }

    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiDocComment getDocComment() {
        throw new UnimplementedLintPsiApiException();
    }

    public boolean isDeprecated() {
        SourceTypeBinding binding = ((TypeDeclaration)this.mNativeNode).binding;
        return binding != null && (binding.modifiers & 0x100000) != 0;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    void sortChildren() {
        if (this.mFirstChild == null) {
            return;
        }
        PsiElement[] children = this.getChildren();
        Arrays.sort(children, (o1, o2) -> {
            int delta = o1.getTextRange().getStartOffset() - o2.getTextRange().getStartOffset();
            if (delta == 0) {
                delta = o1.getTextRange().getEndOffset() - o2.getTextRange().getEndOffset();
            }
            return delta;
        });
        EcjPsiSourceElement last = null;
        for (PsiElement child : children) {
            EcjPsiSourceElement element = (EcjPsiSourceElement)child;
            element.mPrevSibling = last;
            if (last == null) {
                this.mFirstChild = element;
                element.mPrevSibling = null;
            } else {
                last.mNextSibling = element;
            }
            this.mLastChild = element;
            last = element;
        }
        this.mLastChild.mNextSibling = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.mNativeNode;
        SourceTypeBinding binding = typeDeclaration.binding;
        if (o instanceof EcjPsiClass) {
            TypeDeclaration otherTypeDeclaration = (TypeDeclaration)((EcjPsiClass)o).getNativeNode();
            assert (otherTypeDeclaration != null);
            SourceTypeBinding otherBinding = otherTypeDeclaration.binding;
            if (binding == null || otherBinding == null) {
                return typeDeclaration.equals(otherTypeDeclaration);
            }
            return binding.equals(otherBinding);
        }
        if (o instanceof EcjPsiBinaryClass) {
            ReferenceBinding otherBinding = (ReferenceBinding)((EcjPsiBinaryClass)o).getBinding();
            return binding != null && otherBinding != null && binding.equals(otherBinding);
        }
        return false;
    }

    public int hashCode() {
        SourceTypeBinding binding = ((TypeDeclaration)this.mNativeNode).binding;
        return binding != null ? binding.hashCode() : 0;
    }

    public ReferenceBinding getBinding() {
        return ((TypeDeclaration)this.mNativeNode).binding;
    }
}

