/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.EcjSourceFile;
import com.android.tools.lint.psi.EcjPsiDirectory;
import com.android.tools.lint.psi.EcjPsiImportList;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiPackageStatement;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import java.io.File;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;

public class EcjPsiJavaFile
extends EcjPsiSourceElement
implements PsiJavaFile {
    private final EcjSourceFile mSource;
    private EcjPsiImportList mImportList;
    private EcjPsiPackageStatement mPackageStatement;
    private PsiClass[] mClasses;

    EcjPsiJavaFile(EcjPsiManager manager, EcjSourceFile source, CompilationUnitDeclaration node) {
        super(manager, (ASTNode)node);
        this.mSource = source;
    }

    void setImportList(EcjPsiImportList importList) {
        this.mImportList = importList;
    }

    void setPackageStatement(EcjPsiPackageStatement packageStatement) {
        this.mPackageStatement = packageStatement;
    }

    public void setClasses(PsiClass[] classes) {
        this.mClasses = classes;
    }

    public String getText(TextRange range) {
        char[] contents = this.mSource.getContents();
        int end = range.getEndOffset();
        if (end <= contents.length) {
            int start = range.getStartOffset();
            return new String(contents, start, end - start);
        }
        return "";
    }

    @Override
    public String getText() {
        return this.mSource.getSource();
    }

    @Override
    public boolean textMatches(CharSequence charSequence) {
        return this.getText().equals(charSequence.toString());
    }

    @Override
    public boolean textMatches(PsiElement psiElement) {
        return this.getText().equals(psiElement.getText());
    }

    public char[] getFileContents() {
        return this.mSource.getContents();
    }

    @Override
    public String toString() {
        return super.toString() + ":" + this.getName();
    }

    public PsiImportList getImportList() {
        return this.mImportList;
    }

    public PsiPackageStatement getPackageStatement() {
        return this.mPackageStatement;
    }

    public PsiClass[] getClasses() {
        return this.mClasses;
    }

    public String getPackageName() {
        return this.mPackageStatement != null ? this.mPackageStatement.getPackageName() : "";
    }

    @Override
    public String getName() {
        return new String(this.mSource.getFileName());
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return this;
    }

    @Override
    public EcjPsiDirectory getParent() {
        return null;
    }

    public PsiElement[] getOnDemandImports(boolean b, @Deprecated boolean b1) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiClass[] getSingleClassImports(@Deprecated boolean b) {
        throw new UnimplementedLintPsiApiException();
    }

    public String[] getImplicitlyImportedPackages() {
        return new String[]{"java.lang"};
    }

    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        PsiImportStatement importStatement = this.mImportList.findSingleClassImportStatement(qualifiedName);
        if (importStatement != null) {
            return importStatement.getImportReference();
        }
        importStatement = this.mImportList.findSingleImportStatement(qualifiedName);
        if (importStatement != null) {
            return importStatement.getImportReference();
        }
        return null;
    }

    public LanguageLevel getLanguageLevel() {
        return LanguageLevel.JDK_1_8;
    }

    public boolean isDirectory() {
        return false;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public PsiFile getOriginalFile() {
        return this;
    }

    public File getIoFile() {
        return this.mSource.getFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EcjPsiJavaFile that = (EcjPsiJavaFile)o;
        return this.mSource.equals((Object)that.mSource);
    }

    public int hashCode() {
        return this.mSource.hashCode();
    }
}

