/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.psi.EcjPsiBinaryAnnotation;
import com.android.tools.lint.psi.EcjPsiBinaryElement;
import com.android.tools.lint.psi.EcjPsiBuilder;
import com.android.tools.lint.psi.EcjPsiManager;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

class EcjPsiPackage
extends EcjPsiBinaryElement
implements PsiPackage,
PsiModifierList {
    private final PackageBinding mPackageBinding;
    private final PsiModifierList mModifierList;

    public EcjPsiPackage(EcjPsiManager manager, PackageBinding binding) {
        super(manager, (Binding)binding);
        PsiClass pkgInfoClass;
        this.mPackageBinding = binding;
        EcjPsiPackage modifierList = this;
        Binding pkgInfoBinding = binding.getTypeOrPackage(EcjPsiBuilder.PACKAGE_INFO);
        if (pkgInfoBinding instanceof ReferenceBinding && (pkgInfoClass = manager.findClass(pkgInfoBinding)) != null) {
            modifierList = pkgInfoClass.getModifierList();
        }
        this.mModifierList = modifierList;
    }

    public String getQualifiedName() {
        return EcjPsiManager.getTypeName(this.mPackageBinding.compoundName);
    }

    public String getName() {
        return new String(this.mPackageBinding.compoundName[this.mPackageBinding.compoundName.length - 1]);
    }

    public PsiPackage getParentPackage() {
        return null;
    }

    public PsiModifierList getAnnotationList() {
        return this.getModifierList();
    }

    public PsiModifierList getModifierList() {
        return this.mModifierList;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return false;
    }

    public boolean hasExplicitModifier(@PsiModifier.ModifierConstant String s) {
        return false;
    }

    public PsiAnnotation[] getAnnotations() {
        return this.getApplicableAnnotations();
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        return this.findAnnotations(false);
    }

    private PsiAnnotation[] findAnnotations(boolean includeSuper) {
        Collection<PsiAnnotation> external;
        ArrayList all = Lists.newArrayListWithExpectedSize((int)4);
        ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
        PackageBinding binding = this.mPackageBinding;
        AnnotationBinding[] annotations = binding.getAnnotations();
        int count = annotations.length;
        if (count > 0) {
            for (AnnotationBinding annotation : annotations) {
                if (annotation == null) continue;
                all.add(new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)this, annotation));
            }
        }
        if (manager != null && (external = manager.getAnnotations(binding)) != null) {
            all.addAll(external);
        }
        return EcjPsiManager.ensureUnique(all);
    }

    public PsiAnnotation findAnnotation(String s) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!s.equals(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    public PackageBinding getPackageBinding() {
        return this.mPackageBinding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EcjPsiPackage that = (EcjPsiPackage)o;
        return this.mPackageBinding != null ? this.mPackageBinding.equals(that.mPackageBinding) : that.mPackageBinding == null;
    }

    public int hashCode() {
        return this.mPackageBinding != null ? this.mPackageBinding.hashCode() : 0;
    }
}

