/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;

@Incubating
public abstract class AbstractLinkTask
extends DefaultTask
implements ObjectFilesToBinary {
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private boolean debuggable;
    private final RegularFileProperty outputFile;
    private final ListProperty<String> linkerArgs;
    private final ConfigurableFileCollection source;
    private final ConfigurableFileCollection libs = this.getProject().files(new Object[0]);

    public AbstractLinkTask() {
        this.source = this.getProject().files(new Object[0]);
        this.outputFile = this.newOutputFile();
        this.linkerArgs = this.getProject().getObjects().listProperty(String.class);
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return NativeToolChainInternal.Identifier.identify(AbstractLinkTask.this.toolChain, AbstractLinkTask.this.targetPlatform);
            }
        });
    }

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.getOutputFile().getParentFile();
    }

    @OutputFile
    public RegularFileProperty getBinaryFile() {
        return this.outputFile;
    }

    @Internal
    public File getOutputFile() {
        return (File)this.outputFile.getAsFile().getOrNull();
    }

    public void setOutputFile(File outputFile) {
        this.outputFile.set(outputFile);
    }

    public void setOutputFile(Provider<? extends RegularFile> outputFile) {
        this.outputFile.set(outputFile);
    }

    @Input
    public ListProperty<String> getLinkerArgs() {
        return this.linkerArgs;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @InputFiles
    @SkipWhenEmpty
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void setSource(FileCollection source) {
        this.source.setFrom((Iterable)source);
    }

    @InputFiles
    public ConfigurableFileCollection getLibs() {
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs.setFrom((Iterable)libs);
    }

    @Override
    public void source(Object source) {
        this.source.from(new Object[]{source});
    }

    public void lib(Object libs) {
        this.libs.from(new Object[]{libs});
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void link() {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getOutputs());
        cleaner.setDestinationDir(this.getDestinationDir());
        cleaner.execute();
        if (this.getSource().isEmpty()) {
            this.setDidWork(cleaner.getDidWork());
            return;
        }
        LinkerSpec spec = this.createLinkerSpec();
        spec.setTargetPlatform(this.getTargetPlatform());
        spec.setTempDir(this.getTemporaryDir());
        spec.setOutputFile(this.getOutputFile());
        spec.objectFiles((Iterable<File>)this.getSource());
        spec.libraries((Iterable<File>)this.getLibs());
        spec.args((List)this.getLinkerArgs().get());
        spec.setDebuggable(this.isDebuggable());
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        spec.setOperationLogger(operationLogger);
        Compiler compiler = (Compiler)Cast.uncheckedCast((Object)this.toolChain.select(this.targetPlatform).newCompiler(spec.getClass()));
        compiler = BuildOperationLoggingCompilerDecorator.wrap(compiler);
        WorkResult result = compiler.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    protected abstract LinkerSpec createLinkerSpec();
}

