/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.NonNullApi;
import org.gradle.api.Transformer;
import org.gradle.internal.FileUtils;
import org.gradle.internal.Transformers;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.DefaultCompilerVersion;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.AbstractPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultCommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultMutableCommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.MutableCommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativeplatform.toolchain.internal.PCHUtils;
import org.gradle.nativeplatform.toolchain.internal.SystemIncludesAwarePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.WindowsResourceCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Assembler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CppCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CppPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LibExeStaticLibraryArchiver;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LinkExeLinker;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Ucrt;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppToolChain;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsResourceCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolConfigurationInternal;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;

@NonNullApi
class VisualCppPlatformToolProvider
extends AbstractPlatformToolProvider
implements SystemIncludesAwarePlatformToolProvider {
    private final Map<ToolType, CommandLineToolConfigurationInternal> commandLineToolConfigurations;
    private final VisualCppInstall visualCpp;
    private final WindowsSdk sdk;
    private final Ucrt ucrt;
    private final NativePlatformInternal targetPlatform;
    private final ExecActionFactory execActionFactory;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final WorkerLeaseService workerLeaseService;

    VisualCppPlatformToolProvider(BuildOperationExecutor buildOperationExecutor, OperatingSystemInternal operatingSystem, Map<ToolType, CommandLineToolConfigurationInternal> commandLineToolConfigurations, VisualCppInstall visualCpp, WindowsSdk sdk, Ucrt ucrt, NativePlatformInternal targetPlatform, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, WorkerLeaseService workerLeaseService) {
        super(buildOperationExecutor, operatingSystem);
        this.commandLineToolConfigurations = commandLineToolConfigurations;
        this.visualCpp = visualCpp;
        this.sdk = sdk;
        this.ucrt = ucrt;
        this.targetPlatform = targetPlatform;
        this.execActionFactory = execActionFactory;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    public boolean producesImportLibrary() {
        return true;
    }

    @Override
    public boolean requiresDebugBinaryStripping() {
        return false;
    }

    @Override
    public String getSharedLibraryLinkFileName(String libraryName) {
        return FileUtils.withExtension((String)this.getSharedLibraryName(libraryName), (String)".lib");
    }

    @Override
    public ToolSearchResult isToolAvailable(ToolType toolType) {
        return new ToolSearchResult(){

            public boolean isAvailable() {
                return true;
            }

            public void explain(TreeVisitor<? super String> visitor) {
            }
        };
    }

    protected Compiler<CppCompileSpec> createCppCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C++ compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CppCompiler cppCompiler = new CppCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.CPP_COMPILER)), this.addDefinitions(CppCompileSpec.class), this.getObjectFileExtension(), true, this.workerLeaseService);
        OutputCleaningCompiler<CppCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    @Override
    protected Compiler<?> createCppPCHCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C++ PCH compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CppPCHCompiler cppPCHCompiler = new CppPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.CPP_COMPILER)), this.pchSpecTransforms(CppPCHCompileSpec.class), this.getPCHFileExtension(), true, this.workerLeaseService);
        OutputCleaningCompiler<CppPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CppPCHCompileSpec>(cppPCHCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    protected Compiler<CCompileSpec> createCCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CCompiler cCompiler = new CCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.C_COMPILER)), this.addDefinitions(CCompileSpec.class), this.getObjectFileExtension(), true, this.workerLeaseService);
        OutputCleaningCompiler<CCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CCompileSpec>(cCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    @Override
    protected Compiler<?> createCPCHCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("C PCH compiler", this.visualCpp.getCompiler(this.targetPlatform));
        CPCHCompiler cpchCompiler = new CPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.C_COMPILER)), this.pchSpecTransforms(CPCHCompileSpec.class), this.getPCHFileExtension(), true, this.workerLeaseService);
        OutputCleaningCompiler<CPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CPCHCompileSpec>(cpchCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    private <T extends NativeCompileSpec> VersionAwareCompiler<T> versionAwareCompiler(OutputCleaningCompiler<T> outputCleaningCompiler) {
        return new VersionAwareCompiler(outputCleaningCompiler, (CompilerVersion)new DefaultCompilerVersion("visualCpp", "Microsoft", this.visualCpp.getVersion()));
    }

    protected Compiler<AssembleSpec> createAssembler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Assembler", this.visualCpp.getAssembler(this.targetPlatform));
        return new Assembler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.ASSEMBLER)), this.addDefinitions(AssembleSpec.class), this.getObjectFileExtension(), false, this.workerLeaseService);
    }

    @Override
    protected Compiler<?> createObjectiveCppCompiler() {
        throw this.unavailableTool("Objective-C++ is not available on the Visual C++ toolchain");
    }

    @Override
    protected Compiler<?> createObjectiveCCompiler() {
        throw this.unavailableTool("Objective-C is not available on the Visual C++ toolchain");
    }

    protected Compiler<WindowsResourceCompileSpec> createWindowsResourceCompiler() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Windows resource compiler", this.sdk.getResourceCompiler(this.targetPlatform));
        String objectFileExtension = ".res";
        WindowsResourceCompiler windowsResourceCompiler = new WindowsResourceCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.WINDOW_RESOURCES_COMPILER)), this.addDefinitions(WindowsResourceCompileSpec.class), objectFileExtension, false, this.workerLeaseService);
        return new OutputCleaningCompiler<WindowsResourceCompileSpec>(windowsResourceCompiler, this.compilerOutputFileNamingSchemeFactory, objectFileExtension);
    }

    protected Compiler<LinkerSpec> createLinker() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Linker", this.visualCpp.getLinker(this.targetPlatform));
        return new LinkExeLinker(this.buildOperationExecutor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.LINKER)), this.addLibraryPath(), this.workerLeaseService);
    }

    protected Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
        CommandLineToolInvocationWorker commandLineTool = this.tool("Static library archiver", this.visualCpp.getArchiver(this.targetPlatform));
        return new LibExeStaticLibraryArchiver(this.buildOperationExecutor, commandLineTool, this.context(this.commandLineToolConfigurations.get((Object)ToolType.STATIC_LIB_ARCHIVER)), (Transformer<StaticLibraryArchiverSpec, StaticLibraryArchiverSpec>)Transformers.noOpTransformer(), this.workerLeaseService);
    }

    private CommandLineToolInvocationWorker tool(String toolName, File exe) {
        return new DefaultCommandLineToolInvocationWorker(toolName, exe, this.execActionFactory);
    }

    private CommandLineToolContext context(CommandLineToolConfigurationInternal commandLineToolConfiguration) {
        DefaultMutableCommandLineToolContext invocationContext = new DefaultMutableCommandLineToolContext();
        invocationContext.addPath(this.visualCpp.getPath(this.targetPlatform));
        invocationContext.addPath(this.sdk.getBinDir(this.targetPlatform));
        this.clearEnvironmentVars(invocationContext, "INCLUDE", "CL", "LIBPATH", "LINK", "LIB");
        invocationContext.setArgAction(commandLineToolConfiguration.getArgAction());
        return invocationContext;
    }

    private void clearEnvironmentVars(MutableCommandLineToolContext invocation, String ... names) {
        Map environmentVariables = Jvm.current().getInheritableEnvironmentVariables(System.getenv());
        for (String name : names) {
            Object value = environmentVariables.get(name);
            if (value == null) continue;
            VisualCppToolChain.LOGGER.warn("Ignoring value '{}' set for environment variable '{}'.", value, (Object)name);
            invocation.addEnvironmentVar(name, "");
        }
    }

    private <T extends NativeCompileSpec> Transformer<T, T> pchSpecTransforms(final Class<T> type) {
        return new Transformer<T, T>(){

            public T transform(T original) {
                ArrayList transformers = Lists.newArrayList();
                transformers.add(PCHUtils.getHeaderToSourceFileTransformer(type));
                transformers.add(VisualCppPlatformToolProvider.this.addDefinitions(type));
                Object next = original;
                for (Transformer transformer : transformers) {
                    next = (NativeCompileSpec)transformer.transform(next);
                }
                return next;
            }
        };
    }

    @Override
    public List<File> getSystemIncludes(ToolType compilerType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.visualCpp.getIncludePath(this.targetPlatform));
        builder.add((Object[])this.sdk.getIncludeDirs());
        if (this.ucrt != null) {
            builder.add((Object[])this.ucrt.getIncludeDirs());
        }
        return builder.build();
    }

    private <T extends NativeCompileSpec> Transformer<T, T> addDefinitions(Class<T> type) {
        return new Transformer<T, T>(){

            public T transform(T original) {
                for (Map.Entry<String, String> definition : VisualCppPlatformToolProvider.this.visualCpp.getDefinitions(VisualCppPlatformToolProvider.this.targetPlatform).entrySet()) {
                    original.define(definition.getKey(), definition.getValue());
                }
                return original;
            }
        };
    }

    private Transformer<LinkerSpec, LinkerSpec> addLibraryPath() {
        return new Transformer<LinkerSpec, LinkerSpec>(){

            public LinkerSpec transform(LinkerSpec original) {
                if (VisualCppPlatformToolProvider.this.ucrt == null) {
                    original.libraryPath(VisualCppPlatformToolProvider.this.visualCpp.getLibraryPath(VisualCppPlatformToolProvider.this.targetPlatform), VisualCppPlatformToolProvider.this.sdk.getLibDir(VisualCppPlatformToolProvider.this.targetPlatform));
                } else {
                    original.libraryPath(VisualCppPlatformToolProvider.this.visualCpp.getLibraryPath(VisualCppPlatformToolProvider.this.targetPlatform), VisualCppPlatformToolProvider.this.sdk.getLibDir(VisualCppPlatformToolProvider.this.targetPlatform), VisualCppPlatformToolProvider.this.ucrt.getLibDir(VisualCppPlatformToolProvider.this.targetPlatform));
                }
                return original;
            }
        };
    }

    public String getPCHFileExtension() {
        return ".pch";
    }

    @Override
    public String getLibrarySymbolFileName(String libraryPath) {
        return FileUtils.withExtension((String)this.getSharedLibraryName(libraryPath), (String)".pdb");
    }

    @Override
    public String getExecutableSymbolFileName(String executablePath) {
        return FileUtils.withExtension((String)this.getExecutableName(executablePath), (String)".pdb");
    }

    @Override
    public CompilerMetadata getCompilerMetadata() {
        throw new UnsupportedOperationException("Compiler metadata for Visual C++ is not yet implemented");
    }
}

