/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.Binding;
import android.databinding.tool.InverseBinding;
import android.databinding.tool.MergedBinding;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.TwoWayListenerExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.Location;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BindingTarget
implements LocationScopeProvider {
    List<Binding> mBindings = new ArrayList<Binding>();
    List<InverseBinding> mInverseBindings = new ArrayList<InverseBinding>();
    ExprModel mModel;
    ModelClass mResolvedClass;
    ResourceBundle.BindingTargetBundle mBundle;

    public BindingTarget(ResourceBundle.BindingTargetBundle bundle) {
        this.mBundle = bundle;
    }

    public boolean isUsed() {
        return this.mBundle.isUsed();
    }

    public void addBinding(String name, Expr expr) {
        if (SetterStore.get().isTwoWayEventAttribute(name)) {
            L.e("The attribute %s is a two-way binding event attribute and cannot be assigned.", name);
        }
        this.mBindings.add(new Binding(this, name, expr));
    }

    public String getInterfaceType() {
        return this.mBundle.getInterfaceType() == null ? this.mBundle.getFullClassName() : this.mBundle.getInterfaceType();
    }

    public InverseBinding addInverseBinding(String name, Expr expr, String bindingClass) {
        InverseBinding inverseBinding = new InverseBinding(this, name, expr, bindingClass);
        this.mInverseBindings.add(inverseBinding);
        expr.markAsBindingExpression();
        this.mBindings.add(new Binding(this, inverseBinding.getEventAttribute(), this.mModel.twoWayListenerExpr(inverseBinding), inverseBinding.getEventSetter()));
        return inverseBinding;
    }

    public InverseBinding addInverseBinding(String name, SetterStore.BindingGetterCall call) {
        InverseBinding inverseBinding = new InverseBinding(this, name, call);
        this.mInverseBindings.add(inverseBinding);
        TwoWayListenerExpr expr = this.mModel.twoWayListenerExpr(inverseBinding);
        expr.markAsBindingExpression();
        this.mBindings.add(new Binding(this, inverseBinding.getEventAttribute(), expr));
        return inverseBinding;
    }

    @Override
    public List<Location> provideScopeLocation() {
        return this.mBundle.provideScopeLocation();
    }

    public String getId() {
        return this.mBundle.getId();
    }

    public String getTag() {
        return this.mBundle.getTag();
    }

    public String getOriginalTag() {
        return this.mBundle.getOriginalTag();
    }

    public String getViewClass() {
        return this.mBundle.getFullClassName();
    }

    public ModelClass getResolvedType() {
        if (this.mResolvedClass == null) {
            this.mResolvedClass = ModelAnalyzer.getInstance().findClass(this.mBundle.getFullClassName(), this.mModel.getImports());
        }
        return this.mResolvedClass;
    }

    public String getIncludedLayout() {
        return this.mBundle.getIncludedLayout();
    }

    public boolean isBinder() {
        return this.mBundle.isBinder();
    }

    public boolean supportsTag() {
        return !SetterStore.get().isUntaggable(this.mBundle.getFullClassName());
    }

    public List<Binding> getBindings() {
        return this.mBindings;
    }

    public List<InverseBinding> getInverseBindings() {
        return this.mInverseBindings;
    }

    public ExprModel getModel() {
        return this.mModel;
    }

    public void setModel(ExprModel model) {
        this.mModel = model;
    }

    public void injectSafeUnboxing(ExprModel exprModel) {
        for (Binding binding : this.mBindings) {
            binding.injectSafeUnboxing(exprModel);
        }
    }

    public void resolveListeners() {
        for (Binding binding : this.mBindings) {
            try {
                Scope.enter(binding);
                binding.resolveListeners();
            }
            finally {
                Scope.exit();
            }
        }
    }

    public void resolveCallbackParams() {
        for (Binding binding : this.mBindings) {
            try {
                Scope.enter(binding);
                binding.resolveCallbackParams();
            }
            finally {
                Scope.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveTwoWayExpressions() {
        ArrayList<Binding> bindings = new ArrayList<Binding>(this.mBindings);
        for (Binding binding : bindings) {
            try {
                Scope.enter(binding);
                binding.resolveTwoWayExpressions();
            }
            finally {
                Scope.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveMultiSetters() {
        L.d("resolving multi setters for %s", this.getId());
        SetterStore setterStore = SetterStore.get();
        String[] attributes = new String[this.mBindings.size()];
        ModelClass[] types = new ModelClass[this.mBindings.size()];
        boolean hasObservableFields = false;
        for (int i = 0; i < this.mBindings.size(); ++i) {
            Binding binding = this.mBindings.get(i);
            try {
                Scope.enter(binding);
                attributes[i] = binding.getName();
                ModelClass type = binding.getExpr().getResolvedType();
                if (type.getObservableGetterName() != null) {
                    hasObservableFields = true;
                    types[i] = binding.getExpr().unwrapObservableField().getResolvedType();
                    continue;
                }
                types[i] = type;
                continue;
            }
            finally {
                Scope.exit();
            }
        }
        List<SetterStore.MultiAttributeSetter> multiAttributeSetterCalls = setterStore.getMultiAttributeSetterCalls(attributes, this.getResolvedType(), types);
        List<MergedBinding> merged = this.createMultiSetters(multiAttributeSetterCalls, hasObservableFields);
        if (hasObservableFields) {
            attributes = new String[this.mBindings.size()];
            types = new ModelClass[this.mBindings.size()];
            for (int i = 0; i < this.mBindings.size(); ++i) {
                Binding binding = this.mBindings.get(i);
                try {
                    Scope.enter(binding);
                    attributes[i] = binding.getName();
                    types[i] = binding.getExpr().getResolvedType();
                    continue;
                }
                finally {
                    Scope.exit();
                }
            }
            multiAttributeSetterCalls = setterStore.getMultiAttributeSetterCalls(attributes, this.getResolvedType(), types);
            List<MergedBinding> observableFieldCalls = this.createMultiSetters(multiAttributeSetterCalls, false);
            merged.addAll(observableFieldCalls);
        }
        this.mBindings.addAll(merged);
    }

    private List<MergedBinding> createMultiSetters(List<SetterStore.MultiAttributeSetter> multiAttributeSetterCalls, boolean unwrapObservableFields) {
        ArrayList<MergedBinding> mergeBindings = new ArrayList<MergedBinding>();
        if (multiAttributeSetterCalls.isEmpty()) {
            return mergeBindings;
        }
        HashMap<String, Binding> lookup = new HashMap<String, Binding>();
        for (Binding binding : this.mBindings) {
            String name = binding.getName();
            if (name.startsWith("android:")) {
                lookup.put(name, binding);
                continue;
            }
            int ind = name.indexOf(":");
            if (ind == -1) {
                lookup.put(name, binding);
                continue;
            }
            lookup.put(name.substring(ind + 1), binding);
        }
        for (SetterStore.MultiAttributeSetter setter : multiAttributeSetterCalls) {
            L.d("resolved %s", setter);
            ArrayList<Binding> mergedBindings = new ArrayList<Binding>();
            for (String attribute : setter.attributes) {
                Binding binding = (Binding)lookup.get(attribute);
                Preconditions.checkNotNull(binding, "cannot find binding for %s", attribute);
                mergedBindings.add(binding);
                if (!unwrapObservableFields) continue;
                binding.unwrapObservableFieldExpression();
            }
            this.mBindings.removeAll(mergedBindings);
            MergedBinding mergedBinding = new MergedBinding(this.getModel(), setter, this, mergedBindings);
            mergeBindings.add(mergedBinding);
        }
        return mergeBindings;
    }
}

