/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.annotationprocessor.ProcessExpressions;
import android.databinding.tool.CompilerArguments;
import android.databinding.tool.Context;
import android.databinding.tool.util.L;
import android.databinding.tool.util.LoggedErrorException;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class GenerationalClassUtil {
    private List[] mCache = null;
    private List<File> mInputDirs;
    private File mIncrementalOutDir;
    private ExtensionFilter[] mEnabledExtensions;

    public static GenerationalClassUtil create(CompilerArguments args2) {
        return new GenerationalClassUtil(args2);
    }

    public GenerationalClassUtil(File inputFolder, ExtensionFilter ... extensions) {
        if (inputFolder == null || !inputFolder.exists()) {
            L.e("Invalid input folder " + inputFolder, new Object[0]);
        }
        this.mEnabledExtensions = extensions;
        this.mIncrementalOutDir = null;
        this.mInputDirs = Collections.singletonList(inputFolder);
    }

    private GenerationalClassUtil(CompilerArguments args2) {
        this.mEnabledExtensions = ExtensionFilter.values();
        this.mIncrementalOutDir = StringUtils.isNotBlank(args2.getAarOutDir() != null ? args2.getAarOutDir().getPath() : null) ? new File(args2.getAarOutDir(), "bin-files") : null;
        this.mInputDirs = new ArrayList<File>();
        if (StringUtils.isNotBlank(args2.getDependencyArtifactsDir().getPath())) {
            this.mInputDirs.add(args2.getDependencyArtifactsDir());
        }
    }

    public static GenerationalClassUtil get() {
        return Context.getGenerationalClassUtil();
    }

    public <T extends Serializable> List<T> loadObjects(ExtensionFilter filter) {
        if (this.mCache == null) {
            this.buildCache();
        }
        List result = this.mCache[filter.ordinal()];
        Preconditions.checkNotNull(result, "Invalid filter " + (Object)((Object)filter), new Object[0]);
        return result;
    }

    private void buildCache() {
        L.d("building generational class cache", new Object[0]);
        this.mCache = new List[ExtensionFilter.values().length];
        for (ExtensionFilter filter : this.mEnabledExtensions) {
            this.mCache[filter.ordinal()] = new ArrayList();
        }
        this.loadFromBuildInfo();
    }

    private void loadFromBuildInfo() {
        this.mInputDirs.forEach(this::loadFromDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDirectory(File directory) {
        if (directory == null || !directory.canRead() || !directory.isDirectory()) {
            return;
        }
        for (File file : FileUtils.listFiles((File)directory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            for (ExtensionFilter filter : this.mEnabledExtensions) {
                if (!filter.accept(file.getName())) continue;
                FileInputStream inputStream = null;
                try {
                    inputStream = FileUtils.openInputStream((File)file);
                    Serializable item = this.fromInputStream(inputStream);
                    if (item == null) continue;
                    this.mCache[filter.ordinal()].add(item);
                    L.d("loaded item %s from file", item);
                }
                catch (IOException e) {
                    L.e(e, "Could not merge in Bindables from %s", file.getAbsolutePath());
                }
                catch (ClassNotFoundException e) {
                    L.e(e, "Could not read Binding properties intermediate file. %s", file.getAbsolutePath());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
    }

    private Serializable fromInputStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        IgnoreSerialIdObjectInputStream in = new IgnoreSerialIdObjectInputStream(inputStream);
        return (Serializable)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIntermediateFile(String packageName, String fileName, Serializable object) {
        block7: {
            ObjectOutputStream oos = null;
            FileOutputStream ios = null;
            try {
                try {
                    Preconditions.checkNotNull(this.mIncrementalOutDir, "incremental out directory should be set to aar output directory.", new Object[0]);
                    this.mIncrementalOutDir.mkdirs();
                    File out = new File(this.mIncrementalOutDir, packageName + "-" + fileName);
                    ios = new FileOutputStream(out);
                    oos = new ObjectOutputStream(ios);
                    oos.writeObject(object);
                    oos.close();
                    L.d("wrote intermediate bindable file %s %s", packageName, fileName);
                    IOUtils.closeQuietly((OutputStream)oos);
                }
                catch (IOException e) {
                    L.e(e, "Could not write to intermediate file: %s", fileName);
                    break block7;
                }
                finally {
                    IOUtils.closeQuietly(oos);
                    IOUtils.closeQuietly(ios);
                }
                IOUtils.closeQuietly((OutputStream)ios);
            }
            catch (LoggedErrorException loggedErrorException) {
                // empty catch block
            }
        }
    }

    private static class IgnoreSerialIdObjectInputStream
    extends ObjectInputStream {
        public IgnoreSerialIdObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass original = super.readClassDescriptor();
            if (ProcessExpressions.IntermediateV1.class.getName().equals(original.getName())) {
                return ObjectStreamClass.lookup(ProcessExpressions.IntermediateV1.class);
            }
            return original;
        }
    }

    public static enum ExtensionFilter {
        BR("-br.bin"),
        LAYOUT("-layoutinfo.bin"),
        SETTER_STORE("-setter_store.bin");

        private final String mExtension;

        private ExtensionFilter(String extension) {
            this.mExtension = extension;
        }

        public boolean accept(String entryName) {
            return entryName.endsWith(this.mExtension);
        }

        public String getExtension() {
            return this.mExtension;
        }
    }
}

