/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.jar.Manifest;

public final class NonFinalPluginExpiry {
    static final Period DEFAULT_RETIREMENT_AGE_FOR_NON_RELEASE = Period.ofDays(40);

    private NonFinalPluginExpiry() {
    }

    public static void verifyRetirementAge() {
        URLClassLoader cl = (URLClassLoader)NonFinalPluginExpiry.class.getClassLoader();
        try (InputStream inputStream = cl.findResource("META-INF/MANIFEST.MF").openStream();){
            NonFinalPluginExpiry.verifyRetirementAge(LocalDate.now(), new Manifest(inputStream), System.getenv("ANDROID_DAILY_OVERRIDE"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void verifyRetirementAge(LocalDate now, Manifest manifest, String dailyOverride) {
        String version = manifest.getMainAttributes().getValue("Plugin-Version");
        Period retirementAge = NonFinalPluginExpiry.getRetirementAge(version);
        if (retirementAge == null) {
            return;
        }
        String inceptionDateAttr = manifest.getMainAttributes().getValue("Inception-Date");
        if (inceptionDateAttr == null) {
            return;
        }
        LocalDate inceptionDate = LocalDate.parse(inceptionDateAttr, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDate expiryDate = inceptionDate.plus(retirementAge);
        if (now.compareTo(expiryDate) > 0) {
            MessageDigest crypt;
            try {
                crypt = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                return;
            }
            crypt.reset();
            try {
                crypt.update(String.format("%1$s:%2$s:%3$s", now.getYear(), now.getMonthValue() - 1, now.getDayOfMonth()).getBytes("utf8"));
            }
            catch (UnsupportedEncodingException e) {
                return;
            }
            String overrideValue = new BigInteger(1, crypt.digest()).toString(16);
            if (dailyOverride == null) {
                String message = String.format("The android gradle plugin version %1$s is too old, please update to the latest version.\n\nTo override this check from the command line please set the ANDROID_DAILY_OVERRIDE environment variable to \"%2$s\"", version, overrideValue);
                System.err.println(message);
                throw new AndroidGradlePluginTooOldException(message);
            }
            if (!dailyOverride.equals(overrideValue)) {
                String message = String.format("The android gradle plugin version %1$s is too old,please update to the latest version.\n\nThe ANDROID_DAILY_OVERRIDE value is outdated. Please set the ANDROID_DAILY_OVERRIDE environment variable to \"%2$s\"", version, overrideValue);
                System.err.println(message);
                throw new AndroidGradlePluginTooOldException(message);
            }
        }
    }

    private static Period getRetirementAge(String version) {
        if (version == null || version.contains("rc") || version.contains("beta") || version.contains("alpha") || version.contains("preview")) {
            return DEFAULT_RETIREMENT_AGE_FOR_NON_RELEASE;
        }
        return null;
    }

    public static final class AndroidGradlePluginTooOldException
    extends RuntimeException {
        public AndroidGradlePluginTooOldException(String message) {
            super(message);
        }
    }
}

