/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

class JarFileIssueRegistry
extends IssueRegistry {
    private static final String MF_LINT_REGISTRY_OLD = "Lint-Registry";
    private static final String MF_LINT_REGISTRY = "Lint-Registry-v2";
    private static Map<File, SoftReference<JarFileIssueRegistry>> sCache;
    private final List<Issue> myIssues = Lists.newArrayList();
    private boolean mHasLegacyDetectors;

    public boolean hasLegacyDetectors() {
        return this.mHasLegacyDetectors;
    }

    static JarFileIssueRegistry get(LintClient client, File jarFile) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (sCache == null) {
            sCache = new HashMap<File, SoftReference<JarFileIssueRegistry>>();
        } else {
            JarFileIssueRegistry registry;
            SoftReference<JarFileIssueRegistry> reference = sCache.get(jarFile);
            if (reference != null && (registry = reference.get()) != null) {
                return registry;
            }
        }
        IssueRegistry.reset();
        JarFileIssueRegistry registry = new JarFileIssueRegistry(client, jarFile);
        sCache.put(jarFile, new SoftReference<JarFileIssueRegistry>(registry));
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFileIssueRegistry(LintClient client, File file) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        try (JarFile jarFile = null;){
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            Object object = attrs.get(new Attributes.Name(MF_LINT_REGISTRY));
            boolean isLegacy = false;
            if (object == null && (object = attrs.get(new Attributes.Name(MF_LINT_REGISTRY_OLD))) != null) {
                isLegacy = true;
            }
            if (object instanceof String) {
                String className = (String)object;
                URL url = SdkUtils.fileToUrl((File)file);
                ClassLoader loader = client.createUrlClassLoader(new URL[]{url}, JarFileIssueRegistry.class.getClassLoader());
                Class<?> registryClass = Class.forName(className, true, loader);
                IssueRegistry registry = (IssueRegistry)registryClass.newInstance();
                this.myIssues.addAll(registry.getIssues());
                if (isLegacy) {
                    for (Issue issue : this.myIssues) {
                        EnumSet<Scope> scope = issue.getImplementation().getScope();
                        if (!scope.contains((Object)Scope.JAVA_FILE) && !scope.contains((Object)Scope.JAVA_LIBRARIES) && !scope.contains((Object)Scope.ALL_JAVA_FILES)) continue;
                        this.mHasLegacyDetectors = true;
                        break;
                    }
                }
                if (loader instanceof URLClassLoader) {
                    JarFileIssueRegistry.loadAndCloseURLClassLoader(client, file, (URLClassLoader)loader);
                }
            } else {
                client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", file.getPath(), MF_LINT_REGISTRY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAndCloseURLClassLoader(LintClient client, File file, URLClassLoader loader) {
        try {
            Method closeMethod = loader.getClass().getDeclaredMethod("close", new Class[0]);
            try (FileInputStream inputStream = new FileInputStream(file);
                 JarInputStream jarInputStream = new JarInputStream(inputStream);){
                ZipEntry entry = jarInputStream.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.endsWith(".class")) {
                        name = name.substring(0, name.length() - ".class".length());
                        name = name.replace('/', '.');
                        try {
                            Class.forName(name, true, loader);
                        }
                        catch (Throwable e) {
                            client.log(Severity.ERROR, e, "Failed to prefetch " + name + " from " + file, new Object[0]);
                        }
                    }
                    entry = jarInputStream.getNextEntry();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    closeMethod.invoke((Object)loader, new Object[0]);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public List<Issue> getIssues() {
        return this.myIssues;
    }
}

