/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturePreviews {
    private final Set<Feature> activeFeatures;
    private final EnumSet<Feature> enabledFeatures = EnumSet.noneOf(Feature.class);

    public FeaturePreviews() {
        EnumSet<Feature> tmpActiveSet = EnumSet.noneOf(Feature.class);
        for (Feature feature : Feature.values()) {
            if (!feature.isActive()) continue;
            tmpActiveSet.add(feature);
        }
        this.activeFeatures = Collections.unmodifiableSet(tmpActiveSet);
    }

    public void enableFeature(Feature feature) {
        if (feature.isActive()) {
            this.enabledFeatures.add(feature);
        }
    }

    public boolean isFeatureEnabled(Feature feature) {
        return feature.isActive() && this.enabledFeatures.contains((Object)feature);
    }

    public void enableFeature(String name) {
        this.enableFeature(Feature.withName(name));
    }

    public boolean isFeatureEnabled(String name) {
        return this.isFeatureEnabled(Feature.withName(name));
    }

    public Set<Feature> getActiveFeatures() {
        return this.activeFeatures;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        IMPROVED_POM_SUPPORT(true),
        GRADLE_METADATA(true);

        private final boolean active;

        public static Feature withName(String name) {
            try {
                return Feature.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("There is no feature named " + name);
            }
        }

        private Feature(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

