/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.hash.HashCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoringResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final Set<String> ignores;
    private final ImmutableSet<PathMatcher> ignoreMatchers;

    public IgnoringResourceHasher(Set<String> ignores, ResourceHasher delegate) {
        this.delegate = delegate;
        this.ignores = ImmutableSet.copyOf(ignores);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String ignore : ignores) {
            PathMatcher matcher = PatternMatcherFactory.compile((boolean)true, (String)ignore);
            builder.add((Object)matcher);
        }
        this.ignoreMatchers = builder.build();
    }

    @Override
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        if (this.shouldBeIgnored(fileSnapshot.getRelativePath())) {
            return null;
        }
        return this.delegate.hash(fileSnapshot);
    }

    @Override
    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        if (this.shouldBeIgnored(RelativePath.parse((boolean)true, (String)zipEntry.getName()))) {
            return null;
        }
        return this.delegate.hash(zipEntry, zipInput);
    }

    private boolean shouldBeIgnored(RelativePath relativePath) {
        if (this.ignoreMatchers.isEmpty()) {
            return false;
        }
        for (PathMatcher ignoreSpec : this.ignoreMatchers) {
            if (!ignoreSpec.matches(relativePath.getSegments(), 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendConfigurationToHasher(BuildCacheHasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
        for (String ignore : this.ignores) {
            hasher.putString((CharSequence)ignore);
        }
        this.delegate.appendConfigurationToHasher(hasher);
    }
}

