/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCollection
implements FileCollectionInternal {
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    public File getSingleFile() throws IllegalStateException {
        Set files = this.getFiles();
        if (files.isEmpty()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        if (files.size() != 1) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains %d files.", this.getDisplayName(), files.size()));
        }
        return (File)files.iterator().next();
    }

    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    public String getAsPath() {
        return GUtil.asPath((Iterable)this.getFiles());
    }

    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this, collection);
    }

    public FileCollection minus(final FileCollection collection) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            public Set<File> getFiles() {
                LinkedHashSet<File> files = new LinkedHashSet<File>(AbstractFileCollection.this.getFiles());
                files.removeAll(collection.getFiles());
                return files;
            }
        };
    }

    public FileCollection add(FileCollection collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.format("%s does not allow modification.", this.getCapDisplayName()));
    }

    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> fileTrees = new ArrayList<DirectoryFileTree>();
        for (File file : this.getFiles()) {
            if (!file.isFile()) continue;
            fileTrees.add(new FileBackedDirectoryFileTree(file));
        }
        return fileTrees;
    }

    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    public FileCollection stopExecutionIfEmpty() {
        if (this.isEmpty()) {
            throw new StopExecutionException(String.format("%s does not contain any files.", this.getCapDisplayName()));
        }
        return this;
    }

    public Object asType(Class<?> type) throws UnsupportedOperationException {
        if (type.isAssignableFrom(Set.class)) {
            return this.getFiles();
        }
        if (type.isAssignableFrom(List.class)) {
            return new ArrayList(this.getFiles());
        }
        if (type.isAssignableFrom(File[].class)) {
            Set files = this.getFiles();
            return files.toArray(new File[0]);
        }
        if (type.isAssignableFrom(File.class)) {
            return this.getSingleFile();
        }
        if (type.isAssignableFrom(FileCollection.class)) {
            return this;
        }
        if (type.isAssignableFrom(FileTree.class)) {
            return this.getAsFileTree();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert %s to type %s, as this type is not supported.", this.getDisplayName(), type.getSimpleName()));
    }

    public TaskDependency getBuildDependencies() {
        return new DefaultTaskDependency();
    }

    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void visitContents(FileCollectionResolveContext context) {
                ResolvableFileCollectionResolveContext nested = context.newContext();
                nested.add(AbstractFileCollection.this);
                context.add(nested.resolveAsFileTrees());
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(AbstractFileCollection.this);
            }

            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }
        };
    }

    public FileCollection filter(Closure filterClosure) {
        return this.filter((Spec<? super File>)Specs.convertClosureToSpec((Closure)filterClosure));
    }

    public FileCollection filter(final Spec<? super File> filterSpec) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            public Set<File> getFiles() {
                return (Set)CollectionUtils.filter((Iterable)((Object)AbstractFileCollection.this), new LinkedHashSet(), (Spec)filterSpec);
            }
        };
    }

    protected String getCapDisplayName() {
        return StringUtils.capitalize((String)this.getDisplayName());
    }

    @Override
    public void visitRootElements(FileCollectionVisitor visitor) {
        visitor.visitCollection(this);
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        for (File file : this.getFiles()) {
            builder.add(file);
        }
    }
}

