/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.nativeintegration.filesystem.Chmod;

public class ZipFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final File zipFile;
    private final File tmpDir;
    private final Chmod chmod;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileHasher fileHasher;

    public ZipFileTree(File zipFile, File tmpDir, Chmod chmod, DirectoryFileTreeFactory directoryFileTreeFactory, FileHasher fileHasher) {
        this.zipFile = zipFile;
        this.tmpDir = tmpDir;
        this.chmod = chmod;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileHasher = fileHasher;
    }

    public String getDisplayName() {
        return String.format("ZIP '%s'", this.zipFile);
    }

    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor visitor) {
        if (!this.zipFile.exists()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it does not exist.", this.getDisplayName()));
        }
        if (!this.zipFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
        }
        AtomicBoolean stopFlag = new AtomicBoolean();
        try {
            ZipFile zip = new ZipFile(this.zipFile);
            File expandedDir = this.getExpandedDir();
            try {
                TreeMap<String, ZipEntry> entriesByName = new TreeMap<String, ZipEntry>();
                Enumeration entries = zip.getEntries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    entriesByName.put(entry.getName(), entry);
                }
                Iterator sortedEntries = entriesByName.values().iterator();
                while (!stopFlag.get() && sortedEntries.hasNext()) {
                    ZipEntry entry = (ZipEntry)sortedEntries.next();
                    if (entry.isDirectory()) {
                        visitor.visitDir((FileVisitDetails)new DetailsImpl(this.zipFile, expandedDir, entry, zip, stopFlag, this.chmod));
                        continue;
                    }
                    visitor.visitFile((FileVisitDetails)new DetailsImpl(this.zipFile, expandedDir, entry, zip, stopFlag, this.chmod));
                }
            }
            finally {
                zip.close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not expand %s.", this.getDisplayName()), (Throwable)e);
        }
    }

    private File getBackingFile() {
        return this.zipFile;
    }

    private File getExpandedDir() {
        String expandedDirName = this.zipFile.getName() + "_" + this.fileHasher.hash(this.zipFile);
        return new File(this.tmpDir, expandedDirName);
    }

    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        builder.add(this.zipFile);
    }

    public void visitTreeOrBackingFile(FileVisitor visitor) {
        File backingFile = this.getBackingFile();
        if (backingFile != null) {
            new SingletonFileTree(backingFile).visit(visitor);
        } else {
            this.visit(visitor);
        }
    }

    private static class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final File originalFile;
        private final File expandedDir;
        private final ZipEntry entry;
        private final ZipFile zip;
        private final AtomicBoolean stopFlag;
        private File file;

        public DetailsImpl(File originalFile, File expandedDir, ZipEntry entry, ZipFile zip, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod);
            this.originalFile = originalFile;
            this.expandedDir = expandedDir;
            this.entry = entry;
            this.zip = zip;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("zip entry %s!%s", this.originalFile, this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.expandedDir, this.entry.getName());
                if (!this.file.exists()) {
                    this.copyTo(this.file);
                }
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }

        public int getMode() {
            int unixMode = this.entry.getUnixMode() & 0x1FF;
            if (unixMode == 0) {
                unixMode = this.isDirectory() ? 493 : 420;
            }
            return unixMode;
        }
    }
}

