/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import org.gradle.api.internal.tasks.properties.NestedPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.PropertyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNestedPropertyContext<T extends PropertyNode<T>>
implements NestedPropertyContext<T> {
    private final PropertyMetadataStore metadataStore;

    public static <T extends PropertyNode<T>> void collectNestedProperties(T initial, NestedPropertyContext<T> context) {
        ArrayDeque<T> queue = new ArrayDeque<T>();
        queue.add(initial);
        while (!queue.isEmpty()) {
            PropertyNode nestedNode = (PropertyNode)queue.remove();
            if (context.isIterable(nestedNode)) {
                Iterators.addAll(queue, nestedNode.getIterator());
                continue;
            }
            context.addNested(nestedNode);
        }
    }

    public AbstractNestedPropertyContext(PropertyMetadataStore metadataStore) {
        this.metadataStore = metadataStore;
    }

    @Override
    public boolean isIterable(T node) {
        return !node.isRoot() && Iterable.class.isAssignableFrom(node.getBeanClass()) && !this.metadataStore.getTypeMetadata(node.getBeanClass()).isAnnotated();
    }
}

