/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.AbstractPropertyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanNode
extends AbstractPropertyNode<BeanNode> {
    private final Object bean;

    public BeanNode(@Nullable String propertyName, Object bean) {
        super(propertyName, Preconditions.checkNotNull((Object)bean, (Object)("Null is not allowed as nested property '" + propertyName + "'")).getClass());
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public Iterator<BeanNode> getIterator() {
        return Iterators.transform(((Iterable)this.bean).iterator(), (Function)new Function<Object, BeanNode>(){
            private int count = 0;

            public BeanNode apply(@Nullable Object input) {
                String childPropertyName = BeanNode.this.getQualifiedPropertyName("$" + this.count++);
                return new BeanNode(childPropertyName, Preconditions.checkNotNull((Object)input, (Object)("Null is not allowed as nested property '" + childPropertyName + "'")));
            }
        });
    }
}

