/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import com.google.common.annotations.VisibleForTesting;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.ConvertedClosure;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.properties.AbstractNestedPropertyContext;
import org.gradle.api.internal.tasks.properties.BeanNode;
import org.gradle.api.internal.tasks.properties.NestedPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBeanAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Nested.class;
    }

    @Override
    public void visitPropertyValue(PropertyValue propertyValue, PropertyVisitor visitor, PropertySpecFactory specFactory, NestedPropertyContext<BeanNode> context) {
        Object nested;
        try {
            nested = propertyValue.getValue();
        }
        catch (Exception e) {
            visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyValue.getPropertyName(), new InvalidPropertyValue(e)));
            return;
        }
        if (nested != null) {
            AbstractNestedPropertyContext.collectNestedProperties(new BeanNode(propertyValue.getPropertyName(), nested), new ImplementationDeclaringPropertyContext(context, visitor, specFactory));
        } else if (!propertyValue.isOptional()) {
            visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyValue.getPropertyName(), new AbsentPropertyValue()));
        }
    }

    private static void visitImplementation(BeanNode node, PropertyVisitor visitor, PropertySpecFactory specFactory) {
        DefaultTaskInputPropertySpec implementation = specFactory.createInputPropertySpec(node.getQualifiedPropertyName("class"), new ImplementationPropertyValue(NestedBeanAnnotationHandler.getImplementationClass(node.getBean())));
        implementation.optional(false);
        visitor.visitInputProperty(implementation);
    }

    @VisibleForTesting
    static Class<?> getImplementationClass(Object bean) {
        if (Proxy.isProxyClass(bean.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(bean);
            if (invocationHandler instanceof ConvertedClosure) {
                Object delegate = ((ConvertedClosure)invocationHandler).getDelegate();
                return delegate.getClass();
            }
            return invocationHandler.getClass();
        }
        return bean.getClass();
    }

    private static class AbsentPropertyValue
    implements ValidatingValue {
        private AbsentPropertyValue() {
        }

        @Nullable
        public Object call() {
            return null;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            context.recordValidationMessage(TaskValidationContext.Severity.ERROR, String.format("No value has been specified for property '%s'.", propertyName));
        }
    }

    private static class InvalidPropertyValue
    implements ValidatingValue {
        private final Exception exception;

        public InvalidPropertyValue(Exception exception) {
            this.exception = exception;
        }

        @Nullable
        public Object call() {
            return null;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplementationPropertyValue
    implements ValidatingValue {
        private final Class<?> beanClass;

        public ImplementationPropertyValue(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        @Override
        public Object call() {
            return this.beanClass;
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplementationDeclaringPropertyContext
    implements NestedPropertyContext<BeanNode> {
        private final NestedPropertyContext<BeanNode> delegate;
        private final PropertyVisitor visitor;
        private final PropertySpecFactory specFactory;

        public ImplementationDeclaringPropertyContext(NestedPropertyContext<BeanNode> delegate, PropertyVisitor visitor, PropertySpecFactory specFactory) {
            this.delegate = delegate;
            this.visitor = visitor;
            this.specFactory = specFactory;
        }

        @Override
        public void addNested(BeanNode node) {
            NestedBeanAnnotationHandler.visitImplementation(node, this.visitor, this.specFactory);
            this.delegate.addNested(node);
        }

        @Override
        public boolean isIterable(BeanNode node) {
            return this.delegate.isIterable(node);
        }
    }
}

