/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Set;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.initialization.BuildIdentity;
import org.gradle.internal.service.ServiceRegistry;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final IncludedBuildTaskGraph includedBuildTaskGraph;
    private final ServiceRegistry serviceRegistry;
    private BuildIdentifier currentBuild;

    public CompositeBuildClassPathInitializer(IncludedBuildTaskGraph includedBuildTaskGraph, ServiceRegistry serviceRegistry) {
        this.includedBuildTaskGraph = includedBuildTaskGraph;
        this.serviceRegistry = serviceRegistry;
    }

    public void execute(Configuration classpath) {
        ArtifactCollection artifacts = classpath.getIncoming().getArtifacts();
        for (ResolvedArtifactResult artifactResult : artifacts.getArtifacts()) {
            ComponentArtifactIdentifier componentArtifactIdentifier = artifactResult.getId();
            this.build(this.getCurrentBuild(), componentArtifactIdentifier);
        }
    }

    private BuildIdentifier getBuildIdentifier(CompositeProjectComponentArtifactMetadata artifact) {
        return artifact.getComponentId().getBuild();
    }

    private BuildIdentifier getCurrentBuild() {
        if (this.currentBuild == null) {
            this.currentBuild = ((BuildIdentity)this.serviceRegistry.get(BuildIdentity.class)).getCurrentBuild();
        }
        return this.currentBuild;
    }

    public void build(BuildIdentifier requestingBuild, ComponentArtifactIdentifier artifact) {
        if (artifact instanceof CompositeProjectComponentArtifactMetadata) {
            CompositeProjectComponentArtifactMetadata compositeBuildArtifact = (CompositeProjectComponentArtifactMetadata)artifact;
            BuildIdentifier targetBuild = this.getBuildIdentifier(compositeBuildArtifact);
            assert (!requestingBuild.equals(targetBuild));
            Set<String> tasks = compositeBuildArtifact.getTasks();
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.addTask(requestingBuild, targetBuild, taskName);
            }
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.awaitCompletion(targetBuild, taskName);
            }
        }
    }
}

