/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.pom.DependencyVersions;
import com.android.tools.build.jetifier.core.pom.PomDependency;
import com.android.tools.build.jetifier.core.pom.PomRewriteRule;
import com.android.tools.build.jetifier.core.rule.RewriteRulesMap;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.FileMapping;
import com.android.tools.build.jetifier.processor.archive.Archive;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.Transformer;
import com.android.tools.build.jetifier.processor.transform.bytecode.ByteCodeTransformer;
import com.android.tools.build.jetifier.processor.transform.metainf.MetaInfTransformer;
import com.android.tools.build.jetifier.processor.transform.pom.PomDocument;
import com.android.tools.build.jetifier.processor.transform.pom.PomScanner;
import com.android.tools.build.jetifier.processor.transform.proguard.ProGuardTransformer;
import com.android.tools.build.jetifier.processor.transform.resource.XmlResourcesTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\rJ\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005H\u0002J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\b\b\u0002\u0010!\u001a\u00020\u000fJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0016\u0010%\u001a\u00020#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0005H\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/build/jetifier/processor/Processor;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "transformers", "", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;Ljava/util/List;)V", "newDependenciesRegex", "Lkotlin/text/Regex;", "oldDependenciesRegex", "getDependenciesMap", "", "", "filterOutBaseLibrary", "", "isNewDependencyFile", "aarOrJarFile", "Ljava/io/File;", "isOldDependencyFile", "loadLibraries", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "inputLibraries", "", "Lcom/android/tools/build/jetifier/processor/FileMapping;", "mapDependency", "depNotation", "scanPomFiles", "Lcom/android/tools/build/jetifier/processor/transform/pom/PomDocument;", "libraries", "transform", "", "input", "copyUnmodifiedLibsAlso", "transformLibrary", "", "archive", "transformPomFiles", "files", "visit", "archiveFile", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "Companion", "jetifier-processor"})
public final class Processor
implements ArchiveItemVisitor {
    private final List<Regex> oldDependenciesRegex;
    private final List<Regex> newDependenciesRegex;
    private final TransformationContext context;
    private final List<Transformer> transformers;
    private static final String TAG = "Processor";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> transform(@NotNull Set<FileMapping> input, boolean copyUnmodifiedLibsAlso) {
        Archive it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Archive it2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Object element$iv2;
        File file;
        Archive it3;
        Collection collection;
        void $receiver$iv$iv3;
        Iterable $receiver$iv3;
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        Iterable iterable = $receiver$iv3 = (Iterable)input;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv3) {
            FileMapping fileMapping = (FileMapping)item$iv$iv;
            collection = destination$iv$iv;
            file = ((FileMapping)((Object)it3)).getFrom();
            collection.add(file);
        }
        Set inputLibraries = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (inputLibraries.size() != input.size()) {
            throw (Throwable)new IllegalArgumentException("Input files are duplicated!");
        }
        List<Archive> libraries = this.loadLibraries((Iterable<FileMapping>)input);
        List<PomDocument> pomFiles = this.scanPomFiles(libraries);
        Iterable $receiver$iv4 = libraries;
        for (Object element$iv2 : $receiver$iv4) {
            it3 = (Archive)element$iv2;
            this.transformLibrary(it3);
        }
        if (this.context.errorsTotal() > 0) {
            if (this.context.isInReversedMode() && this.context.getRewritingSupportLib()) {
                throw (Throwable)new IllegalArgumentException("There were " + this.context.errorsTotal() + " errors found " + "during the de-jetification. You have probably added new androidx types " + "into support library and dejetifier doesn't know where to move them. " + "Please update default.config and regenerate default.generated.config via" + "jetifier/jetifier/preprocessor/scripts/processDefaultConfig.sh");
            }
            throw (Throwable)new IllegalArgumentException("There were " + this.context.errorsTotal() + " errors found during the remapping. Check the logs for more details.");
        }
        this.transformPomFiles(pomFiles);
        Iterable iterable2 = libraries;
        element$iv2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it2 = (Archive)element$iv$iv;
            if (!(copyUnmodifiedLibsAlso || it2.getWasChanged())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it2 = (Archive)item$iv$iv;
            collection = destination$iv$iv2;
            file = it2.writeSelf();
            collection.add(file);
        }
        Set generatedLibraries = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (copyUnmodifiedLibsAlso) {
            return generatedLibraries;
        }
        $receiver$iv$iv2 = libraries;
        destination$iv$iv2 = $receiver$iv;
        Collection destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Archive)element$iv$iv;
            if (!it.getWasChanged()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Archive)item$iv$iv;
            collection = destination$iv$iv3;
            file = it.getRelativePath().toFile();
            collection.add(file);
        }
        Set filesToRemove = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        return SetsKt.plus((Set)SetsKt.minus((Set)inputLibraries, (Iterable)filesToRemove), (Iterable)generatedLibraries);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Set transform$default(Processor processor, Set set, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return processor.transform(set, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String mapDependency(@NotNull String depNotation) {
        Object v0;
        PomDependency inputDependency;
        block2: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)depNotation, (String)"depNotation");
            List parts = StringsKt.split$default((CharSequence)depNotation, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            inputDependency = new PomDependency((String)parts.get(0), (String)parts.get(1), (String)parts.get(2), null, null, null, null, null, 248, null);
            Iterable iterable = this.context.getConfig().getPomRewriteRules();
            for (Object element$iv : $receiver$iv) {
                PomRewriteRule it = (PomRewriteRule)element$iv;
                if (!it.matches(inputDependency)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PomRewriteRule pomRewriteRule = v0;
        if (pomRewriteRule == null) {
            return null;
        }
        PomRewriteRule resultRule = pomRewriteRule;
        return resultRule.getTo().rewrite(inputDependency, this.context.getVersions()).toStringNotation();
    }

    @NotNull
    public final Map<String, String> getDependenciesMap(boolean filterOutBaseLibrary) {
        PomRewriteRule it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.context.getConfig().getPomRewriteRules();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (PomRewriteRule)element$iv$iv;
            if (!(!filterOutBaseLibrary || !Intrinsics.areEqual((Object)it.getFrom().getArtifactId(), (Object)"baseLibrary") || !Intrinsics.areEqual((Object)it.getFrom().getGroupId(), (Object)"com.android.databinding"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (PomRewriteRule)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)this.context.getVersions().applyOnConfigPomDep(it.getFrom()).toStringNotationWithoutVersion(), (Object)this.context.getVersions().applyOnConfigPomDep(it.getTo()).toStringNotation());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Map getDependenciesMap$default(Processor processor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return processor.getDependenciesMap(bl);
    }

    public final boolean isOldDependencyFile(@NotNull File aarOrJarFile) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)aarOrJarFile, (String)"aarOrJarFile");
            Iterable $receiver$iv = this.oldDependenciesRegex;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Regex it = (Regex)element$iv;
                    String string = aarOrJarFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aarOrJarFile.absolutePath");
                    if (!it.matches((CharSequence)string)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isNewDependencyFile(@NotNull File aarOrJarFile) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)aarOrJarFile, (String)"aarOrJarFile");
            Iterable $receiver$iv = this.newDependenciesRegex;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Regex it = (Regex)element$iv;
                    String string = aarOrJarFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aarOrJarFile.absolutePath");
                    if (!it.matches((CharSequence)string)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<Archive> loadLibraries(Iterable<FileMapping> inputLibraries) {
        List libraries = new ArrayList();
        for (FileMapping library : inputLibraries) {
            if (!library.getFrom().canRead()) {
                throw (Throwable)new FileNotFoundException("Cannot open a library at '" + library + '\'');
            }
            Archive archive = Archive.Builder.extract$default(Archive.Builder.INSTANCE, library.getFrom(), false, 2, null);
            Path path = library.getTo().toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"library.to.toPath()");
            archive.setTargetPath(path);
            libraries.add(archive);
        }
        return CollectionsKt.toList((Iterable)libraries);
    }

    private final List<PomDocument> scanPomFiles(List<Archive> libraries) {
        PomScanner scanner = new PomScanner(this.context);
        Iterable $receiver$iv = libraries;
        for (Object element$iv : $receiver$iv) {
            Archive it = (Archive)element$iv;
            scanner.scanArchiveForPomFile(it);
        }
        if (scanner.wasErrorFound()) {
            throw (Throwable)new IllegalArgumentException("At least one of the libraries depends on an older version of support library. Check the logs for more details.");
        }
        return scanner.getPomFiles();
    }

    private final void transformPomFiles(List<PomDocument> files) {
        Iterable $receiver$iv = files;
        for (Object element$iv : $receiver$iv) {
            PomDocument it = (PomDocument)element$iv;
            it.applyRules(this.context);
            it.saveBackToFileIfNeeded();
        }
    }

    private final void transformLibrary(Archive archive) {
        Log.INSTANCE.i(TAG, "Started new transformation", new Object[0]);
        Log.INSTANCE.i(TAG, "- Input file: %s", new Object[]{archive.getRelativePath()});
        archive.accept(this);
    }

    @Override
    public void visit(@NotNull Archive archive) {
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        Iterable $receiver$iv = archive.getFiles();
        for (Object element$iv : $receiver$iv) {
            ArchiveItem it = (ArchiveItem)element$iv;
            it.accept(this);
        }
    }

    @Override
    public void visit(@NotNull ArchiveFile archiveFile) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
            Iterable $receiver$iv = this.transformers;
            for (Object element$iv : $receiver$iv) {
                Transformer it = (Transformer)element$iv;
                if (!it.canTransform(archiveFile)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Transformer transformer = v0;
        if (transformer == null) {
            Log.INSTANCE.v(TAG, "[Skipped] %s", new Object[]{archiveFile.getRelativePath()});
            return;
        }
        Log.INSTANCE.v(TAG, "[Applied: %s] %s", new Object[]{transformer.getClass().getSimpleName(), archiveFile.getRelativePath()});
        transformer.runTransform(archiveFile);
    }

    private Processor(TransformationContext context, List<? extends Transformer> transformers) {
        Regex regex;
        PomRewriteRule it;
        Collection<Regex> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        this.context = context;
        this.transformers = transformers;
        Iterable iterable = this.context.getConfig().getPomRewriteRules();
        Processor processor = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            PomRewriteRule pomRewriteRule = (PomRewriteRule)item$iv$iv;
            collection = destination$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append(".*");
            String string = it.getFrom().getGroupId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            regex = new Regex(stringBuilder.append(StringsKt.replace$default((String)string, (String)".", (String)"[./\\\\]", (boolean)false, (int)4, null)).append("[./\\\\]").append(it.getFrom().getArtifactId()).append("[./\\\\].*").toString());
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        processor.oldDependenciesRegex = collection;
        $receiver$iv = this.context.getConfig().getPomRewriteRules();
        processor = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (PomRewriteRule)item$iv$iv;
            collection = destination$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append(".*");
            String string = it.getTo().getGroupId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            regex = new Regex(stringBuilder.append(StringsKt.replace$default((String)string, (String)".", (String)"[./\\\\]", (boolean)false, (int)4, null)).append("[./\\\\]").append(it.getTo().getArtifactId()).append("[./\\\\].*").toString());
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        processor.newDependenciesRegex = collection;
    }

    public /* synthetic */ Processor(@NotNull TransformationContext context, @NotNull List transformers, DefaultConstructorMarker $constructor_marker) {
        this(context, transformers);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/build/jetifier/processor/Processor$Companion;", "", "()V", "TAG", "", "createProcessor", "Lcom/android/tools/build/jetifier/processor/Processor;", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "reversedMode", "", "rewritingSupportLib", "useFallbackIfTypeIsMissing", "versionSetName", "dataBindingVersion", "createSLTransformers", "", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "createTransformers", "jetifier-processor"})
    public static final class Companion {
        private final List<Transformer> createTransformers(TransformationContext context) {
            return CollectionsKt.listOf((Object[])new Transformer[]{new ByteCodeTransformer(context), new XmlResourcesTransformer(context), new ProGuardTransformer(context)});
        }

        private final List<Transformer> createSLTransformers(TransformationContext context) {
            return CollectionsKt.listOf((Object[])new Transformer[]{new ByteCodeTransformer(context), new XmlResourcesTransformer(context), new ProGuardTransformer(context), new MetaInfTransformer(context)});
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Processor createProcessor(@NotNull Config config, boolean reversedMode, boolean rewritingSupportLib, boolean useFallbackIfTypeIsMissing, @Nullable String versionSetName, @Nullable String dataBindingVersion) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Config newConfig = config;
            DependencyVersions versionsMap = DependencyVersions.Companion.parseFromVersionSetTypeId(config.getVersionsMap(), versionSetName).replaceVersionIfAny("newDataBindingVersion", dataBindingVersion);
            if (reversedMode) {
                Collection<PomRewriteRule> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Config config2;
                Iterable iterable = config.getPomRewriteRules();
                List list = config.getSlRules();
                RewriteRulesMap rewriteRulesMap = config.getRulesMap().reverse().appendRules(config.getSlRules());
                Set set = config.getRestrictToPackagePrefixes();
                Set set2 = config.getReversedRestrictToPackagePrefixes();
                Config config3 = config2;
                Config config4 = config2;
                void var10_16 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    PomRewriteRule pomRewriteRule = (PomRewriteRule)item$iv$iv;
                    collection = destination$iv$iv;
                    PomRewriteRule pomRewriteRule2 = it.getReversed();
                    collection.add(pomRewriteRule2);
                }
                collection = (List)destination$iv$iv;
                config3(set2, set, rewriteRulesMap, list, CollectionsKt.toSet((Iterable)collection), config.getTypesMap().reverseMapOrDie(), config.getProGuardMap().reverseMap(), config.getVersionsMap(), config.getPackageMap().reverse());
                newConfig = config4;
            }
            TransformationContext context = new TransformationContext(newConfig, rewritingSupportLib, reversedMode, useFallbackIfTypeIsMissing, versionsMap);
            List<Transformer> transformers = rewritingSupportLib ? this.createSLTransformers(context) : this.createTransformers(context);
            return new Processor(context, transformers, null);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Processor createProcessor$default(Companion companion, Config config, boolean bl, boolean bl2, boolean bl3, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                string = null;
            }
            if ((n & 0x20) != 0) {
                string2 = null;
            }
            return companion.createProcessor(config, bl, bl2, bl3, string, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

