/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.resource;

import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.type.PackageName;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.Transformer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u0014\u001a\u00020\n2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/build/jetifier/processor/transform/resource/XmlResourcesTransformer;", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "patterns", "", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "canTransform", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "getCharset", "Ljava/nio/charset/Charset;", "data", "", "isPackage", "token", "", "replaceWithPatterns", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fileName", "rewritePackage", "packageName", "rewriteType", "typeName", "runTransform", "", "Companion", "jetifier-processor"})
public final class XmlResourcesTransformer
implements Transformer {
    private final List<Pattern> patterns;
    private final TransformationContext context;
    @NotNull
    public static final String TAG = "XmlResourcesTransformer";
    public static final int PATTERN_TYPE_GROUP = 1;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean canTransform(@NotNull ArchiveFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.isXmlFile() && !file.isPomFile();
    }

    @Override
    public void runTransform(@NotNull ArchiveFile file) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getFileName(), (Object)"maven-metadata.xml")) {
            return;
        }
        Charset charset = this.getCharset(file.getData());
        byte[] byArray = file.getData();
        Object object = stringBuilder;
        Object object2 = stringBuilder;
        String string = new String(byArray, charset);
        ((StringBuilder)object)(string);
        StringBuilder sb = object2;
        boolean changesDone = this.replaceWithPatterns(sb, this.patterns, ((Object)file.getRelativePath()).toString());
        if (changesDone) {
            String string2 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
            String string3 = string2;
            object2 = file;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string4.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray2;
            ((ArchiveFile)object2).setNewData((byte[])object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Charset getCharset(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Object object = data;
        object = new ByteArrayInputStream((byte[])object);
        Throwable throwable = null;
        try {
            XMLStreamReader xmlReader;
            ByteArrayInputStream it = (ByteArrayInputStream)object;
            XMLStreamReader xMLStreamReader = xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)xMLStreamReader, (String)"xmlReader");
            if (xMLStreamReader.getEncoding() == null) {
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                return charset2;
            }
            Charset result = Charset.forName(xmlReader.getEncoding());
            if (result == null) {
                Log.INSTANCE.e(TAG, "Failed to find charset for encoding '%s'", new Object[]{xmlReader.getEncoding()});
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset3 = charset;
                return charset3;
            }
            Charset charset = result;
            return charset;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final boolean replaceWithPatterns(StringBuilder sb, List<Pattern> patterns, String fileName) {
        boolean changesDone = false;
        for (Pattern pattern : patterns) {
            int lastSeenChar = 0;
            String processedInput = sb.toString();
            sb.setLength(0);
            Matcher matcher = pattern.matcher(processedInput);
            while (matcher.find()) {
                String string;
                if (lastSeenChar < matcher.start()) {
                    sb.append(processedInput, lastSeenChar, matcher.start());
                }
                String toReplace = matcher.group(1);
                String matched = matcher.group(0);
                String string2 = toReplace;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"toReplace");
                String replacement = this.isPackage(string2) ? this.rewritePackage(toReplace, fileName) : this.rewriteType(toReplace);
                changesDone = changesDone || Intrinsics.areEqual((Object)replacement, (Object)toReplace) ^ true;
                int localStart = matcher.start(1) - matcher.start();
                int localEnd = matcher.end(1) - matcher.start();
                Intrinsics.checkExpressionValueIsNotNull((Object)matched, (String)"matched");
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String result = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)localStart, (int)localEnd, (CharSequence)replacement)).toString();
                sb.append(result);
                lastSeenChar = matcher.end();
            }
            if (lastSeenChar > processedInput.length() - 1) continue;
            sb.append(processedInput, lastSeenChar, processedInput.length());
        }
        return changesDone;
    }

    private final boolean isPackage(String token) {
        boolean bl;
        block1: {
            CharSequence $receiver$iv;
            CharSequence charSequence = $receiver$iv = (CharSequence)token;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                char c = it;
                if (!Character.isUpperCase(c)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    private final String rewriteType(String typeName) {
        JavaType type = JavaType.Companion.fromDotVersion(typeName);
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result != null) {
            return result.toDotNotation();
        }
        this.context.reportNoMappingFoundFailure(TAG, type);
        return typeName;
    }

    private final String rewritePackage(String packageName, String fileName) {
        if (!StringsKt.contains$default((CharSequence)packageName, (char)'.', (boolean)false, (int)2, null)) {
            return packageName;
        }
        PackageName pckg = PackageName.Companion.fromDotVersion(packageName);
        PackageName result = this.context.getConfig().getPackageMap().getPackageFor(pckg);
        if (result != null) {
            return result.toDotNotation();
        }
        if (this.context.getConfig().isEligibleForRewrite(pckg)) {
            this.context.reportNoPackageMappingFoundFailure(TAG, packageName, fileName);
        }
        return packageName;
    }

    public XmlResourcesTransformer(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.patterns = CollectionsKt.listOf((Object[])new Pattern[]{Pattern.compile("</?([a-zA-Z0-9.]+)"), Pattern.compile("[a-zA-Z0-9:]+=\"([a-zA-Z0-9.$_]+)\""), Pattern.compile(">\\s*([a-zA-Z0-9.$_]+)<")});
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/resource/XmlResourcesTransformer$Companion;", "", "()V", "PATTERN_TYPE_GROUP", "", "TAG", "", "jetifier-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

