/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.common.annotations.VisibleForTesting;
import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiUtilBase;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiNameInspection
extends EndpointInspectionBase {
    private static final String API_NAME_ATTRIBUTE = "name";
    private static final Pattern API_NAME_PATTERN = Pattern.compile("^[a-z]+[A-Za-z0-9]*$");

    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("api.name.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("api.name.name", new Object[0]);
        if (string == null) {
            ApiNameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("api.name.short.name", new Object[0]);
        if (string == null) {
            ApiNameInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ApiNameInspection.$$$reportNull$$$0(2);
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                if (annotation == null) {
                    return;
                }
                String annotationQualifiedName = annotation.getQualifiedName();
                if (annotationQualifiedName == null) {
                    return;
                }
                if (!annotationQualifiedName.equals("com.google.api.server.spi.config.Api")) {
                    return;
                }
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                if (parameterList.getAttributes().length == 0) {
                    return;
                }
                PsiAnnotationMemberValue annotationMemberValue = annotation.findAttributeValue(ApiNameInspection.API_NAME_ATTRIBUTE);
                if (annotationMemberValue == null) {
                    return;
                }
                String nameValueWithQuotes = annotationMemberValue.getText();
                String nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(nameValueWithQuotes);
                if (nameValue.isEmpty()) {
                    return;
                }
                if (!API_NAME_PATTERN.matcher(nameValue).matches()) {
                    holder.registerProblem((PsiElement)annotationMemberValue, "Invalid api name: it must start with a lower case letter and consists only of letter and digits", new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            ApiNameInspection.$$$reportNull$$$0(3);
        }
        return endpointPsiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/appengine/validation/ApiNameInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/appengine/validation/ApiNameInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        private static final String DEFAULT_API_NAME = "myApi";

        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Rename API name";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = ApiNameInspection.this.getDisplayName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            Editor editor = PsiUtilBase.findEditor((PsiElement)element);
            if (editor == null) {
                return;
            }
            TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            String wordWithQuotes = editor.getSelectionModel().getSelectedText();
            String word = EndpointUtilities.removeBeginningAndEndingQuotes(wordWithQuotes);
            if (word == null || StringUtil.isEmpty((String)word)) {
                return;
            }
            String variant = "\"" + this.getNameSuggestions(word) + "\"";
            LookupManager lookupManager = LookupManager.getInstance((Project)project);
            lookupManager.showLookup(editor, new LookupElement[]{LookupElementBuilder.create((String)variant)});
        }

        @VisibleForTesting
        public String getNameSuggestions(String baseString) {
            if (baseString.isEmpty()) {
                return DEFAULT_API_NAME;
            }
            String noInvalidChars = baseString.replaceAll("[^a-zA-Z0-9]+", "");
            if (noInvalidChars.isEmpty()) {
                return DEFAULT_API_NAME;
            }
            if (API_NAME_PATTERN.matcher(noInvalidChars).matches()) {
                return noInvalidChars;
            }
            baseString = noInvalidChars;
            if (Character.isDigit(baseString.charAt(0))) {
                int n;
                for (n = 0; n < baseString.length() && Character.isDigit(baseString.charAt(n)); ++n) {
                }
                String nonDigitName = baseString.substring(n);
                if (API_NAME_PATTERN.matcher(nonDigitName).matches()) {
                    return nonDigitName;
                }
                if (nonDigitName.isEmpty()) {
                    return "api" + noInvalidChars;
                }
                baseString = nonDigitName;
            }
            if (Character.isUpperCase(baseString.charAt(0))) {
                String beginWithLowerCase = baseString.substring(0, 1).toLowerCase() + baseString.substring(1);
                if (API_NAME_PATTERN.matcher(beginWithLowerCase).matches()) {
                    return beginWithLowerCase;
                }
            }
            return DEFAULT_API_NAME;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/appengine/validation/ApiNameInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/appengine/validation/ApiNameInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

