/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiNamespaceInspection
extends EndpointInspectionBase {
    private static final String API_NAMESPACE_DOMAIN_ATTRIBUTE = "ownerDomain";
    private static final String API_NAMESPACE_NAME_ATTRIBUTE = "ownerName";
    private static final String API_NAMESPACE_PACKAGE_PATH_ATTRIBUTE = "packagePath";

    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("api.namespace.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("api.namespace.name", new Object[0]);
        if (string == null) {
            ApiNamespaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("api.namespace.short.name", new Object[0]);
        if (string == null) {
            ApiNamespaceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ApiNamespaceInspection.$$$reportNull$$$0(2);
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                boolean ownerFullySpecified;
                if (!EndpointUtilities.isEndpointClass((PsiElement)annotation)) {
                    return;
                }
                if (!annotation.getQualifiedName().equals("com.google.api.server.spi.config.ApiNamespace")) {
                    return;
                }
                PsiAnnotationMemberValue ownerDomainMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
                if (ownerDomainMember == null) {
                    return;
                }
                String ownerDomainWithQuotes = ownerDomainMember.getText();
                PsiAnnotationMemberValue ownerNameMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
                if (ownerNameMember == null) {
                    return;
                }
                String ownerNameWithQuotes = ownerNameMember.getText();
                String ownerDomain = EndpointUtilities.removeBeginningAndEndingQuotes(ownerDomainWithQuotes);
                String ownerName = EndpointUtilities.removeBeginningAndEndingQuotes(ownerNameWithQuotes);
                String packagePath = EndpointUtilities.removeBeginningAndEndingQuotes(annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_PACKAGE_PATH_ATTRIBUTE).getText());
                boolean allUnspecified = ownerDomain.isEmpty() && ownerName.isEmpty() && packagePath.isEmpty();
                boolean bl = ownerFullySpecified = !ownerDomain.isEmpty() && !ownerName.isEmpty();
                if (!allUnspecified && !ownerFullySpecified) {
                    holder.registerProblem((PsiElement)annotation, "Invalid namespace configuration. If a namespace is set, make sure to set an Owner Domain and Name. Package Path is optional.", new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            ApiNamespaceInspection.$$$reportNull$$$0(3);
        }
        return endpointPsiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/appengine/validation/ApiNamespaceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/appengine/validation/ApiNamespaceInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        private static final String SUGGESTED_OWNER_ATTRIBUTE = "YourCo";
        private static final String SUGGESTED_DOMAIN_ATTRIBUTE = "your-company.com";

        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Add missing attributes";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = ApiNamespaceInspection.this.getDisplayName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if ((psiElement = descriptor.getPsiElement()) == null) {
                return;
            }
            if (!(psiElement instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)psiElement;
            if (!annotation.getQualifiedName().equals("com.google.api.server.spi.config.ApiNamespace")) {
                return;
            }
            PsiAnnotationMemberValue ownerDomainMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
            if (ownerDomainMember == null) {
                return;
            }
            String ownerDomainWithQuotes = ownerDomainMember.getText();
            PsiAnnotationMemberValue ownerNameMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
            if (ownerNameMember == null) {
                return;
            }
            String ownerNameWithQuotes = ownerNameMember.getText();
            String ownerDomain = EndpointUtilities.removeBeginningAndEndingQuotes(ownerDomainWithQuotes);
            String ownerName = EndpointUtilities.removeBeginningAndEndingQuotes(ownerNameWithQuotes);
            if (ownerDomain.isEmpty() && ownerName.isEmpty()) {
                this.addOwnerDomainAndNameAttributes(project, annotation);
            } else if (ownerDomain.isEmpty() && !ownerName.isEmpty()) {
                this.addOwnerDomainAttribute(project, annotation);
            } else if (!ownerDomain.isEmpty() && ownerName.isEmpty()) {
                this.addOwnerNameAttribute(project, annotation);
            }
        }

        private void addOwnerDomainAttribute(final @NotNull Project project, final PsiAnnotation annotation) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            new WriteCommandAction(project, new PsiFile[]{annotation.getContainingFile()}){

                protected void run(Result result) throws Throwable {
                    PsiAnnotationMemberValue newMemberValue = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@A(ownerDomain = \"your-company.com\")", null).findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE, newMemberValue);
                }
            }.execute();
        }

        private void addOwnerNameAttribute(final @NotNull Project project, final PsiAnnotation annotation) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            new WriteCommandAction(project, new PsiFile[]{annotation.getContainingFile()}){

                protected void run(Result result) throws Throwable {
                    PsiAnnotationMemberValue newMemberValue = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@A(ownerName = \"YourCo\")", null).findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE, newMemberValue);
                }
            }.execute();
        }

        private void addOwnerDomainAndNameAttributes(final @NotNull Project project, final PsiAnnotation annotation) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            new WriteCommandAction(project, new PsiFile[]{annotation.getContainingFile()}){

                protected void run(Result result) throws Throwable {
                    String annotationString = "@A(ownerName = \"YourCo\", ownerDomain = \"your-company.com\")";
                    PsiAnnotation newAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(annotationString, null);
                    PsiAnnotationMemberValue newDomainMemberValue = newAnnotation.findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
                    PsiAnnotationMemberValue newNameMemberValue = newAnnotation.findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE, newNameMemberValue);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE, newDomainMemberValue);
                }
            }.execute();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/appengine/validation/ApiNamespaceInspection$MyQuickFix";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/appengine/validation/ApiNamespaceInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addOwnerDomainAttribute";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addOwnerNameAttribute";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addOwnerDomainAndNameAttributes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

