/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class ApiParameterInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("api.parameter.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("api.parameter.name", new Object[0]);
        if (string == null) {
            ApiParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("api.parameter.short.name", new Object[0]);
        if (string == null) {
            ApiParameterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ApiParameterInspection.$$$reportNull$$$0(2);
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitParameter(PsiParameter psiParameter) {
                Project project;
                if (!EndpointUtilities.isEndpointClass((PsiElement)psiParameter)) {
                    return;
                }
                PsiElement psiElement = psiParameter.getDeclarationScope();
                if (psiElement instanceof PsiMethod) {
                    if (!EndpointUtilities.isApiMethod((PsiMethod)psiElement)) {
                        return;
                    }
                    if (((PsiMethod)psiElement).isConstructor()) {
                        return;
                    }
                } else {
                    return;
                }
                try {
                    project = psiParameter.getContainingFile().getProject();
                    if (project == null) {
                        return;
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    EndpointInspectionBase.LOG.error("Cannot determine project with parameter " + psiParameter.getText(), (Throwable)e);
                    return;
                }
                PsiType psiType = psiParameter.getType();
                if (!this.isApiParameter(psiType, project)) {
                    return;
                }
                if (!ApiParameterInspection.this.hasParameterName(psiParameter)) {
                    holder.registerProblem((PsiElement)psiParameter, "Missing parameter name. Parameter type (" + psiType.getPresentableText() + ") is not an entity type and thus should be annotated with @Named.", new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            ApiParameterInspection.$$$reportNull$$$0(3);
        }
        return endpointPsiElementVisitor;
    }

    private boolean hasParameterName(PsiParameter psiParameter) {
        PsiModifierList modifierList = psiParameter.getModifierList();
        if (modifierList == null) {
            return false;
        }
        PsiAnnotation annotation = modifierList.findAnnotation("javax.inject.Named");
        if (annotation != null) {
            return true;
        }
        annotation = modifierList.findAnnotation("com.google.api.server.spi.config.Named");
        return annotation != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/appengine/validation/ApiParameterInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/appengine/validation/ApiParameterInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Add @Named";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = ApiParameterInspection.this.getDisplayName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            if (!(element instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)element;
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (modifierList.findAnnotation("com.google.api.server.spi.config.Named") != null) {
                return;
            }
            if (modifierList.findAnnotation("") != null) {
                return;
            }
            String annotationString = "@Named(\"" + parameter.getName() + "\")";
            PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(annotationString, element);
            modifierList.add((PsiElement)annotation);
            PsiFile file = parameter.getContainingFile();
            if (file == null) {
                return;
            }
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiAdapter.addImportStatement((PsiJavaFile)((PsiJavaFile)file), (String)"com.google.api.server.spi.config.Named");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/appengine/validation/ApiParameterInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/appengine/validation/ApiParameterInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

