/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.common.collect.Maps;
import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullMethodNameInspection
extends EndpointInspectionBase {
    private static final String API_METHOD_NAME_ATTRIBUTE = "name";

    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("full.method.name.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("full.method.name.name", new Object[0]);
        if (string == null) {
            FullMethodNameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("full.method.name.short.name", new Object[0]);
        if (string == null) {
            FullMethodNameInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FullMethodNameInspection.$$$reportNull$$$0(2);
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitClass(PsiClass aClass) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)aClass)) {
                    return;
                }
                PsiMethod[] allMethods = aClass.getMethods();
                HashMap apiMethodNames = Maps.newHashMap();
                for (PsiMethod aMethod : allMethods) {
                    this.validateBackendMethodNameUnique(aMethod, apiMethodNames);
                }
            }

            private void validateBackendMethodNameUnique(PsiMethod psiMethod, Map<String, PsiMethod> apiMethodNames) {
                if (!EndpointUtilities.isApiMethod(psiMethod)) {
                    return;
                }
                if (psiMethod.isConstructor()) {
                    return;
                }
                PsiModifierList modifierList = psiMethod.getModifierList();
                PsiAnnotation apiMethodAnnotation = modifierList.findAnnotation("com.google.api.server.spi.config.ApiMethod");
                if (apiMethodAnnotation == null) {
                    return;
                }
                PsiAnnotationMemberValue apiMethodNameAttribute = apiMethodAnnotation.findAttributeValue(FullMethodNameInspection.API_METHOD_NAME_ATTRIBUTE);
                if (apiMethodNameAttribute == null) {
                    return;
                }
                String nameValueWithQuotes = apiMethodNameAttribute.getText();
                String nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(nameValueWithQuotes);
                if (nameValue.isEmpty()) {
                    return;
                }
                PsiMethod seenMethod = apiMethodNames.get(nameValue);
                if (seenMethod == null) {
                    apiMethodNames.put(nameValue, psiMethod);
                } else {
                    holder.registerProblem((PsiElement)apiMethodAnnotation, "Multiple methods with same API method name are prohibited. \"" + nameValue + "\" is the API method name for " + psiMethod.getName() + " and " + seenMethod.getName() + ".", new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            FullMethodNameInspection.$$$reportNull$$$0(3);
        }
        return endpointPsiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/appengine/validation/FullMethodNameInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/appengine/validation/FullMethodNameInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Rename API method name";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = FullMethodNameInspection.this.getDisplayName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getPsiElement()) instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)element;
            if (!annotation.getQualifiedName().equals("com.google.api.server.spi.config.ApiMethod")) {
                return;
            }
            PsiAnnotationMemberValue apiMethodNameAttribute = annotation.findAttributeValue(FullMethodNameInspection.API_METHOD_NAME_ATTRIBUTE);
            if (apiMethodNameAttribute == null) {
                return;
            }
            String nameValueWithQuotes = apiMethodNameAttribute.getText();
            String nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(nameValueWithQuotes);
            PsiAnnotationMemberValue newMemberValue = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@A(name = \"" + nameValue + "_1\")", null).findDeclaredAttributeValue(FullMethodNameInspection.API_METHOD_NAME_ATTRIBUTE);
            apiMethodNameAttribute.replace((PsiElement)newMemberValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/appengine/validation/FullMethodNameInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/appengine/validation/FullMethodNameInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

