/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidParameterAnnotationsInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("invalid.parameter.annotations.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("invalid.parameter.annotations.name", new Object[0]);
        if (string == null) {
            InvalidParameterAnnotationsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("invalid.parameter.annotations.short.name", new Object[0]);
        if (string == null) {
            InvalidParameterAnnotationsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InvalidParameterAnnotationsInspection.$$$reportNull$$$0(2);
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitMethod(PsiMethod method) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)method)) {
                    return;
                }
                if (!EndpointUtilities.isApiMethod(method)) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() == 0) {
                    return;
                }
                PsiAnnotation apiMethodAnnotation = method.getModifierList().findAnnotation("com.google.api.server.spi.config.ApiMethod");
                if (apiMethodAnnotation == null) {
                    return;
                }
                PsiAnnotationMemberValue pathMember = apiMethodAnnotation.findAttributeValue("path");
                String path = EndpointUtilities.removeBeginningAndEndingQuotes(pathMember.getText());
                Collection<String> pathParameters = this.getPathParameters(path);
                if (pathParameters.isEmpty()) {
                    return;
                }
                for (PsiParameter aParameter : parameterList.getParameters()) {
                    String nameValue;
                    PsiAnnotationMemberValue namedAnnotation = this.getNamedAnnotationValue(aParameter);
                    if (namedAnnotation == null || !pathParameters.contains(nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(namedAnnotation.getText())) || aParameter.getModifierList().findAnnotation("com.google.api.server.spi.config.Nullable") == null && aParameter.getModifierList().findAnnotation("javax.annotation.Nullable") == null && aParameter.getModifierList().findAnnotation("com.google.api.server.spi.config.DefaultValue") == null) continue;
                    holder.registerProblem((PsiElement)aParameter, "Invalid parameter configuration. A parameter in the method path should not be marked @Nullable or @DefaultValue.", new LocalQuickFix[]{new MyQuickFix()});
                }
            }

            private Collection<String> getPathParameters(String path) {
                Pattern pathPattern = Pattern.compile("\\{([^\\}]*)\\}");
                Matcher pathMatcher = pathPattern.matcher(path);
                HashSet<String> pathParameters = new HashSet<String>();
                while (pathMatcher.find()) {
                    pathParameters.add(pathMatcher.group(1));
                }
                return pathParameters;
            }
        };
        if (endpointPsiElementVisitor == null) {
            InvalidParameterAnnotationsInspection.$$$reportNull$$$0(3);
        }
        return endpointPsiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/appengine/validation/InvalidParameterAnnotationsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/appengine/validation/InvalidParameterAnnotationsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Remove @Nullable and/or @DefaultValue";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = EndpointBundle.message("api.name.name", new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiAnnotation defaultValueAnnotation;
            PsiAnnotation javaxNullableAnnotation;
            PsiElement element;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            if (!(element instanceof PsiParameter)) {
                return;
            }
            PsiModifierList modifierList = ((PsiParameter)element).getModifierList();
            PsiAnnotation gaeNullableAnnotation = modifierList.findAnnotation("com.google.api.server.spi.config.Nullable");
            if (gaeNullableAnnotation != null) {
                gaeNullableAnnotation.delete();
            }
            if ((javaxNullableAnnotation = modifierList.findAnnotation("javax.annotation.Nullable")) != null) {
                javaxNullableAnnotation.delete();
            }
            if ((defaultValueAnnotation = modifierList.findAnnotation("com.google.api.server.spi.config.DefaultValue")) != null) {
                defaultValueAnnotation.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/appengine/validation/InvalidParameterAnnotationsInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/appengine/validation/InvalidParameterAnnotationsInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

