/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnTypeInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("method.return.type.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("method.return.type.name", new Object[0]);
        if (string == null) {
            MethodReturnTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("method.return.type.short.name", new Object[0]);
        if (string == null) {
            MethodReturnTypeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MethodReturnTypeInspection.$$$reportNull$$$0(2);
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitMethod(PsiMethod method) {
                Project project;
                if (!EndpointUtilities.isEndpointClass((PsiElement)method)) {
                    return;
                }
                if (this.hasTransformer((PsiElement)method)) {
                    return;
                }
                if (!EndpointUtilities.isApiMethod(method)) {
                    return;
                }
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return;
                }
                if (returnType.isAssignableFrom((PsiType)PsiType.VOID)) {
                    return;
                }
                try {
                    project = method.getContainingFile().getProject();
                    if (project == null) {
                        return;
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    EndpointInspectionBase.LOG.error("Error getting project with method " + method.getText(), (Throwable)e);
                    return;
                }
                if (!this.isEntityParameter(returnType, project)) {
                    holder.registerProblem((PsiElement)method.getReturnTypeElement(), "Invalid return type: " + returnType.getPresentableText() + ". Primitives and enums are not allowed.", LocalQuickFix.EMPTY_ARRAY);
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            MethodReturnTypeInspection.$$$reportNull$$$0(3);
        }
        return endpointPsiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/appengine/validation/MethodReturnTypeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/appengine/validation/MethodReturnTypeInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

