/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.common.collect.Maps;
import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedResourceInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("named.resource.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("named.resource.name", new Object[0]);
        if (string == null) {
            NamedResourceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("named.resource.short.name", new Object[0]);
        if (string == null) {
            NamedResourceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NamedResourceInspection.$$$reportNull$$$0(2);
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitMethod(PsiMethod psiMethod) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)psiMethod)) {
                    return;
                }
                if (this.hasTransformer((PsiElement)psiMethod)) {
                    return;
                }
                if (!EndpointUtilities.isApiMethod(psiMethod)) {
                    return;
                }
                PsiParameterList parameterList = psiMethod.getParameterList();
                HashMap methodNames = Maps.newHashMap();
                for (PsiParameter aParameter : parameterList.getParameters()) {
                    this.validateMethodNameUnique(aParameter, methodNames);
                }
            }

            private void validateMethodNameUnique(PsiParameter psiParameter, Map<String, PsiParameter> methodNames) {
                PsiModifierList modifierList = psiParameter.getModifierList();
                if (modifierList == null) {
                    return;
                }
                PsiAnnotation annotation = modifierList.findAnnotation("javax.inject.Named");
                if (annotation == null && (annotation = modifierList.findAnnotation("com.google.api.server.spi.config.Named")) == null) {
                    return;
                }
                PsiNameValuePair[] nameValuePairs = annotation.getParameterList().getAttributes();
                if (nameValuePairs.length == 0) {
                    holder.registerProblem((PsiElement)annotation, "Parameter name must be specified.", new LocalQuickFix[]{new MissingNameQuickFix()});
                    return;
                }
                if (nameValuePairs.length != 1) {
                    return;
                }
                if (nameValuePairs[0] == null) {
                    return;
                }
                PsiAnnotationMemberValue memberValue = nameValuePairs[0].getValue();
                if (memberValue == null) {
                    return;
                }
                String nameValueWithQuotes = memberValue.getText();
                String nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(nameValueWithQuotes);
                if (nameValue.isEmpty()) {
                    holder.registerProblem((PsiElement)annotation, "Parameter name must be specified.", new LocalQuickFix[]{new MissingNameQuickFix()});
                    return;
                }
                PsiParameter seenParameter = methodNames.get(nameValue);
                if (seenParameter == null) {
                    methodNames.put(nameValue, psiParameter);
                } else {
                    holder.registerProblem((PsiElement)annotation, "Duplicate parameter name: " + nameValue + ". Parameter names must be unique.", new LocalQuickFix[]{new DuplicateNameQuickFix()});
                }
            }
        };
        if (endpointPsiElementVisitor == null) {
            NamedResourceInspection.$$$reportNull$$$0(3);
        }
        return endpointPsiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/appengine/validation/NamedResourceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/appengine/validation/NamedResourceInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MissingNameQuickFix
    implements LocalQuickFix {
        private final String DEFAULT_PARAMETER_NAME = "myName";

        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Add name";
            if (string == null) {
                MissingNameQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = NamedResourceInspection.this.getDisplayName();
            if (string == null) {
                MissingNameQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement annotationParent;
            PsiElement element;
            if (project == null) {
                MissingNameQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MissingNameQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            if (!(element instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)element;
            if (!annotation.getQualifiedName().equals("javax.inject.Named") && !annotation.getQualifiedName().equals("com.google.api.server.spi.config.Named")) {
                return;
            }
            String nameValue = "myName";
            PsiElement modifierList = annotation.getParent();
            if (modifierList != null && (annotationParent = modifierList.getParent()) instanceof PsiParameter) {
                nameValue = ((PsiParameter)annotationParent).getName();
            }
            String newNamedValue = "@Named(\"" + nameValue + "\")";
            PsiAnnotation newAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(newNamedValue, null);
            assert (newAnnotation.getParameterList().getAttributes().length == 1);
            annotation.getParameterList().replace((PsiElement)newAnnotation.getParameterList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/appengine/validation/NamedResourceInspection$MissingNameQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/appengine/validation/NamedResourceInspection$MissingNameQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class DuplicateNameQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Rename duplicate parameter";
            if (string == null) {
                DuplicateNameQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = NamedResourceInspection.this.getDisplayName();
            if (string == null) {
                DuplicateNameQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                DuplicateNameQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DuplicateNameQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            if (!(element instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)element;
            if (!annotation.getQualifiedName().equals("javax.inject.Named") && !annotation.getQualifiedName().equals("com.google.api.server.spi.config.Named")) {
                return;
            }
            PsiNameValuePair[] nameValuePairs = annotation.getParameterList().getAttributes();
            if (nameValuePairs.length == 0) {
                return;
            }
            PsiAnnotationMemberValue memberValue = nameValuePairs[0].getValue();
            if (memberValue == null) {
                return;
            }
            String newNamedValue = "@Named(\"" + EndpointUtilities.removeBeginningAndEndingQuotes(memberValue.getText()) + "_1\")";
            PsiAnnotation newAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(newNamedValue, null);
            assert (newAnnotation.getParameterList().getAttributes().length == 1);
            memberValue.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0].getValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/appengine/validation/NamedResourceInspection$DuplicateNameQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/appengine/validation/NamedResourceInspection$DuplicateNameQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Error {
        MISSING_NAME,
        DUPLICATE_PARAMETER;

    }
}

