/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.gct.idea.debugger.CloudDebugProcess;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.ProjectRepositoryState;
import com.google.gct.idea.debugger.ProjectRepositoryValidator;
import com.google.gct.idea.debugger.ui.CloudAttachDialog;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import git4idea.DialogManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudDebuggerRunner
extends DefaultProgramRunner {
    private static final String EXECUTOR_TARGET = "Debug";
    @NonNls
    private static final String ID = "CloudDebuggerRunner";

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            CloudDebuggerRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            CloudDebuggerRunner.$$$reportNull$$$0(1);
        }
        return profile instanceof CloudDebugRunConfiguration && EXECUTOR_TARGET.equals(executorId);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            CloudDebuggerRunner.$$$reportNull$$$0(2);
        }
        if (env == null) {
            CloudDebuggerRunner.$$$reportNull$$$0(3);
        }
        CloudDebugProcessState cloudState = null;
        if (state instanceof CloudDebugProcessState) {
            cloudState = (CloudDebugProcessState)state;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        state.execute(env.getExecutor(), (ProgramRunner)this);
        return CloudDebuggerRunner.createContentDescriptor(cloudState, env);
    }

    @NotNull
    public String getRunnerId() {
        if (ID == null) {
            CloudDebuggerRunner.$$$reportNull$$$0(4);
        }
        return ID;
    }

    private static RunContentDescriptor createContentDescriptor(final @Nullable CloudDebugProcessState processState, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            CloudDebuggerRunner.$$$reportNull$$$0(5);
        }
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processState != null) {
                    ProjectRepositoryState.fromProcessState(processState).clearForNextSession();
                }
                CloudDebugProcessState state = processState;
                CloudAttachDialog attachDialog = new CloudAttachDialog(session.getProject());
                attachDialog.setInputState(state);
                DialogManager.show((DialogWrapper)attachDialog);
                state = attachDialog.getResultState();
                ProjectRepositoryValidator validator = null;
                if (state != null) {
                    validator = new ProjectRepositoryValidator(state);
                }
                if (!attachDialog.isOK() || state == null || !validator.isValidDebuggee()) {
                    throw new RunCanceledByUserException();
                }
                if (environment.getRunnerAndConfigurationSettings() != null && environment.getRunnerAndConfigurationSettings().getConfiguration() instanceof CloudDebugRunConfiguration) {
                    CloudDebugRunConfiguration config = (CloudDebugRunConfiguration)environment.getRunnerAndConfigurationSettings().getConfiguration();
                    config.setProcessState(null);
                }
                CloudDebugProcess process = new CloudDebugProcess(session);
                process.initialize(state);
                CloudDebugProcess cloudDebugProcess = process;
                if (cloudDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return cloudDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/google/gct/idea/debugger/CloudDebuggerRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/google/gct/idea/debugger/CloudDebuggerRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/debugger/CloudDebuggerRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/debugger/CloudDebuggerRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createContentDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

