/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.CloudLineBreakpointProperties;
import com.google.gct.idea.debugger.ui.BreakpointConfigurationPanel;
import com.google.gct.idea.util.GctBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import icons.GoogleCloudToolsIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class CloudLineBreakpointType
extends XLineBreakpointType<CloudLineBreakpointProperties>
implements JavaBreakpointType,
Disposable {
    public CloudLineBreakpointType() {
        super("cloud-snapshotlocation", GctBundle.getString("clouddebug.breakpoint.description", new Object[0]));
    }

    public static CloudLineBreakpointType getInstance() {
        return (CloudLineBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CloudLineBreakpointType.class));
    }

    public final boolean canPutAt(@NotNull VirtualFile file, final int line, @NotNull Project project) {
        RunManagerImpl runManager;
        if (file == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(1);
        }
        if ((runManager = RunManagerImpl.getInstanceImpl((Project)project)).getSelectedConfiguration() == null || !(runManager.getSelectedConfiguration().getConfiguration() instanceof CloudDebugRunConfiguration)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || psiFile.getVirtualFile().getFileType() == StdFileTypes.XHTML) {
            return false;
        }
        if (!StdFileTypes.CLASS.equals(psiFile.getFileType()) && !DebuggerUtils.isBreakpointAware((PsiFile)psiFile)) {
            return false;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(file);
        final Ref result = Ref.create();
        assert (document != null);
        XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                PsiElement parent = element;
                while (element != null) {
                    if (element instanceof PsiModifierList) {
                        element = element.getParent();
                        continue;
                    }
                    int offset = element.getTextOffset();
                    if (offset >= 0 && document.getLineNumber(offset) != line) break;
                    parent = element;
                    element = element.getParent();
                }
                if (parent instanceof PsiMethod) {
                    PsiStatement[] statements;
                    PsiCodeBlock body;
                    if (parent.getTextRange().getEndOffset() >= document.getLineEndOffset(line) && (body = ((PsiMethod)parent).getBody()) != null && (statements = body.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == line) {
                        result.set(CloudLineBreakpointType.class);
                    }
                } else {
                    result.set(CloudLineBreakpointType.class);
                }
                return true;
            }
        });
        return result.get() == ((Object)((Object)this)).getClass();
    }

    @Nullable
    public CloudLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(2);
        }
        return new CloudLineBreakpointProperties();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<CloudLineBreakpointProperties>> createCustomPropertiesPanel() {
        return new BreakpointConfigurationPanel(this);
    }

    @NotNull
    public Breakpoint createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        CloudLineBreakpoint lineBreakpoint = new CloudLineBreakpoint(project, breakpoint);
        lineBreakpoint.init();
        CloudLineBreakpoint cloudLineBreakpoint = lineBreakpoint;
        if (cloudLineBreakpoint == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(3);
        }
        return cloudLineBreakpoint;
    }

    @Nullable
    public CloudLineBreakpointProperties createProperties() {
        return new CloudLineBreakpointProperties();
    }

    public void dispose() {
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = GoogleCloudToolsIcons.CLOUD_BREAKPOINT_DISABLED;
        if (icon == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Nullable
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<CloudLineBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(6);
        }
        return new JavaDebuggerEditorsProvider();
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = GoogleCloudToolsIcons.CLOUD_BREAKPOINT;
        if (icon == null) {
            CloudLineBreakpointType.$$$reportNull$$$0(7);
        }
        return icon;
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<CloudLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    public int getPriority() {
        return 101;
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    public final boolean isSuspendThreadSupported() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/debugger/CloudLineBreakpointType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/debugger/CloudLineBreakpointType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CloudLineBreakpoint
    extends LineBreakpoint {
        private String myErrorMessage = null;
        private boolean myIsVerified = false;

        public CloudLineBreakpoint(Project project, XBreakpoint xBreakpoint) {
            super(project, xBreakpoint);
        }

        protected Icon getDisabledIcon(boolean isMuted) {
            return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_DISABLED;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        protected Icon getSetIcon(boolean isMuted) {
            if (!Strings.isNullOrEmpty((String)this.myErrorMessage)) {
                return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_ERROR;
            }
            if (this.myIsVerified) {
                return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_CHECKED;
            }
            return GoogleCloudToolsIcons.CLOUD_BREAKPOINT;
        }

        @Nullable
        public List<String> getWatchExpressions() {
            CloudLineBreakpointProperties properties = (CloudLineBreakpointProperties)this.getXBreakpoint().getProperties();
            if (properties.getWatchExpressions() != null && properties.getWatchExpressions().length > 0) {
                return Arrays.asList(properties.getWatchExpressions());
            }
            return null;
        }

        public boolean hasError() {
            return !Strings.isNullOrEmpty((String)this.getErrorMessage());
        }

        public void setVerified(boolean isVerified) {
            this.myIsVerified = isVerified;
        }
    }
}

