/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.client.util.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUtil {
    private static final Map<Project, Map<String, VirtualFile>> ourLocationMaps = new ConcurrentHashMap<Project, Map<String, VirtualFile>>();

    public static String getCloudPathFromJavaFile(PsiJavaFile javaFile) {
        return javaFile.getPackageName().replace('.', '/') + "/" + javaFile.getName();
    }

    public static VirtualFile getFileFromCloudPath(@NotNull Project project, @NotNull String cloudPath) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(0);
        }
        if (cloudPath == null) {
            JavaUtil.$$$reportNull$$$0(1);
        }
        return ourLocationMaps.get(project).get(cloudPath);
    }

    public static void initializeLocations(final @NotNull Project project, boolean forceRefresh) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(2);
        }
        if (forceRefresh || !ourLocationMaps.containsKey(project)) {
            final HashMap locationMap = Maps.newHashMap();
            ProjectFileIndex.SERVICE.getInstance((Project)project).iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    String cloudPathIndex = JavaUtil.getCloudPathFromFile(project, fileOrDir);
                    if (!Strings.isNullOrEmpty((String)cloudPathIndex)) {
                        locationMap.put(cloudPathIndex, fileOrDir);
                    }
                    return true;
                }
            });
            ourLocationMaps.put(project, locationMap);
        }
    }

    private static String getCloudPathFromFile(@Nullable Project project, @Nullable VirtualFile file) {
        if (file == null || project == null) {
            return null;
        }
        PsiFile javaFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(javaFile instanceof PsiJavaFile)) {
            return null;
        }
        return JavaUtil.getCloudPathFromJavaFile((PsiJavaFile)javaFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudPath";
                break;
            }
        }
        objectArray2[1] = "com/google/gct/idea/debugger/JavaUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileFromCloudPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeLocations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

