/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger.ui;

import com.google.api.services.debugger.model.Breakpoint;
import com.google.gct.idea.debugger.BreakpointUtil;
import com.google.gct.idea.debugger.CloudBreakpointListener;
import com.google.gct.idea.debugger.CloudDebugProcess;
import com.google.gct.idea.debugger.CloudDebugProcessHandler;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.util.GctBundle;
import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UI;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import icons.GoogleCloudToolsIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudDebugHistoricalSnapshots
extends AdditionalTabComponent
implements XDebugSessionListener,
CloudBreakpointListener {
    private static final int COLUMN_MARGIN_PX = 3;
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final int WINDOW_HEIGHT_PX = 56;
    private static final int WINDOW_WIDTH_PX = 200;
    private final JBTable myTable;
    private CloudDebugProcess myProcess;

    public CloudDebugHistoricalSnapshots(@NotNull CloudDebugProcessHandler processHandler) {
        if (processHandler == null) {
            CloudDebugHistoricalSnapshots.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout());
        this.myTable = new JBTable(){

            public Class getColumnClass(int column) {
                if (column == 0) {
                    return Icon.class;
                }
                Object value = this.getValueAt(0, column);
                return value != null ? this.getValueAt(0, column).getClass() : String.class;
            }

            @NotNull
            public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
                Component c;
                if (renderer == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((c = super.prepareRenderer(renderer, row, column)) instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    Breakpoint breakpoint = CloudDebugHistoricalSnapshots.this.getModel().getBreakpoints().get(row);
                    jc.setToolTipText(BreakpointUtil.getUserErrorMessage(breakpoint.getStatus()));
                }
                Component component = c;
                if (component == null) {
                    1.$$$reportNull$$$0(1);
                }
                return component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renderer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/google/gct/idea/debugger/ui/CloudDebugHistoricalSnapshots$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/google/gct/idea/debugger/ui/CloudDebugHistoricalSnapshots$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepareRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepareRenderer";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myTable.setModel((TableModel)new MyModel(null));
        this.myTable.setTableHeader(null);
        this.myTable.setShowGrid(false);
        this.myTable.setRowMargin(0);
        this.myTable.getColumnModel().setColumnMargin(0);
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new SnapshotTimeCellRenderer());
        this.myTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultRenderer());
        this.myTable.getColumnModel().getColumn(3).setCellRenderer(new DefaultRenderer());
        this.myTable.getColumnModel().getColumn(4).setCellRenderer(new MoreCellRenderer());
        this.myTable.resetDefaultFocusTraversalKeys();
        this.myTable.setAutoResizeMode(3);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(200, 56));
        this.myTable.setAutoCreateColumnsFromModel(false);
        this.myTable.getEmptyText().setText(GctBundle.getString("clouddebug.nosnapshots", new Object[0]));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().disableAddAction();
        decorator.setToolbarPosition(ActionToolbarPosition.TOP);
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CloudDebugHistoricalSnapshots.this.fireDeleteBreakpoints(CloudDebugHistoricalSnapshots.this.getSelectedBreakpoints());
            }
        });
        decorator.addExtraAction(new AnActionButton(GctBundle.getString("clouddebug.delete.all", new Object[0]), GoogleCloudToolsIcons.CLOUD_DEBUG_DELETE_ALL_BREAKPOINTS){

            public void actionPerformed(AnActionEvent e) {
                if (Messages.showDialog((String)GctBundle.getString("clouddebug.remove.all", new Object[0]), (String)GctBundle.getString("clouddebug.delete.snapshots", new Object[0]), (String[])new String[]{GctBundle.getString("clouddebug.buttondelete", new Object[0]), GctBundle.getString("clouddebug.cancelbutton", new Object[0])}, (int)1, (Icon)Messages.getQuestionIcon()) == 0) {
                    MyModel model = (MyModel)CloudDebugHistoricalSnapshots.this.myTable.getModel();
                    CloudDebugHistoricalSnapshots.this.fireDeleteBreakpoints(model.getBreakpoints());
                }
            }
        });
        decorator.addExtraAction(new AnActionButton(GctBundle.getString("clouddebug.reactivatesnapshotlocation", new Object[0]), GoogleCloudToolsIcons.CLOUD_DEBUG_REACTIVATE_BREAKPOINT){

            public void actionPerformed(AnActionEvent e) {
                CloudDebugHistoricalSnapshots.this.myProcess.getBreakpointHandler().cloneToNewBreakpoints(CloudDebugHistoricalSnapshots.this.getSelectedBreakpoints());
            }
        });
        this.add(decorator.createPanel());
        this.myProcess = processHandler.getProcess();
        this.onBreakpointsChanged();
        this.myProcess.getXDebugSession().addSessionListener((XDebugSessionListener)this);
        this.myProcess.addListener(this);
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                Breakpoint breakpoint = CloudDebugHistoricalSnapshots.this.getBreakPoint(p);
                int col = table.columnAtPoint(p);
                if (me.getClickCount() == 2 && breakpoint != null) {
                    CloudDebugHistoricalSnapshots.this.myProcess.navigateToSnapshot(breakpoint.getId());
                } else if (breakpoint != null && col == 4 && CloudDebugHistoricalSnapshots.this.supportsMoreConfig(breakpoint)) {
                    BreakpointsDialogFactory.getInstance((Project)CloudDebugHistoricalSnapshots.this.myProcess.getXDebugSession().getProject()).showDialog((Object)CloudDebugHistoricalSnapshots.this.myProcess.getBreakpointHandler().getXBreakpoint(breakpoint));
                }
            }
        });
        this.myTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent me) {
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                int column = table.columnAtPoint(p);
                Breakpoint breakpoint = CloudDebugHistoricalSnapshots.this.getBreakPoint(p);
                if (column == 4 && breakpoint != null && CloudDebugHistoricalSnapshots.this.supportsMoreConfig(breakpoint)) {
                    if (CloudDebugHistoricalSnapshots.this.myTable.getCursor() != HAND_CURSOR) {
                        CloudDebugHistoricalSnapshots.this.myTable.setCursor(HAND_CURSOR);
                    }
                    return;
                }
                if (CloudDebugHistoricalSnapshots.this.myTable.getCursor() != DEFAULT_CURSOR) {
                    CloudDebugHistoricalSnapshots.this.myTable.setCursor(DEFAULT_CURSOR);
                }
            }
        });
    }

    public void beforeSessionResume() {
    }

    public void dispose() {
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTable;
    }

    @Nullable
    public JComponent getSearchComponent() {
        return null;
    }

    @NotNull
    public String getTabTitle() {
        if ("Cloud Debugger Snapshots" == null) {
            CloudDebugHistoricalSnapshots.$$$reportNull$$$0(1);
        }
        return "Cloud Debugger Snapshots";
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        return null;
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        return null;
    }

    @Nullable
    public String getToolbarPlace() {
        return "unknown";
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    @Override
    public void onBreakpointListChanged(CloudDebugProcessState state) {
        this.onBreakpointsChanged();
    }

    public void sessionPaused() {
        this.onBreakpointsChanged();
    }

    public void sessionResumed() {
    }

    public void sessionStopped() {
        this.myProcess.removeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudDebugHistoricalSnapshots.this.myTable.setModel((TableModel)new MyModel(null));
            }
        });
    }

    public void stackFrameChanged() {
    }

    private void fireDeleteBreakpoints(final @NotNull List<Breakpoint> breakpointsToDelete) {
        if (breakpointsToDelete == null) {
            CloudDebugHistoricalSnapshots.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                for (Breakpoint aBreakpointsToDelete : breakpointsToDelete) {
                    CloudDebugHistoricalSnapshots.this.myProcess.getBreakpointHandler().deleteBreakpoint(aBreakpointsToDelete);
                }
            }
        });
    }

    @Nullable
    private Breakpoint getBreakPoint(@NotNull Point p) {
        int row;
        if (p == null) {
            CloudDebugHistoricalSnapshots.$$$reportNull$$$0(3);
        }
        if ((row = this.myTable.rowAtPoint(p)) >= 0 && row < this.getModel().getBreakpoints().size()) {
            return this.getModel().getBreakpoints().get(row);
        }
        return null;
    }

    @NotNull
    private MyModel getModel() {
        MyModel myModel = (MyModel)this.myTable.getModel();
        if (myModel == null) {
            CloudDebugHistoricalSnapshots.$$$reportNull$$$0(4);
        }
        return myModel;
    }

    @NotNull
    private List<Breakpoint> getSelectedBreakpoints() {
        int[] selectedRows;
        ArrayList<Breakpoint> selectedBreakpoints = new ArrayList<Breakpoint>();
        MyModel model = (MyModel)this.myTable.getModel();
        for (int selectedRow : selectedRows = this.myTable.getSelectedRows()) {
            selectedBreakpoints.add(model.getBreakpoints().get(selectedRow));
        }
        ArrayList<Breakpoint> arrayList = selectedBreakpoints;
        if (arrayList == null) {
            CloudDebugHistoricalSnapshots.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void onBreakpointsChanged() {
        final List<Breakpoint> breakpointList = this.myProcess.getCurrentBreakpointList();
        int selection = -1;
        if (breakpointList != null) {
            for (int i = 0; i < breakpointList.size(); ++i) {
                if (breakpointList.get(i).getFinalTime() == null || this.myProcess.getCurrentSnapshot() == null || !breakpointList.get(i).getId().equals(this.myProcess.getCurrentSnapshot().getId())) continue;
                selection = i;
                break;
            }
        }
        final int finalSelection = selection;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudDebugHistoricalSnapshots.this.myTable.setModel((TableModel)new MyModel(breakpointList));
                if (finalSelection != -1) {
                    CloudDebugHistoricalSnapshots.this.myTable.setRowSelectionInterval(finalSelection, finalSelection);
                }
                CloudDebugHistoricalSnapshots.this.resizeColumnWidth();
            }
        });
    }

    private void resizeColumnWidth() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int column = 0; column < this.myTable.getColumnCount(); ++column) {
            int width = 2;
            for (int row = 0; row < this.myTable.getRowCount(); ++row) {
                TableCellRenderer renderer = this.myTable.getCellRenderer(row, column);
                Component comp = this.myTable.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width, width);
            }
            columnModel.getColumn(column).setPreferredWidth(width += 3);
            columnModel.getColumn(column).setMaxWidth(width);
            if (column > 2) continue;
            columnModel.getColumn(column).setMinWidth(width);
        }
    }

    private boolean supportsMoreConfig(@Nullable Breakpoint breakpoint) {
        return this.myProcess.getBreakpointHandler().getXBreakpoint(breakpoint) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/debugger/ui/CloudDebugHistoricalSnapshots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointsToDelete";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/debugger/ui/CloudDebugHistoricalSnapshots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedBreakpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fireDeleteBreakpoints";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBreakPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyModel
    extends AbstractTableModel {
        private static final int ourColumnCount = 5;
        private final List<Breakpoint> myBreakpoints;

        public MyModel(List<Breakpoint> breakpoints) {
            this.myBreakpoints = breakpoints != null ? breakpoints : new ArrayList();
        }

        @NotNull
        public List<Breakpoint> getBreakpoints() {
            List<Breakpoint> list = this.myBreakpoints;
            if (list == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.myBreakpoints.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.myBreakpoints.size()) {
                return null;
            }
            Breakpoint breakpoint = this.myBreakpoints.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (breakpoint.getStatus() != null && breakpoint.getStatus().getIsError() == Boolean.TRUE) {
                        return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_ERROR;
                    }
                    if (breakpoint.getIsFinalState() != Boolean.TRUE) {
                        return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_CHECKED;
                    }
                    return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_FINAL;
                }
                case 1: {
                    if (breakpoint.getIsFinalState() != Boolean.TRUE) {
                        return GctBundle.getString("clouddebug.pendingstatus", new Object[0]);
                    }
                    return new Date(breakpoint.getFinalTime().getSeconds() * 1000L);
                }
                case 2: {
                    String path = breakpoint.getLocation().getPath();
                    int startIndex = path.lastIndexOf(47);
                    return path.substring(startIndex >= 0 ? startIndex + 1 : 0) + ":" + breakpoint.getLocation().getLine().toString();
                }
                case 3: {
                    return breakpoint.getCondition();
                }
                case 4: {
                    if (!CloudDebugHistoricalSnapshots.this.supportsMoreConfig(breakpoint)) break;
                    return GctBundle.getString("clouddebug.moreHTML", new Object[0]);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/debugger/ui/CloudDebugHistoricalSnapshots$MyModel", "getBreakpoints"));
        }
    }

    private static class DefaultRenderer
    extends DefaultTableCellRenderer {
        private DefaultRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(noFocusBorder);
            return this;
        }
    }

    static final class MoreCellRenderer
    extends DefaultTableCellRenderer {
        public MoreCellRenderer() {
            this.setHorizontalAlignment(2);
            this.setForeground(UI.getColor((String)"link.foreground"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(noFocusBorder);
            if (value != null) {
                this.setText(value.toString());
            }
            return this;
        }
    }

    static final class SnapshotTimeCellRenderer
    extends DefaultTableCellRenderer {
        private static final DateFormat ourDateFormat = DateFormat.getDateTimeInstance(3, 3);
        private static final DateFormat ourDateFormatToday = DateFormat.getTimeInstance(3);
        private final Date myTodayDate;

        public SnapshotTimeCellRenderer() {
            this.setHorizontalAlignment(2);
            GregorianCalendar c = new GregorianCalendar();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            this.myTodayDate = c.getTime();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Font font;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(noFocusBorder);
            boolean isToday = false;
            if (value instanceof Date) {
                Date finalDate = (Date)value;
                if (finalDate.after(this.myTodayDate)) {
                    this.setText(ourDateFormatToday.format(finalDate));
                    isToday = true;
                } else {
                    this.setText(ourDateFormat.format(finalDate));
                }
            } else {
                this.setText(value.toString());
            }
            if (GctBundle.getString("clouddebug.pendingstatus", new Object[0]).equals(value)) {
                font = this.getFont();
                Font boldFont = new Font(font.getFontName(), 1, font.getSize());
                this.setFont(boldFont);
                if (!isSelected) {
                    this.setForeground(UIUtil.getActiveTextColor());
                }
            } else {
                font = this.getFont();
                Font boldFont = new Font(font.getFontName(), 0, font.getSize());
                this.setFont(boldFont);
                if (!isSelected) {
                    this.setForeground(isToday ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
                }
            }
            return this;
        }
    }
}

