/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.google.gct.idea.git.GcpHttpAuthDataProvider;
import com.google.gct.idea.git.SetupCloudRepositoryDialog;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.util.GitFileUtils;
import git4idea.util.GitUIUtil;
import icons.GoogleCloudToolsIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetupCloudRepositoryAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(SetupCloudRepositoryAction.class);
    private static final String NOTIFICATION_GROUP_ID = "Google App Engine plugin";

    public SetupCloudRepositoryAction() {
        super(GctBundle.message("uploadtogcp.text", new Object[0]), GctBundle.message("uploadtogcp.description", new Object[0]), GoogleCloudToolsIcons.CLOUD);
    }

    public void update(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            event.getPresentation().setVisible(false);
            event.getPresentation().setEnabled(false);
            return;
        }
        event.getPresentation().setVisible(true);
        event.getPresentation().setEnabled(true);
    }

    public void actionPerformed(AnActionEvent event) {
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "vcs", "upload", null);
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed() || !SetupCloudRepositoryAction.isGitSupported(project)) {
            return;
        }
        SetupCloudRepositoryAction.uploadProjectToGoogleCloud(project, file);
    }

    private static void uploadProjectToGoogleCloud(final @NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(0);
        }
        BasicAction.saveAll();
        project.save();
        GitRepository gitRepository = SetupCloudRepositoryAction.getGitRepository(project, file);
        final boolean gitDetected = gitRepository != null;
        final VirtualFile root = gitDetected ? gitRepository.getRoot() : project.getBaseDir();
        SetupCloudRepositoryDialog dialog = new SetupCloudRepositoryDialog(project, gitRepository, GctBundle.message("uploadtogcp.title", new Object[0]), GctBundle.message("uploadtogcp.oktext", new Object[0]));
        DialogManager.show((DialogWrapper)dialog);
        if (!dialog.isOK() || dialog.getCredentialedUser() == null || Strings.isNullOrEmpty((String)dialog.getProjectId())) {
            return;
        }
        final String remoteName = dialog.getRemoteName();
        if (gitRepository != null && SetupCloudRepositoryAction.hasRemote(gitRepository.getRemotes(), remoteName)) {
            Notification notification = new Notification(NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.remotename.collision.title", new Object[0]), GctBundle.message("uploadtogcp.remotename.collision", remoteName), NotificationType.ERROR);
            notification.notify(project);
            return;
        }
        final String projectId = dialog.getProjectId();
        final String repositoryId = dialog.getRepositoryId();
        final CredentialedUser user = dialog.getCredentialedUser();
        new Task.Backgroundable(project, GctBundle.message("uploadtogcp.backgroundtitle", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                GitRepositoryManager repositoryManager;
                GitRepository repository;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.info("Binding local project with Git");
                if (!gitDetected) {
                    LOG.info("No git detected, creating empty git repo");
                    indicator.setText(GctBundle.message("uploadtogcp.indicatorinit", new Object[0]));
                    if (!SetupCloudRepositoryAction.createEmptyGitRepository(project, root, indicator)) {
                        return;
                    }
                }
                if ((repository = (GitRepository)(repositoryManager = GitUtil.getRepositoryManager((Project)project)).getRepositoryForRoot(root)) == null) {
                    SwingUtilities.invokeLater(() -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Notification notification = new Notification(SetupCloudRepositoryAction.NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.generic.failure.title", new Object[0]), GctBundle.message("uploadtogcp.failedtocreategit", new Object[0]), NotificationType.ERROR);
                        notification.notify(project);
                    });
                    LOG.error("GitRepository is null for root " + root);
                    return;
                }
                String remoteUrl = GcpHttpAuthDataProvider.getGcpUrl(projectId, repositoryId);
                LOG.info("Adding Google as a remote host");
                indicator.setText(GctBundle.message("uploadtogcp.addingremote", new Object[0]));
                if (!SetupCloudRepositoryAction.addGitRemote(project, repository, remoteName, remoteUrl)) {
                    return;
                }
                boolean succeeded = false;
                try {
                    PropertiesComponent.getInstance((Project)project).setValue("com.google.gct.idea.git.username", user.getEmail());
                    LOG.info("Fetching from Google remote");
                    indicator.setText(GctBundle.message("uploadtogcp.fetching", new Object[0]));
                    if (!SetupCloudRepositoryAction.fetchGit(project, indicator, repository, remoteName)) {
                        return;
                    }
                    if (!SetupCloudRepositoryAction.performFirstCommitIfRequired(project, root, repository, indicator)) {
                        return;
                    }
                    LOG.info("Pushing to Google master");
                    indicator.setText(GctBundle.message("uploadtogcp.pushingtotgcp", new Object[0]));
                    if (!SetupCloudRepositoryAction.pushCurrentBranch(project, repository, remoteName, remoteUrl)) {
                        return;
                    }
                    succeeded = true;
                }
                finally {
                    if (!succeeded) {
                        SetupCloudRepositoryAction.removeGitRemote(project, repository, remoteName);
                    }
                }
                SetupCloudRepositoryAction.showInfoUrl(project, remoteName, GctBundle.message("uploadtogcp.success", new Object[0]), remoteUrl);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/google/gct/idea/git/SetupCloudRepositoryAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    static void showInfoUrl(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String url) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(1);
        }
        if (title == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(2);
        }
        if (message == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(3);
        }
        if (url == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(4);
        }
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, "<a href='" + url + "'>" + message + "</a>", NotificationListener.URL_OPENING_LISTENER);
    }

    private static boolean hasRemote(@NotNull Collection<GitRemote> remotes, @NotNull String remoteName) {
        if (remotes == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(5);
        }
        if (remoteName == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(6);
        }
        return remotes.stream().anyMatch(remote -> {
            if (remoteName == null) {
                SetupCloudRepositoryAction.$$$reportNull$$$0(42);
            }
            return remoteName.equals(remote.getName());
        });
    }

    @Nullable
    private static GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        GitRepository repository;
        GitRepositoryManager manager;
        List repositories;
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(7);
        }
        if ((repositories = (manager = GitUtil.getRepositoryManager((Project)project)).getRepositories()).isEmpty()) {
            return null;
        }
        if (repositories.size() == 1) {
            return (GitRepository)repositories.get(0);
        }
        if (file != null && (repository = (GitRepository)manager.getRepositoryForFile(file)) != null) {
            return repository;
        }
        return (GitRepository)manager.getRepositoryForFile(project.getBaseDir());
    }

    private static boolean isGitSupported(Project project) {
        GitVersion version;
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        String executable = settings.getPathToGit();
        try {
            version = GitVersion.identifyVersion((String)executable);
        }
        catch (Exception ex) {
            Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.giterror", new Object[0]), (String)ex.getMessage());
            return false;
        }
        if (!version.isSupported()) {
            Messages.showWarningDialog((Project)project, (String)GctBundle.message("uploadtogcp.git.unsupported.message", version.toString(), GitVersion.MIN), (String)GctBundle.message("uploadtogcp.giterror", new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean createEmptyGitRepository(final @NotNull Project project, @NotNull VirtualFile root, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(8);
        }
        if (root == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(10);
        }
        GitLineHandler gitLineHandler = new GitLineHandler(project, root, GitCommand.INIT);
        gitLineHandler.setStdoutSuppressed(false);
        GitHandlerUtil.runInCurrentThread((GitHandler)gitLineHandler, (ProgressIndicator)indicator, (boolean)true, (String)GitBundle.getString((String)"initializing.title"));
        if (!gitLineHandler.errors().isEmpty()) {
            GitUIUtil.showOperationErrors((Project)project, (Collection)gitLineHandler.errors(), (String)"git init");
            LOG.info("Failed to create empty git repo: " + gitLineHandler.errors());
            return false;
        }
        try {
            GitConfigUtil.setValue((Project)project, (VirtualFile)root, (String)"credential.https://source.developers.google.com.useHttpPath", (String)"true", (String[])new String[0]);
        }
        catch (VcsException ex) {
            LOG.error("VcsException while setting up credential parameters (credentials will be not be cached per project url)" + ex.toString());
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
        try {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    project.save();
                }
            }, indicator.getModalityState());
        }
        catch (ProcessCanceledException ex) {
            Thread.currentThread().interrupt();
            LOG.error("ProcessCanceledException while saving project: " + ex.toString());
            return false;
        }
        return true;
    }

    private static boolean fetchGit(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull GitRepository repository, @NotNull String remote) {
        GitFetcher fetcher;
        GitFetchResult result;
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(12);
        }
        if (repository == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(13);
        }
        if (remote == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(14);
        }
        if (!(result = (fetcher = new GitFetcher(project, indicator, true)).fetch(repository)).isSuccess()) {
            SwingUtilities.invokeLater(() -> {
                if (remote == null) {
                    SetupCloudRepositoryAction.$$$reportNull$$$0(40);
                }
                if (project == null) {
                    SetupCloudRepositoryAction.$$$reportNull$$$0(41);
                }
                Notification notification = new Notification(NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.fetchfailedtitle", new Object[0]), GctBundle.message("uploadtogcp.fetchfailed", remote), NotificationType.ERROR);
                notification.notify(project);
            });
            return false;
        }
        repository.update();
        return true;
    }

    private static boolean addGitRemote(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remote, @NotNull String url) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(15);
        }
        if (repository == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(16);
        }
        if (remote == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(17);
        }
        if (url == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(18);
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"add", remote, url});
            handler.run();
            if (handler.getExitCode() != 0) {
                SwingUtilities.invokeLater(() -> {
                    if (url == null) {
                        SetupCloudRepositoryAction.$$$reportNull$$$0(38);
                    }
                    if (project == null) {
                        SetupCloudRepositoryAction.$$$reportNull$$$0(39);
                    }
                    Notification notification = new Notification(NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.addremotefailedtitle", new Object[0]), GctBundle.message("uploadtogcp.addremotefailed", url, handler.getStderr()), NotificationType.ERROR);
                    notification.notify(project);
                });
                return false;
            }
            repository.update();
            return true;
        }
        catch (VcsException ex) {
            SwingUtilities.invokeLater(() -> {
                if (url == null) {
                    SetupCloudRepositoryAction.$$$reportNull$$$0(36);
                }
                if (project == null) {
                    SetupCloudRepositoryAction.$$$reportNull$$$0(37);
                }
                Notification notification = new Notification(NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.addremotefailedtitle", new Object[0]), GctBundle.message("uploadtogcp.addremotefailed", url, ex.toString()), NotificationType.ERROR);
                notification.notify(project);
            });
            return false;
        }
    }

    private static void removeGitRemote(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remote) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(19);
        }
        if (repository == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(20);
        }
        if (remote == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(21);
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"remove", remote});
            handler.run();
        }
        catch (VcsException ex) {
            LOG.error("error removing newly added remote on error:" + ex.toString());
        }
        repository.update();
    }

    private static boolean performFirstCommitIfRequired(final @NotNull Project project, @NotNull VirtualFile root, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(22);
        }
        if (root == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(23);
        }
        if (repository == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(25);
        }
        if (!repository.isFresh()) {
            return true;
        }
        LOG.info("Trying to commit");
        try {
            LOG.info("Adding files for commit");
            indicator.setText(GctBundle.getString("uploadsourceaction.addfiles", new Object[0]));
            final List trackedFiles = ChangeListManager.getInstance((Project)project).getAffectedFiles();
            Collection<VirtualFile> untrackedFiles = SetupCloudRepositoryAction.filterOutIgnored(project, repository.getUntrackedFilesHolder().retrieveUntrackedFiles());
            trackedFiles.removeAll(untrackedFiles);
            final ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
            allFiles.addAll(trackedFiles);
            allFiles.addAll(untrackedFiles);
            final Ref dialogRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GcpUntrackedFilesDialog dialog = new GcpUntrackedFilesDialog(project, allFiles);
                    if (!trackedFiles.isEmpty()) {
                        dialog.setSelectedFiles(trackedFiles);
                    }
                    DialogManager.show((DialogWrapper)dialog);
                    dialogRef.set((Object)dialog);
                }
            }, indicator.getModalityState());
            GcpUntrackedFilesDialog dialog = (GcpUntrackedFilesDialog)((Object)dialogRef.get());
            Collection filesToCommit = dialog.getSelectedFiles();
            if (!dialog.isOK() || filesToCommit.isEmpty()) {
                LOG.warn("user canceled out of initial commit.  aborting...");
                return false;
            }
            HashSet filesToCommitAsSet = new HashSet(filesToCommit);
            HashSet untrackedFilesAsSet = new HashSet(untrackedFiles);
            HashSet trackedFilesAsSet = new HashSet((Collection)trackedFiles);
            Sets.SetView filesToAdd = Sets.intersection((Set)untrackedFilesAsSet, (Set)filesToCommitAsSet);
            Sets.SetView filesToRm = Sets.difference((Set)trackedFilesAsSet, (Set)filesToCommitAsSet);
            HashSet modified = new HashSet((Collection)trackedFiles);
            modified.addAll(filesToCommit);
            GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)filesToAdd);
            GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)filesToRm);
            LOG.info("Performing commit");
            indicator.setText(GctBundle.getString("uploadsourceaction.performingcommit", new Object[0]));
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{"-m", dialog.getCommitMessage()});
            handler.endOptions();
            handler.run();
            VcsFileUtil.markFilesDirty((Project)project, (Collection)modified);
        }
        catch (VcsException ex) {
            LOG.warn((Throwable)ex);
            SwingUtilities.invokeLater(() -> {
                if (project == null) {
                    SetupCloudRepositoryAction.$$$reportNull$$$0(35);
                }
                Notification notification = new Notification(NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.initialcommitfailedtitle", new Object[0]), GctBundle.message("uploadtogcp.initialcommitfailed", ex.toString()), NotificationType.ERROR);
                notification.notify(project);
            });
            return false;
        }
        LOG.info("Successfully created initial commit");
        return true;
    }

    @NotNull
    private static Collection<VirtualFile> filterOutIgnored(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(26);
        }
        if (files == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(27);
        }
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        final FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)project);
        Collection collection = Collections2.filter(files, (Predicate)new Predicate<VirtualFile>(){

            public boolean apply(VirtualFile file) {
                return !changeListManager.isIgnoredFile(file) && !fileIndex.isExcludedFile(file);
            }
        });
        if (collection == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(28);
        }
        return collection;
    }

    private static boolean pushCurrentBranch(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remoteName, @NotNull String remoteUrl) {
        if (project == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(29);
        }
        if (repository == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(30);
        }
        if (remoteName == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(31);
        }
        if (remoteUrl == null) {
            SetupCloudRepositoryAction.$$$reportNull$$$0(32);
        }
        Git git = (Git)ServiceManager.getService(Git.class);
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            SwingUtilities.invokeLater(() -> {
                if (project == null) {
                    SetupCloudRepositoryAction.$$$reportNull$$$0(34);
                }
                Notification notification = new Notification(NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.initialpushfailedtitle", new Object[0]), GctBundle.message("uploadtogcp.initialpushfailed", new Object[0]), NotificationType.ERROR);
                notification.notify(project);
            });
            return false;
        }
        GitCommandResult result = git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
        if (!result.success()) {
            LOG.warn(result.getErrorOutputAsJoinedString());
            SwingUtilities.invokeLater(() -> {
                if (project == null) {
                    SetupCloudRepositoryAction.$$$reportNull$$$0(33);
                }
                Notification notification = new Notification(NOTIFICATION_GROUP_ID, GctBundle.message("uploadtogcp.initialpushfailedtitle", new Object[0]), result.getErrorOutputAsHtmlString() + "<br/>" + SetupCloudRepositoryAction.joinAsErrorHtmlString(result.getOutput()), NotificationType.ERROR);
                notification.notify(project);
            });
            return false;
        }
        return true;
    }

    private static String joinAsErrorHtmlString(List<String> error) {
        return error.stream().collect(Collectors.joining("<br/>"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 18: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 6: 
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 16: 
            case 20: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 14: 
            case 17: 
            case 21: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/idea/git/SetupCloudRepositoryAction";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/idea/git/SetupCloudRepositoryAction";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutIgnored";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadProjectToGoogleCloud";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showInfoUrl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasRemote";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGitRepository";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyGitRepository";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fetchGit";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addGitRemote";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeGitRemote";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "performFirstCommitIfRequired";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterOutIgnored";
                break;
            }
            case 28: {
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "pushCurrentBranch";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$pushCurrentBranch$6";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$pushCurrentBranch$5";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performFirstCommitIfRequired$4";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addGitRemote$3";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addGitRemote$2";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchGit$1";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasRemote$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GcpUntrackedFilesDialog
    extends SelectFilesDialog
    implements TypeSafeDataProvider {
        private static final float SPLIT_PROPORTION = 0.7f;
        @NotNull
        private final Project project;
        private CommitMessage commitMessagePanel;

        public GcpUntrackedFilesDialog(@NotNull Project project, @NotNull List<VirtualFile> untrackedFiles) {
            if (project == null) {
                GcpUntrackedFilesDialog.$$$reportNull$$$0(0);
            }
            if (untrackedFiles == null) {
                GcpUntrackedFilesDialog.$$$reportNull$$$0(1);
            }
            super(project, untrackedFiles, null, null, true, false, false);
            this.project = project;
            this.setTitle(GctBundle.getString("uploadsourceaction.addfilestitle", new Object[0]));
            this.init();
        }

        protected JComponent createNorthPanel() {
            return null;
        }

        protected JComponent createCenterPanel() {
            JComponent tree = super.createCenterPanel();
            this.commitMessagePanel = new CommitMessage(this.project);
            this.commitMessagePanel.setCommitMessage("Initial commit");
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree);
            splitter.setSecondComponent((JComponent)this.commitMessagePanel);
            splitter.setProportion(0.7f);
            return splitter;
        }

        @NotNull
        public String getCommitMessage() {
            String string = this.commitMessagePanel.getComment();
            if (string == null) {
                GcpUntrackedFilesDialog.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key == VcsDataKeys.COMMIT_MESSAGE_CONTROL) {
                sink.put(VcsDataKeys.COMMIT_MESSAGE_CONTROL, (Object)this.commitMessagePanel);
            }
        }

        protected String getDimensionServiceKey() {
            return "GCP.UntrackedFilesDialog";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "untrackedFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/idea/git/SetupCloudRepositoryAction$GcpUntrackedFilesDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/idea/git/SetupCloudRepositoryAction$GcpUntrackedFilesDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

