/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.StringHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class StringHelperPOSIX
extends StringHelper {
    public static List<String> splitCommandLine(String commandLine) {
        ArrayList commands = Lists.newArrayList();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        int commandStart = 0;
        for (int i = 0; i < commandLine.length(); ++i) {
            char c = commandLine.charAt(i);
            if (escaping) {
                escaping = false;
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (quoting) continue;
            int matched = 0;
            if (commandLine.length() > i + 1 && commandLine.charAt(i) == '&' && commandLine.charAt(i + 1) == '&') {
                matched = 2;
            } else if (commandLine.charAt(i) == ';') {
                matched = 1;
            }
            if (matched <= 0) continue;
            commands.add(commandLine.substring(commandStart, i));
            commandStart = i += matched;
        }
        if (commandStart < commandLine.length()) {
            commands.add(commandLine.substring(commandStart));
        }
        return commands;
    }

    public static List<String> tokenizeCommandLineToEscaped(String commandLine) {
        return StringHelperPOSIX.tokenizeCommandLine(commandLine, true);
    }

    public static List<String> tokenizeCommandLineToRaw(String commandLine) {
        return StringHelperPOSIX.tokenizeCommandLine(commandLine, false);
    }

    private static List<String> tokenizeCommandLine(String commandLine, boolean returnEscaped) {
        ArrayList tokens = Lists.newArrayList();
        StringBuilder token = new StringBuilder();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        for (int i = 0; i < commandLine.length(); ++i) {
            char c = commandLine.charAt(i);
            if (skipping) {
                if (Character.isWhitespace(c)) continue;
                skipping = false;
            }
            if (!(!quoting && Character.isWhitespace(c) || returnEscaped)) {
                token.append(c);
            }
            if (escaping) {
                escaping = false;
                if (c == '\n' || !returnEscaped) continue;
                token.append(c);
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                skipping = true;
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            if (!returnEscaped) continue;
            token.append(c);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

