/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

@State(name="CoverageViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class CoverageViewManager
implements PersistentStateComponent<StateBean> {
    private static final Logger LOG = Logger.getInstance(CoverageViewManager.class);
    public static final String TOOLWINDOW_ID = "Coverage";
    private final Project myProject;
    private final CoverageDataManager myDataManager;
    private final ContentManager myContentManager;
    private StateBean myStateBean = new StateBean();
    private final Map<String, CoverageView> myViews = new HashMap<String, CoverageView>();
    private boolean myReady;

    public CoverageViewManager(Project project, ToolWindowManager toolWindowManager, CoverageDataManager dataManager) {
        this.myProject = project;
        this.myDataManager = dataManager;
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, true, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true, true);
        toolWindow.setHelpId("reference.toolWindows.Coverage");
        toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowCoverage);
        this.myContentManager = toolWindow.getContentManager();
        new ContentManagerWatcher(toolWindow, this.myContentManager);
    }

    public StateBean getState() {
        return this.myStateBean;
    }

    public void loadState(@NotNull StateBean state) {
        if (state == null) {
            CoverageViewManager.$$$reportNull$$$0(0);
        }
        this.myStateBean = state;
    }

    public CoverageView getToolwindow(CoverageSuitesBundle suitesBundle) {
        return this.myViews.get(CoverageViewManager.getDisplayName(suitesBundle));
    }

    public void activateToolwindow(CoverageView view, boolean requestFocus) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOLWINDOW_ID);
        if (requestFocus) {
            this.myContentManager.setSelectedContent(this.myContentManager.getContent((JComponent)((Object)view)));
            LOG.assertTrue(toolWindow != null);
            toolWindow.activate(null, false);
        }
    }

    public static CoverageViewManager getInstance(@NotNull Project project) {
        if (project == null) {
            CoverageViewManager.$$$reportNull$$$0(1);
        }
        return (CoverageViewManager)ServiceManager.getService((Project)project, CoverageViewManager.class);
    }

    public void createToolWindow(String displayName, boolean defaultFileProvider) {
        CoverageView coverageView = new CoverageView(this.myProject, this.myDataManager, this.myStateBean);
        this.myViews.put(displayName, coverageView);
        Content content = this.myContentManager.getFactory().createContent((JComponent)((Object)coverageView), displayName, true);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        if (CoverageOptionsProvider.getInstance(this.myProject).activateViewOnRun() && defaultFileProvider) {
            this.activateToolwindow(coverageView, true);
        }
    }

    void closeView(String displayName) {
        CoverageView oldView = this.myViews.remove(displayName);
        if (oldView != null) {
            Content content = this.myContentManager.getContent((JComponent)((Object)oldView));
            Runnable runnable = () -> {
                if (content != null) {
                    this.myContentManager.removeContent(content, false);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable);
        }
        this.setReady(false);
    }

    public boolean isReady() {
        return this.myReady;
    }

    public void setReady(boolean ready) {
        this.myReady = ready;
    }

    public static String getDisplayName(CoverageSuitesBundle suitesBundle) {
        RunConfigurationBase configuration = suitesBundle.getRunConfiguration();
        return configuration != null ? configuration.getName() : suitesBundle.getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/view/CoverageViewManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class StateBean {
        public boolean myFlattenPackages = false;
        public boolean myAutoScrollToSource = false;
        public boolean myAutoScrollFromSource = false;
    }
}

