/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.editor.BootstrapMethodsAttributeEditor;
import proguard.classfile.editor.ConstantAdder;

public class BootstrapMethodInfoAdder
implements BootstrapMethodInfoVisitor {
    private final ConstantAdder constantAdder;
    private final BootstrapMethodsAttributeEditor bootstrapMethodsAttributeEditor;
    private int bootstrapMethodIndex;

    public BootstrapMethodInfoAdder(ProgramClass targetClass, BootstrapMethodsAttribute targetBootstrapMethodsAttribute) {
        this.constantAdder = new ConstantAdder(targetClass);
        this.bootstrapMethodsAttributeEditor = new BootstrapMethodsAttributeEditor(targetBootstrapMethodsAttribute);
    }

    public int getBootstrapMethodIndex() {
        return this.bootstrapMethodIndex;
    }

    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        int methodArgumentCount = bootstrapMethodInfo.u2methodArgumentCount;
        int[] methodArguments = bootstrapMethodInfo.u2methodArguments;
        int[] newMethodArguments = new int[methodArgumentCount];
        for (int index = 0; index < methodArgumentCount; ++index) {
            newMethodArguments[index] = this.constantAdder.addConstant(clazz, methodArguments[index]);
        }
        BootstrapMethodInfo newBootstrapMethodInfo = new BootstrapMethodInfo(this.constantAdder.addConstant(clazz, bootstrapMethodInfo.u2methodHandleIndex), methodArgumentCount, newMethodArguments);
        this.bootstrapMethodIndex = this.bootstrapMethodsAttributeEditor.addBootstrapMethodInfo(newBootstrapMethodInfo);
    }
}

