/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class CpuTable
extends DataStoreTable<CpuStatements> {
    private static final int DATA_COLUMN = 1;
    private static final int PROFILER_TYPE_COLUMN_TRACE_DATA = 2;

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            CpuTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Cpu_Data", "Session INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Data BLOB");
            this.createTable("Thread_Activities", "Session INTEGER NOT NULL", "ThreadId INTEGER NOT NULL", "Timestamp INTEGER", "State TEXT, Name TEXT");
            this.createTable("Cpu_Trace", "Session INTEGER NOT NULL", "TraceId INTEGER NOT NULL", "ProfilerType TEXT", "Data BLOB");
            this.createTable("Cpu_Trace_Info", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "TraceInfo BLOB");
            this.createTable("Profiling_State", "Session INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Data BLOB");
            this.createUniqueIndex("Cpu_Data", "Session", "Timestamp");
            this.createUniqueIndex("Cpu_Trace", "Session", "TraceId");
            this.createUniqueIndex("Thread_Activities", "Session", "ThreadId", "Timestamp");
            this.createUniqueIndex("Profiling_State", "Session", "Timestamp");
        }
        catch (SQLException ex) {
            CpuTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(CpuStatements.INSERT_CPU_DATA, "INSERT OR REPLACE INTO Cpu_Data (Session, Timestamp, Data) values (?, ?, ?)");
            this.createStatement(CpuStatements.QUERY_CPU_DATA, "SELECT Data from Cpu_Data WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ");
            this.createStatement(CpuStatements.QUERY_TRACE_INFO, "SELECT TraceInfo from Cpu_Trace_Info WHERE Session = ? AND ((StartTime < ? AND ? <= EndTime) OR (StartTime > ? AND EndTime = 0));");
            this.createStatement(CpuStatements.FIND_TRACE_DATA, "SELECT Data, ProfilerType from Cpu_Trace WHERE Session = ? AND TraceId = ?");
            this.createStatement(CpuStatements.INSERT_TRACE_DATA, "INSERT INTO Cpu_Trace (Session, TraceId, ProfilerType, Data) values (?, ?, ?, ?)");
            this.createStatement(CpuStatements.INSERT_TRACE_INFO, "INSERT OR REPLACE INTO Cpu_Trace_Info (Session, StartTime, EndTime, TraceInfo) values (?, ?, ?, ?)");
            this.createStatement(CpuStatements.INSERT_THREAD_ACTIVITY, "INSERT OR REPLACE INTO Thread_Activities (Session, ThreadId, Timestamp, State, Name) VALUES (?, ?, ?, ?, ?)");
            this.createStatement(CpuStatements.QUERY_THREAD_ACTIVITIES, "SELECT t1.ThreadId, t1.Name, t1.State, ? as ReqStart FROM Thread_Activities AS t1 JOIN (SELECT ThreadId, MAX(Timestamp) AS Timestamp FROM Thread_Activities WHERE Session = ? AND Timestamp <= ? GROUP BY ThreadId) AS t2 ON t1.ThreadId = t2.ThreadId AND t1.Timestamp = t2.Timestamp AND t1.State <> 'DEAD' UNION ALL SELECT ThreadId, Name, State, Timestamp FROM Thread_Activities WHERE Session = ? AND Timestamp > ? AND Timestamp <= ?;");
            this.createStatement(CpuStatements.INSERT_PROFILING_STATE, "INSERT OR REPLACE INTO Profiling_State (Session, Timestamp, Data) values (?, ?, ?)");
            this.createStatement(CpuStatements.QUERY_PROFILING_STATE, "SELECT Data from Profiling_State WHERE Session = ? ORDER BY Timestamp DESC LIMIT 1 ");
        }
        catch (SQLException ex) {
            CpuTable.onError(ex);
        }
    }

    public void insert(Common.Session session, CpuProfiler.CpuUsageData data) {
        this.execute(CpuStatements.INSERT_CPU_DATA, session.getSessionId(), data.getEndTimestamp(), data.toByteArray());
    }

    public List<CpuProfiler.CpuUsageData> getCpuDataByRequest(CpuProfiler.CpuDataRequest request) {
        ArrayList<CpuProfiler.CpuUsageData> cpuData = new ArrayList<CpuProfiler.CpuUsageData>();
        try {
            ResultSet results = this.executeQuery(CpuStatements.QUERY_CPU_DATA, request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            while (results.next()) {
                CpuProfiler.CpuUsageData.Builder data = CpuProfiler.CpuUsageData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                cpuData.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            CpuTable.onError(ex);
        }
        return cpuData;
    }

    public void insertActivities(Common.Session session, int tid, String name, List<CpuProfiler.GetThreadsResponse.ThreadActivity> activities) {
        for (CpuProfiler.GetThreadsResponse.ThreadActivity activity : activities) {
            this.execute(CpuStatements.INSERT_THREAD_ACTIVITY, session.getSessionId(), tid, activity.getTimestamp(), activity.getNewState().toString(), name);
        }
    }

    public void insertSnapshot(Common.Session session, long timestamp, List<CpuProfiler.GetThreadsResponse.ThreadSnapshot.Snapshot> snapshots) {
        for (CpuProfiler.GetThreadsResponse.ThreadSnapshot.Snapshot snapshot : snapshots) {
            this.execute(CpuStatements.INSERT_THREAD_ACTIVITY, session.getSessionId(), snapshot.getTid(), timestamp, snapshot.getState().toString(), snapshot.getName());
        }
    }

    public List<CpuProfiler.GetThreadsResponse.Thread> getThreadsDataByRequest(CpuProfiler.GetThreadsRequest request) {
        TreeMap<Integer, CpuProfiler.GetThreadsResponse.Thread.Builder> threads = new TreeMap<Integer, CpuProfiler.GetThreadsResponse.Thread.Builder>();
        try {
            ResultSet activities = this.executeQuery(CpuStatements.QUERY_THREAD_ACTIVITIES, request.getStartTimestamp(), request.getSession().getSessionId(), request.getStartTimestamp(), request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            while (activities.next()) {
                int tid = activities.getInt(1);
                if (!threads.containsKey(tid)) {
                    CpuProfiler.GetThreadsResponse.Thread.Builder thread2 = CpuTable.createThreadBuilder(tid, activities.getString(2));
                    threads.put(tid, thread2);
                }
                CpuProfiler.GetThreadsResponse.State state = CpuProfiler.GetThreadsResponse.State.valueOf((String)activities.getString(3));
                CpuProfiler.GetThreadsResponse.ThreadActivity.Builder activity = CpuProfiler.GetThreadsResponse.ThreadActivity.newBuilder().setNewState(state).setTimestamp(activities.getLong(4));
                ((CpuProfiler.GetThreadsResponse.Thread.Builder)threads.get(tid)).addActivities(activity.build());
            }
        }
        catch (SQLException ex) {
            CpuTable.onError(ex);
        }
        ArrayList<CpuProfiler.GetThreadsResponse.Thread> cpuData = new ArrayList<CpuProfiler.GetThreadsResponse.Thread>();
        for (CpuProfiler.GetThreadsResponse.Thread.Builder thread2 : threads.values()) {
            cpuData.add(thread2.build());
        }
        return cpuData;
    }

    public List<CpuProfiler.TraceInfo> getTraceInfo(CpuProfiler.GetTraceInfoRequest request) {
        ArrayList<CpuProfiler.TraceInfo> traceInfo = new ArrayList<CpuProfiler.TraceInfo>();
        try {
            ResultSet results = this.executeQuery(CpuStatements.QUERY_TRACE_INFO, request.getSession().getSessionId(), request.getToTimestamp(), request.getFromTimestamp(), request.getFromTimestamp());
            while (results.next()) {
                byte[] data = results.getBytes(1);
                if (data == null) continue;
                traceInfo.add(CpuProfiler.TraceInfo.parseFrom((byte[])data));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            CpuTable.onError(ex);
        }
        return traceInfo;
    }

    public TraceData getTraceData(Common.Session session, int traceId) {
        try {
            byte[] data;
            ResultSet results = this.executeQuery(CpuStatements.FIND_TRACE_DATA, session.getSessionId(), traceId);
            if (results.next() && (data = results.getBytes(1)) != null) {
                CpuProfiler.CpuProfilerType profilerType = CpuProfiler.CpuProfilerType.valueOf((String)results.getString(2));
                return new TraceData(ByteString.copyFrom((byte[])data), profilerType);
            }
        }
        catch (SQLException ex) {
            CpuTable.onError(ex);
        }
        return null;
    }

    public void insertTrace(Common.Session session, int traceId, CpuProfiler.CpuProfilerType profilerType, ByteString data) {
        this.execute(CpuStatements.INSERT_TRACE_DATA, session.getSessionId(), traceId, profilerType.toString(), data.toByteArray());
    }

    public void insertTraceInfo(Common.Session session, CpuProfiler.TraceInfo trace) {
        this.execute(CpuStatements.INSERT_TRACE_INFO, session.getSessionId(), trace.getFromTimestamp(), trace.getToTimestamp(), trace.toByteArray());
    }

    public void insertProfilingStateData(Common.Session session, CpuProfiler.ProfilingStateResponse data) {
        this.execute(CpuStatements.INSERT_PROFILING_STATE, session.getSessionId(), data.getCheckTimestamp(), data.toByteArray());
    }

    public CpuProfiler.ProfilingStateResponse getProfilingStateData(Common.Session session) {
        try {
            ResultSet results = this.executeQuery(CpuStatements.QUERY_PROFILING_STATE, session.getSessionId());
            if (results.next()) {
                return CpuProfiler.ProfilingStateResponse.parseFrom((byte[])results.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            CpuTable.onError(ex);
        }
        return null;
    }

    private static CpuProfiler.GetThreadsResponse.Thread.Builder createThreadBuilder(int tid, String name) {
        CpuProfiler.GetThreadsResponse.Thread.Builder thread2 = CpuProfiler.GetThreadsResponse.Thread.newBuilder();
        thread2.setTid(tid);
        thread2.setName(name);
        return thread2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/datastore/database/CpuTable", "initialize"));
    }

    public static class TraceData {
        private final ByteString myTraceBytes;
        private final CpuProfiler.CpuProfilerType myProfilerType;

        public TraceData(ByteString traceBytes, CpuProfiler.CpuProfilerType profilerType) {
            this.myTraceBytes = traceBytes;
            this.myProfilerType = profilerType;
        }

        public ByteString getTraceBytes() {
            return this.myTraceBytes;
        }

        public CpuProfiler.CpuProfilerType getProfilerType() {
            return this.myProfilerType;
        }
    }

    public static enum CpuStatements {
        INSERT_THREAD_ACTIVITY,
        QUERY_THREAD_ACTIVITIES,
        INSERT_CPU_DATA,
        QUERY_CPU_DATA,
        QUERY_TRACE_INFO,
        FIND_TRACE_DATA,
        INSERT_TRACE_DATA,
        INSERT_TRACE_INFO,
        INSERT_PROFILING_STATE,
        QUERY_PROFILING_STATE;

    }
}

