/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import gnu.trove.TLongHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class MemoryLiveAllocationTable
extends DataStoreTable<MemoryStatements> {
    @NotNull
    private final LogService myLogService;
    private int myAllocationCountLimit;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    @NotNull
    private LogService.Logger getLogger() {
        LogService.Logger logger = this.myLogService.getLogger(MemoryLiveAllocationTable.class);
        if (logger == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public MemoryLiveAllocationTable(@NotNull LogService logService) {
        if (logService == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(1);
        }
        this.myAllocationCountLimit = 5000000;
        this.myLogService = logService;
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(2);
        }
        super.initialize(connection);
        try {
            this.createTable("Memory_AllocatedClass", "Session INTEGER NOT NULL", "Tag INTEGER", "AllocTime INTEGER", "Name TEXT", "PRIMARY KEY(Session, Tag)");
            this.createTable("Memory_AllocationEvents", "Session INTEGER NOT NULL", "Tag INTEGER", "ClassTag INTEGER", "AllocTime INTEGER", "FreeTime INTEGER", "Size INTEGER", "Length INTEGER", "ThreadId INTEGER", "StackId INTEGER", "HeapId INTEGER", "PRIMARY KEY(Session, Tag)");
            this.createTable("Memory_MethodInfos", "Session INTEGER NOT NULL", "MethodId INTEGER", "MethodName TEXT", "ClassName TEXT", "PRIMARY KEY(Session, MethodId)");
            this.createTable("Memory_StackInfos", "Session INTEGER NOT NULL", "StackId INTEGER", "AllocTime INTEGER", "StackData BLOB", "PRIMARY KEY(Session, StackId)");
            this.createTable("Memory_ThreadInfos", "Session INTEGER NOT NULL", "ThreadId INTEGER", "AllocTime INTEGER", "ThreadName TEXT", "PRIMARY KEY(Session, ThreadId)");
            this.createTable("Memory_NativeFrames", "Session INTEGER NOT NULL", "Address INTEGER NOT NULL", "Symbolized INTEGER NOT NULL", "Offset INTEGER", "Module TEXT", "NativeFrame BLOB", "PRIMARY KEY(Session, Address)");
            this.createTable("Memory_JniGlobalReferences", "Session INTEGER NOT NULL", "Tag INTEGER", "RefValue INTEGER", "AllocTime INTEGER", "FreeTime INTEGER", "AllocThreadId INTEGER", "FreeThreadId INTEGER", "AllocBacktrace BLOB", "FreeBacktrace BLOB", "PRIMARY KEY(Session, Tag, RefValue)");
            this.createIndex("Memory_AllocationEvents", 0, "Session", "AllocTime");
            this.createIndex("Memory_AllocationEvents", 1, "Session", "FreeTime");
            this.createIndex("Memory_AllocatedClass", 0, "Session", "AllocTime");
            this.createIndex("Memory_StackInfos", 0, "Session", "AllocTime");
            this.createIndex("Memory_ThreadInfos", 0, "Session", "AllocTime");
            this.createIndex("Memory_NativeFrames", 0, "Session", "Address");
            this.createIndex("Memory_NativeFrames", 1, "Session", "Symbolized");
            this.createIndex("Memory_JniGlobalReferences", 0, "Session", "AllocTime");
            this.createIndex("Memory_JniGlobalReferences", 1, "Session", "FreeTime");
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    void setAllocationCountLimit(int allocationCountLimit) {
        this.myAllocationCountLimit = allocationCountLimit;
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    public MemoryProfiler.BatchAllocationSample getSnapshot(Common.Session session, long endTime) {
        MemoryProfiler.BatchAllocationSample.Builder sampleBuilder = MemoryProfiler.BatchAllocationSample.newBuilder();
        try {
            ResultSet allocResult = this.executeQuery(MemoryStatements.QUERY_SNAPSHOT, session.getSessionId(), endTime, endTime);
            long timestamp = Long.MIN_VALUE;
            while (allocResult.next()) {
                long allocTime = allocResult.getLong(3);
                MemoryProfiler.AllocationEvent event = MemoryProfiler.AllocationEvent.newBuilder().setAllocData(MemoryProfiler.AllocationEvent.Allocation.newBuilder().setTag(allocResult.getInt(1)).setClassTag(allocResult.getInt(2)).setSize(allocResult.getLong(4)).setLength(allocResult.getInt(5)).setThreadId(allocResult.getInt(6)).setStackId(allocResult.getInt(7)).setHeapId(allocResult.getInt(8)).build()).setTimestamp(allocTime).build();
                sampleBuilder.addEvents(event);
                timestamp = Math.max(timestamp, allocTime);
            }
            sampleBuilder.setTimestamp(timestamp);
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return sampleBuilder.build();
    }

    public MemoryProfiler.BatchAllocationSample getAllocations(Common.Session session, long startTime, long endTime) {
        MemoryProfiler.BatchAllocationSample.Builder sampleBuilder = MemoryProfiler.BatchAllocationSample.newBuilder();
        try {
            ResultSet allocResult = this.executeQuery(MemoryStatements.QUERY_ALLOC_BY_ALLOC_TIME, session.getSessionId(), startTime, endTime);
            long timestamp = Long.MIN_VALUE;
            while (allocResult.next()) {
                long allocTime = allocResult.getLong(3);
                MemoryProfiler.AllocationEvent event = MemoryProfiler.AllocationEvent.newBuilder().setAllocData(MemoryProfiler.AllocationEvent.Allocation.newBuilder().setTag(allocResult.getInt(1)).setClassTag(allocResult.getInt(2)).setSize(allocResult.getLong(5)).setLength(allocResult.getInt(6)).setThreadId(allocResult.getInt(7)).setStackId(allocResult.getInt(8)).setHeapId(allocResult.getInt(9)).build()).setTimestamp(allocTime).build();
                sampleBuilder.addEvents(event);
                timestamp = Math.max(timestamp, allocTime);
            }
            ResultSet freeResult = this.executeQuery(MemoryStatements.QUERY_ALLOC_BY_FREE_TIME, session.getSessionId(), startTime, endTime);
            while (freeResult.next()) {
                long freeTime = freeResult.getLong(4);
                MemoryProfiler.AllocationEvent event = MemoryProfiler.AllocationEvent.newBuilder().setFreeData(MemoryProfiler.AllocationEvent.Deallocation.newBuilder().setTag(freeResult.getInt(1)).setClassTag(freeResult.getInt(2)).setSize(freeResult.getLong(5)).setLength(freeResult.getInt(6)).setThreadId(freeResult.getInt(7)).setStackId(freeResult.getInt(8)).setHeapId(freeResult.getInt(9)).build()).setTimestamp(freeTime).build();
                sampleBuilder.addEvents(event);
                timestamp = Math.max(timestamp, freeTime);
            }
            sampleBuilder.setTimestamp(timestamp);
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return sampleBuilder.build();
    }

    @NotNull
    public MemoryProfiler.LatestAllocationTimeResponse getLatestDataTimestamp(Common.Session session) {
        MemoryProfiler.LatestAllocationTimeResponse.Builder builder = MemoryProfiler.LatestAllocationTimeResponse.newBuilder();
        try {
            long latest = 0L;
            ResultSet result = this.executeQuery(MemoryStatements.QUERY_LATEST_ALLOC_TIME, session.getSessionId());
            if (result.next()) {
                latest = Math.max(latest, result.getLong(1));
            }
            if ((result = this.executeQuery(MemoryStatements.QUERY_LATEST_FREE_TIME, session.getSessionId(), Long.MAX_VALUE)).next()) {
                latest = Math.max(latest, result.getLong(1));
            }
            builder.setTimestamp(latest);
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        MemoryProfiler.LatestAllocationTimeResponse latestAllocationTimeResponse = builder.build();
        if (latestAllocationTimeResponse == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(3);
        }
        return latestAllocationTimeResponse;
    }

    @NotNull
    public MemoryProfiler.AllocationContextsResponse getAllocationContexts(Common.Session session, long startTime, long endTime) {
        MemoryProfiler.AllocationContextsResponse.Builder resultBuilder = MemoryProfiler.AllocationContextsResponse.newBuilder();
        try {
            ResultSet klassResult = this.executeQuery(MemoryStatements.QUERY_CLASS, session.getSessionId(), startTime, endTime);
            long timestamp = Long.MIN_VALUE;
            while (klassResult.next()) {
                long allocTime = klassResult.getLong(2);
                MemoryProfiler.AllocatedClass klass = MemoryProfiler.AllocatedClass.newBuilder().setClassId(klassResult.getInt(1)).setClassName(klassResult.getString(3)).build();
                resultBuilder.addAllocatedClasses(klass);
                timestamp = Math.max(timestamp, allocTime);
            }
            ResultSet stackResult = this.executeQuery(MemoryStatements.QUERY_ENCODED_STACK_INFO_BY_TIME, session.getSessionId(), startTime, endTime);
            while (stackResult.next()) {
                MemoryProfiler.AllocationStack.Builder stackBuilder = MemoryProfiler.AllocationStack.newBuilder();
                MemoryProfiler.EncodedAllocationStack encodedStack = MemoryProfiler.EncodedAllocationStack.parseFrom((byte[])stackResult.getBytes(1));
                stackBuilder.setStackId(encodedStack.getStackId());
                MemoryProfiler.AllocationStack.SmallFrameWrapper.Builder frameBuilder = MemoryProfiler.AllocationStack.SmallFrameWrapper.newBuilder();
                assert (encodedStack.getMethodIdsCount() == encodedStack.getLineNumbersCount());
                for (int i = 0; i < encodedStack.getMethodIdsCount(); ++i) {
                    MemoryProfiler.AllocationStack.SmallFrame frame = MemoryProfiler.AllocationStack.SmallFrame.newBuilder().setMethodId(encodedStack.getMethodIds(i)).setLineNumber(encodedStack.getLineNumbers(i)).build();
                    frameBuilder.addFrames(frame);
                }
                stackBuilder.setSmallStack(frameBuilder);
                resultBuilder.addAllocationStacks(stackBuilder);
            }
            ResultSet threadResult = this.executeQuery(MemoryStatements.QUERY_THREAD_INFO_BY_TIME, session.getSessionId(), startTime, endTime);
            while (threadResult.next()) {
                MemoryProfiler.ThreadInfo thread2 = MemoryProfiler.ThreadInfo.newBuilder().setThreadId(threadResult.getInt(1)).setThreadName(threadResult.getString(2)).build();
                resultBuilder.addAllocationThreads(thread2);
            }
            resultBuilder.setTimestamp(timestamp);
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        MemoryProfiler.AllocationContextsResponse allocationContextsResponse = resultBuilder.build();
        if (allocationContextsResponse == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(4);
        }
        return allocationContextsResponse;
    }

    private MemoryProfiler.JNIGlobalReferenceEvent readJniEventFromResultSet(ResultSet resultset, MemoryProfiler.JNIGlobalReferenceEvent.Type type) throws SQLException {
        int objectTag = resultset.getInt("Tag");
        long refValue = resultset.getLong("RefValue");
        long timestamp = resultset.getLong("Timestamp");
        int threadId = resultset.getInt("ThreadId");
        byte[] backtrace = resultset.getBytes("Backtrace");
        MemoryProfiler.JNIGlobalReferenceEvent.Builder event = MemoryProfiler.JNIGlobalReferenceEvent.newBuilder();
        event.setEventType(type);
        event.setObjectTag(objectTag);
        event.setRefValue(refValue);
        event.setTimestamp(timestamp);
        event.setThreadId(threadId);
        if (backtrace != null && backtrace.length != 0) {
            try {
                event.setBacktrace(MemoryProfiler.NativeBacktrace.parseFrom((byte[])backtrace));
            }
            catch (InvalidProtocolBufferException ex) {
                MemoryLiveAllocationTable.onError(ex);
            }
        }
        return event.build();
    }

    public MemoryProfiler.NativeCallStack resolveNativeBacktrace(@NotNull Common.Session session, @NotNull MemoryProfiler.NativeBacktrace backtrace) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(5);
        }
        if (backtrace == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(6);
        }
        MemoryProfiler.NativeCallStack.Builder resultBuilder = MemoryProfiler.NativeCallStack.newBuilder();
        try {
            for (Long address : backtrace.getAddressesList()) {
                byte[] frameBytes;
                MemoryProfiler.NativeCallStack.NativeFrame frame = MemoryProfiler.NativeCallStack.NativeFrame.getDefaultInstance();
                ResultSet result = this.executeQuery(MemoryStatements.QUERY_NATIVE_FRAME, session.getSessionId(), address);
                if (result.next() && (frameBytes = result.getBytes(1)) != null && frameBytes.length != 0) {
                    frame = MemoryProfiler.NativeCallStack.NativeFrame.parseFrom((byte[])frameBytes);
                }
                resultBuilder.addFrames(frame);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            this.getLogger().error(ex);
        }
        return resultBuilder.build();
    }

    public MemoryProfiler.BatchJNIGlobalRefEvent getJniReferencesSnapshot(Common.Session session, long endTime) {
        MemoryProfiler.BatchJNIGlobalRefEvent.Builder resultBuilder = MemoryProfiler.BatchJNIGlobalRefEvent.newBuilder();
        long timestamp = 0L;
        try {
            ResultSet allocResultset = this.executeQuery(MemoryStatements.QUERY_JNI_REF_CREATE_EVENTS, session.getSessionId(), 0, endTime, endTime, Long.MAX_VALUE);
            while (allocResultset.next()) {
                MemoryProfiler.JNIGlobalReferenceEvent event = this.readJniEventFromResultSet(allocResultset, MemoryProfiler.JNIGlobalReferenceEvent.Type.CREATE_GLOBAL_REF);
                timestamp = Math.max(timestamp, event.getTimestamp());
                resultBuilder.addEvents(event);
            }
            resultBuilder.setTimestamp(timestamp);
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return resultBuilder.build();
    }

    public MemoryProfiler.BatchJNIGlobalRefEvent getJniReferencesEventsFromRange(Common.Session session, long startTime, long endTime) {
        MemoryProfiler.BatchJNIGlobalRefEvent.Builder resultBuilder = MemoryProfiler.BatchJNIGlobalRefEvent.newBuilder();
        long timestamp = 0L;
        try {
            ResultSet allocResultset = this.executeQuery(MemoryStatements.QUERY_JNI_REF_CREATE_EVENTS, session.getSessionId(), startTime, endTime - 1L, startTime, Long.MAX_VALUE);
            while (allocResultset.next()) {
                MemoryProfiler.JNIGlobalReferenceEvent event = this.readJniEventFromResultSet(allocResultset, MemoryProfiler.JNIGlobalReferenceEvent.Type.CREATE_GLOBAL_REF);
                timestamp = Math.max(timestamp, event.getTimestamp());
                resultBuilder.addEvents(event);
            }
            ResultSet freeResultset = this.executeQuery(MemoryStatements.QUERY_JNI_REF_DELETE_EVENTS, session.getSessionId(), 0, endTime - 1L, startTime, endTime - 1L);
            while (freeResultset.next()) {
                MemoryProfiler.JNIGlobalReferenceEvent event = this.readJniEventFromResultSet(freeResultset, MemoryProfiler.JNIGlobalReferenceEvent.Type.DELETE_GLOBAL_REF);
                timestamp = Math.max(timestamp, event.getTimestamp());
                resultBuilder.addEvents(event);
            }
            resultBuilder.setTimestamp(timestamp);
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return resultBuilder.build();
    }

    private static TreeMap<Long, MemoryProfiler.MemoryMap.MemoryRegion> buildAddressMap(MemoryProfiler.MemoryMap map) {
        TreeMap<Long, MemoryProfiler.MemoryMap.MemoryRegion> result = new TreeMap<Long, MemoryProfiler.MemoryMap.MemoryRegion>();
        if (map == null) {
            return result;
        }
        for (MemoryProfiler.MemoryMap.MemoryRegion region : map.getRegionsList()) {
            result.put(region.getStartAddress(), region);
        }
        return result;
    }

    public static MemoryProfiler.MemoryMap.MemoryRegion getRegionByAddress(TreeMap<Long, MemoryProfiler.MemoryMap.MemoryRegion> addressMap, Long address) {
        Map.Entry<Long, MemoryProfiler.MemoryMap.MemoryRegion> entry = addressMap.floorEntry(address);
        if (entry == null) {
            return null;
        }
        MemoryProfiler.MemoryMap.MemoryRegion region = entry.getValue();
        if (address >= region.getStartAddress() && address < region.getEndAddress()) {
            return region;
        }
        return null;
    }

    public void insertJniReferenceData(@NotNull Common.Session session, @NotNull MemoryProfiler.BatchJNIGlobalRefEvent batch) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(7);
        }
        if (batch == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(8);
        }
        Statement insertRefStatement = null;
        Statement updateRefStatement = null;
        Statement insertFrameStatement = null;
        try {
            TreeMap<Long, MemoryProfiler.MemoryMap.MemoryRegion> addressMap = MemoryLiveAllocationTable.buildAddressMap(batch.getMemoryMap());
            TLongHashSet insertedAddresses = new TLongHashSet();
            block6: for (MemoryProfiler.JNIGlobalReferenceEvent event : batch.getEventsList()) {
                long refValue = event.getRefValue();
                int objectTag = event.getObjectTag();
                long timestamp = event.getTimestamp();
                int threadId = event.getThreadId();
                byte[] backtrace = EMPTY_BYTE_ARRAY;
                if (event.hasBacktrace()) {
                    backtrace = event.getBacktrace().toByteArray();
                    for (Long address : event.getBacktrace().getAddressesList()) {
                        if (insertedAddresses.contains(address.longValue())) continue;
                        String module = "";
                        long offset = 0L;
                        MemoryProfiler.MemoryMap.MemoryRegion region = MemoryLiveAllocationTable.getRegionByAddress(addressMap, address);
                        if (region != null) {
                            module = region.getName();
                            offset = address + region.getFileOffset() - region.getStartAddress();
                        }
                        if (insertFrameStatement == null) {
                            insertFrameStatement = this.getStatementMap().get((Object)MemoryStatements.INSERT_NATIVE_FRAME);
                        }
                        this.applyParams((PreparedStatement)insertFrameStatement, session.getSessionId(), address, offset, module);
                        insertFrameStatement.addBatch();
                        insertedAddresses.add(address.longValue());
                    }
                }
                switch (event.getEventType()) {
                    case CREATE_GLOBAL_REF: {
                        if (insertRefStatement == null) {
                            insertRefStatement = this.getStatementMap().get((Object)MemoryStatements.INSERT_JNI_REF);
                        }
                        this.applyParams((PreparedStatement)insertRefStatement, session.getSessionId(), objectTag, refValue, timestamp, threadId, backtrace);
                        insertRefStatement.addBatch();
                        continue block6;
                    }
                    case DELETE_GLOBAL_REF: {
                        if (updateRefStatement == null) {
                            updateRefStatement = this.getStatementMap().get((Object)MemoryStatements.UPDATE_JNI_REF);
                        }
                        this.applyParams((PreparedStatement)updateRefStatement, timestamp, backtrace, threadId, session.getSessionId(), objectTag, refValue);
                        updateRefStatement.addBatch();
                        continue block6;
                    }
                }
                assert (false);
            }
            if (insertFrameStatement != null) {
                insertFrameStatement.executeBatch();
            }
            if (insertRefStatement != null) {
                insertRefStatement.executeBatch();
            }
            if (updateRefStatement != null) {
                updateRefStatement.executeBatch();
            }
            if (batch.getEventsCount() > 0) {
                this.pruneJniRefRecords(session);
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    @NotNull
    public List<MemoryProfiler.NativeCallStack.NativeFrame> queryNotsymbolizedNativeFrames(@NotNull Common.Session session, int maxCount) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(9);
        }
        ArrayList<MemoryProfiler.NativeCallStack.NativeFrame> records = new ArrayList<MemoryProfiler.NativeCallStack.NativeFrame>();
        try {
            ResultSet result = this.executeQuery(MemoryStatements.QUERY_NATIVE_FRAMES_TO_SYMBOLIZE, session.getSessionId(), maxCount);
            while (result.next()) {
                MemoryProfiler.NativeCallStack.NativeFrame frame = MemoryProfiler.NativeCallStack.NativeFrame.newBuilder().setModuleName(result.getString("Module")).setModuleOffset(result.getLong("Offset")).setAddress(result.getLong("Address")).build();
                records.add(frame);
            }
        }
        catch (SQLException ex) {
            this.getLogger().error(ex);
        }
        ArrayList<MemoryProfiler.NativeCallStack.NativeFrame> arrayList = records;
        if (arrayList == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public void updateSymbolizedNativeFrames(@NotNull Common.Session session, @NotNull List<MemoryProfiler.NativeCallStack.NativeFrame> frames) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(11);
        }
        if (frames == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(12);
        }
        if (frames.isEmpty()) {
            return;
        }
        try {
            PreparedStatement updateFramesStatement = this.getStatementMap().get((Object)MemoryStatements.UPDATE_NATIVE_FRAME);
            for (MemoryProfiler.NativeCallStack.NativeFrame frame : frames) {
                this.applyParams(updateFramesStatement, frame.toByteArray(), session.getSessionId(), frame.getAddress());
                updateFramesStatement.addBatch();
            }
            updateFramesStatement.executeBatch();
        }
        catch (SQLException ex) {
            this.getLogger().error(ex);
        }
    }

    public void insertAllocationData(Common.Session session, MemoryProfiler.BatchAllocationSample sample) {
        MemoryProfiler.AllocationEvent.EventCase currentCase = null;
        Statement currentStatement = null;
        int allocAndFreeCount = 0;
        try {
            for (MemoryProfiler.AllocationEvent event : sample.getEventsList()) {
                if (currentCase != event.getEventCase()) {
                    if (currentCase != null) {
                        currentStatement.executeBatch();
                    }
                    currentCase = event.getEventCase();
                    switch (currentCase) {
                        case CLASS_DATA: {
                            currentStatement = this.getStatementMap().get((Object)MemoryStatements.INSERT_CLASS);
                            break;
                        }
                        case ALLOC_DATA: {
                            currentStatement = this.getStatementMap().get((Object)MemoryStatements.INSERT_ALLOC);
                            break;
                        }
                        case FREE_DATA: {
                            currentStatement = this.getStatementMap().get((Object)MemoryStatements.UPDATE_ALLOC);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                }
                switch (currentCase) {
                    case CLASS_DATA: {
                        assert (currentStatement != null);
                        MemoryProfiler.AllocatedClass klass = event.getClassData();
                        this.applyParams((PreparedStatement)currentStatement, session.getSessionId(), klass.getClassId(), event.getTimestamp(), MemoryLiveAllocationTable.jniToJavaName(klass.getClassName()));
                        break;
                    }
                    case ALLOC_DATA: {
                        assert (currentStatement != null);
                        ++allocAndFreeCount;
                        MemoryProfiler.AllocationEvent.Allocation allocation = event.getAllocData();
                        this.applyParams((PreparedStatement)currentStatement, session.getSessionId(), allocation.getTag(), allocation.getClassTag(), event.getTimestamp(), Long.MAX_VALUE, allocation.getSize(), allocation.getLength(), allocation.getThreadId(), allocation.getStackId(), allocation.getHeapId());
                        break;
                    }
                    case FREE_DATA: {
                        assert (currentStatement != null);
                        ++allocAndFreeCount;
                        MemoryProfiler.AllocationEvent.Deallocation free = event.getFreeData();
                        this.applyParams((PreparedStatement)currentStatement, event.getTimestamp(), session.getSessionId(), free.getTag());
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                currentStatement.addBatch();
            }
            currentStatement.executeBatch();
            if (allocAndFreeCount > 0) {
                this.pruneAllocations(session);
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    public void insertMethodInfo(Common.Session session, List<MemoryProfiler.AllocationStack.StackFrame> methods) {
        try {
            PreparedStatement statement = this.getStatementMap().get((Object)MemoryStatements.INSERT_METHOD);
            assert (statement != null);
            for (MemoryProfiler.AllocationStack.StackFrame method : methods) {
                this.applyParams(statement, session.getSessionId(), method.getMethodId(), method.getMethodName(), MemoryLiveAllocationTable.jniToJavaName(method.getClassName()));
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    @NotNull
    public MemoryProfiler.StackFrameInfoResponse getStackFrameInfo(Common.Session session, long methodId) {
        MemoryProfiler.StackFrameInfoResponse.Builder methodBuilder = MemoryProfiler.StackFrameInfoResponse.newBuilder();
        try {
            ResultSet result = this.executeQuery(MemoryStatements.QUERY_METHOD_INFO, session.getSessionId(), methodId);
            if (result.next()) {
                methodBuilder.setMethodName(result.getString(1)).setClassName(result.getString(2));
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        MemoryProfiler.StackFrameInfoResponse stackFrameInfoResponse = methodBuilder.build();
        if (stackFrameInfoResponse == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(13);
        }
        return stackFrameInfoResponse;
    }

    public void insertStackInfo(Common.Session session, List<MemoryProfiler.EncodedAllocationStack> stacks) {
        try {
            PreparedStatement statement = this.getStatementMap().get((Object)MemoryStatements.INSERT_ENCODED_STACK);
            assert (statement != null);
            for (MemoryProfiler.EncodedAllocationStack stack : stacks) {
                this.applyParams(statement, session.getSessionId(), stack.getStackId(), stack.getTimestamp(), stack.toByteArray());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    public void insertThreadInfo(Common.Session session, List<MemoryProfiler.ThreadInfo> threads) {
        try {
            PreparedStatement statement = this.getStatementMap().get((Object)MemoryStatements.INSERT_THREAD_INFO);
            assert (statement != null);
            for (MemoryProfiler.ThreadInfo thread2 : threads) {
                this.applyParams(statement, session.getSessionId(), thread2.getThreadId(), thread2.getTimestamp(), thread2.getThreadName());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    private void pruneAllocations(@NotNull Common.Session session) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(14);
        }
        try {
            ResultSet result = this.executeQuery(MemoryStatements.COUNT_ALLOC, new Object[0]);
            result.next();
            int rowCount = result.getInt(1);
            if (rowCount > this.myAllocationCountLimit) {
                int pruneCount = rowCount - this.myAllocationCountLimit;
                this.execute(MemoryStatements.PRUNE_ALLOC, session.getSessionId(), session.getSessionId(), pruneCount);
                this.getLogger().info(String.format("Allocations have exceed %d entries. Attempting to prune %d.", this.myAllocationCountLimit, pruneCount));
            }
        }
        catch (SQLException e) {
            MemoryLiveAllocationTable.onError(e);
        }
    }

    private void pruneJniRefRecords(@NotNull Common.Session session) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(15);
        }
        try {
            ResultSet result = this.executeQuery(MemoryStatements.COUNT_JNI_REF_RECORDS, new Object[0]);
            result.next();
            int rowCount = result.getInt(1);
            if (rowCount > this.myAllocationCountLimit) {
                int pruneCount = rowCount - this.myAllocationCountLimit;
                this.execute(MemoryStatements.PRUNE_JNI_REF_RECORDS, session.getSessionId(), session.getSessionId(), pruneCount);
                this.getLogger().info(String.format("JNI ref records have exceed %d entries. Attempting to prune %d.", this.myAllocationCountLimit, pruneCount));
            }
        }
        catch (SQLException e) {
            MemoryLiveAllocationTable.onError(e);
        }
    }

    private static String jniToJavaName(String jniName) {
        String javaName;
        int arrayDimension = 0;
        int classNameIndex = 0;
        while (jniName.charAt(classNameIndex) == '[') {
            ++arrayDimension;
            ++classNameIndex;
        }
        if (jniName.charAt(classNameIndex) == 'L') {
            javaName = jniName.substring(classNameIndex + 1, jniName.length() - 1).replace('/', '.');
        } else {
            switch (javaName = jniName.substring(classNameIndex, jniName.length())) {
                case "Z": {
                    javaName = "boolean";
                    break;
                }
                case "B": {
                    javaName = "byte";
                    break;
                }
                case "C": {
                    javaName = "char";
                    break;
                }
                case "S": {
                    javaName = "short";
                    break;
                }
                case "I": {
                    javaName = "int";
                    break;
                }
                case "J": {
                    javaName = "long";
                    break;
                }
                case "F": {
                    javaName = "float";
                    break;
                }
                case "D": {
                    javaName = "double";
                    break;
                }
            }
        }
        while (arrayDimension > 0) {
            javaName = javaName + "[]";
            --arrayDimension;
        }
        return javaName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/MemoryLiveAllocationTable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backtrace";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/MemoryLiveAllocationTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDataTimestamp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationContexts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "queryNotsymbolizedNativeFrames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFrameInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveNativeBacktrace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertJniReferenceData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "queryNotsymbolizedNativeFrames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateSymbolizedNativeFrames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "pruneAllocations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "pruneJniRefRecords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MemoryStatements {
        INSERT_CLASS("INSERT OR IGNORE INTO Memory_AllocatedClass (Session, Tag, AllocTime, Name) VALUES (?, ?, ?, ?)"),
        INSERT_ALLOC("INSERT OR IGNORE INTO Memory_AllocationEvents (Session, Tag, ClassTag, AllocTime, FreeTime, Size, Length, ThreadId, StackId, HeapId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        INSERT_METHOD("INSERT OR IGNORE INTO Memory_MethodInfos (Session, MethodId, MethodName, ClassName) VALUES (?, ?, ?, ?)"),
        INSERT_ENCODED_STACK("INSERT OR IGNORE INTO Memory_StackInfos (Session, StackId, AllocTime, StackData) VALUES (?, ?, ?, ?)"),
        INSERT_THREAD_INFO("INSERT OR IGNORE INTO Memory_ThreadInfos (Session, ThreadId, AllocTime, ThreadName) VALUES (?, ?, ?, ?)"),
        UPDATE_ALLOC("UPDATE Memory_AllocationEvents SET FreeTime = ? WHERE Session = ? AND Tag = ?"),
        QUERY_CLASS("SELECT Tag, AllocTime, Name FROM Memory_AllocatedClass where Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        QUERY_LATEST_ALLOC_TIME("SELECT MAX(AllocTime) FROM Memory_AllocationEvents WHERE Session = ?"),
        QUERY_LATEST_FREE_TIME("SELECT MAX(FreeTime) FROM Memory_AllocationEvents WHERE Session = ? AND FreeTime < ?"),
        QUERY_SNAPSHOT("SELECT Tag, ClassTag, AllocTime, Size, Length, ThreadId, StackId, HeapId FROM Memory_AllocationEvents WHERE Session = ? AND AllocTime < ? AND FreeTime > ?"),
        QUERY_ALLOC_BY_ALLOC_TIME("SELECT Tag, ClassTag, AllocTime, FreeTime, Size, Length, ThreadId, StackId, HeapId FROM Memory_AllocationEvents WHERE Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        QUERY_ALLOC_BY_FREE_TIME("SELECT Tag, ClassTag, AllocTime, FreeTime, Size, Length, ThreadId, StackId, HeapId FROM Memory_AllocationEvents WHERE Session = ? AND FreeTime >= ? AND FreeTime < ?"),
        QUERY_METHOD_INFO("Select MethodName, ClassName FROM Memory_MethodInfos WHERE Session = ? AND MethodId = ?"),
        QUERY_ENCODED_STACK_INFO_BY_TIME("Select StackData FROM Memory_StackInfos WHERE Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        QUERY_THREAD_INFO_BY_TIME("Select ThreadId, ThreadName FROM Memory_ThreadInfos WHERE Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        COUNT_ALLOC("SELECT count(*) FROM Memory_AllocationEvents"),
        PRUNE_ALLOC("DELETE FROM Memory_AllocationEvents WHERE Session = ? AND FreeTime <= ( SELECT MAX(FreeTime) FROM Memory_AllocationEvents WHERE Session = ? AND FreeTime < 9223372036854775807 ORDER BY FreeTime LIMIT ?)"),
        INSERT_JNI_REF("INSERT OR IGNORE INTO Memory_JniGlobalReferences (Session, Tag, RefValue, AllocTime, AllocThreadId, AllocBacktrace, FreeThreadId, FreeTime) VALUES (?, ?, ?, ?, ?, ?, 0, 9223372036854775807)"),
        UPDATE_JNI_REF("UPDATE Memory_JniGlobalReferences SET FreeTime = ?, FreeBacktrace = ?, FreeThreadId = ?WHERE Session = ? AND Tag = ? AND RefValue = ?"),
        COUNT_JNI_REF_RECORDS("SELECT COUNT(1) FROM Memory_JniGlobalReferences"),
        PRUNE_JNI_REF_RECORDS("DELETE FROM Memory_JniGlobalReferences WHERE Session = ? AND FreeTime <= ( SELECT MAX(FreeTime) FROM Memory_JniGlobalReferences WHERE Session = ? AND FreeTime < 9223372036854775807 ORDER BY FreeTime LIMIT ?)"),
        QUERY_JNI_REF_CREATE_EVENTS("SELECT Tag, RefValue, AllocTime AS Timestamp, AllocThreadId AS ThreadId, AllocBacktrace AS Backtrace FROM Memory_JniGlobalReferences WHERE Session = ? AND AllocTime >= ? AND AllocTime <= ? AND FreeTime >= ? AND FreeTime <= ? ORDER BY AllocTime"),
        QUERY_JNI_REF_DELETE_EVENTS("SELECT Tag, RefValue, FreeTime AS Timestamp, FreeThreadId AS ThreadId, FreeBacktrace AS Backtrace FROM Memory_JniGlobalReferences WHERE Session = ? AND AllocTime >= ? AND AllocTime <= ? AND FreeTime >= ? AND FreeTime <= ? ORDER BY FreeTime"),
        INSERT_NATIVE_FRAME("INSERT OR IGNORE INTO Memory_NativeFrames (Session, Address, Offset, Module, Symbolized) VALUES (?, ?, ?, ?, 0)"),
        UPDATE_NATIVE_FRAME("UPDATE Memory_NativeFrames SET NativeFrame = ?, Symbolized = 1 WHERE Session = ? AND Address = ?"),
        QUERY_NATIVE_FRAME("SELECT NativeFrame FROM Memory_NativeFrames WHERE (Session = ?) AND (Address = ?)"),
        QUERY_NATIVE_FRAMES_TO_SYMBOLIZE("SELECT Address, Offset, Module FROM Memory_NativeFrames WHERE (Session = ?) AND Symbolized = 0 LIMIT ?");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            if (sqlStatement == null) {
                MemoryStatements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                MemoryStatements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/MemoryLiveAllocationTable$MemoryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/MemoryLiveAllocationTable$MemoryStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

