/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.DeviceId;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerTable
extends DataStoreTable<ProfilerStatements> {
    private final Object myLock = new Object();

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            ProfilerTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Profiler_Bytes", "Id STRING NOT NULL", "Session INTEGER", "Data BLOB");
            this.createTable("Profiler_Devices", "DeviceId INTEGER", "LastKnownTime INTEGER", "Data BLOB");
            this.createTable("Profiler_Processes", "DeviceId INTEGER", "ProcessId INTEGER", "Name STRING NOT NULL", "State INTEGER", "StartTime INTEGER", "Arch STRING NOT NULL", "AgentStatus INTEGER", "IsAgentAttachable INTEGER");
            this.createTable("Profiler_Sessions", "SessionId INTEGER", "DeviceId INTEGER", "ProcessId INTEGER", "StartTime INTEGER", "EndTime INTEGER", "StartTimeEpochMs INTEGER", "NAME TEXT", "JvmtiEnabled INTEGER", "LiveAllocationEnabled INTEGER", "TypeId INTEGER");
            this.createUniqueIndex("Profiler_Processes", "DeviceId", "ProcessId");
            this.createUniqueIndex("Profiler_Devices", "DeviceId");
            this.createUniqueIndex("Profiler_Bytes", "Id", "Session");
            this.createUniqueIndex("Profiler_Sessions", "SessionId");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    public void initializeConnectionOnly(@NotNull Connection connection) {
        if (connection == null) {
            ProfilerTable.$$$reportNull$$$0(1);
        }
        super.initialize(connection);
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(ProfilerStatements.INSERT_DEVICE, "INSERT OR REPLACE INTO Profiler_Devices (DeviceId, Data) values (?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_DEVICE_LAST_KNOWN_TIME, "UPDATE Profiler_Devices Set LastKnownTime = ? WHERE DeviceId = ?");
            this.createStatement(ProfilerStatements.INSERT_PROCESS, "INSERT OR REPLACE INTO Profiler_Processes (DeviceId, ProcessId, Name, State, StartTime, Arch) values (?, ?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_PROCESS_STATE, "UPDATE Profiler_Processes Set State = ? WHERE DeviceId = ? AND ProcessId = ?");
            this.createStatement(ProfilerStatements.INSERT_SESSION, "INSERT OR REPLACE INTO Profiler_Sessions (SessionId, DeviceId, ProcessId, StartTime, EndTime, StartTimeEpochMs, Name, JvmtiEnabled, LiveAllocationEnabled, TypeId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_SESSION, "UPDATE Profiler_Sessions Set EndTime = ? WHERE SessionId = ?");
            this.createStatement(ProfilerStatements.SELECT_PROCESSES, "SELECT DeviceId, ProcessId, Name, State, StartTime, Arch from Profiler_Processes WHERE DeviceId = ?");
            this.createStatement(ProfilerStatements.SELECT_PROCESS_BY_ID, "SELECT ProcessId from Profiler_Processes WHERE DeviceId = ? AND ProcessId = ?");
            this.createStatement(ProfilerStatements.SELECT_DEVICE, "SELECT Data from Profiler_Devices");
            this.createStatement(ProfilerStatements.SELECT_DEVICE_LAST_KNOWN_TIME, "SELECT LastKnownTime FROM Profiler_Devices WHERE DeviceId = ?");
            this.createStatement(ProfilerStatements.SELECT_SESSIONS, "SELECT * from Profiler_Sessions ORDER BY SessionId ASC");
            this.createStatement(ProfilerStatements.SELECT_SESSION_BY_ID, "SELECT * from Profiler_Sessions WHERE SessionId = ?");
            this.createStatement(ProfilerStatements.DELETE_SESSION_BY_ID, "DELETE from Profiler_Sessions WHERE SessionId = ?");
            this.createStatement(ProfilerStatements.FIND_AGENT_STATUS, "SELECT AgentStatus, IsAgentAttachable from Profiler_Processes WHERE DeviceId = ? AND ProcessId = ?");
            this.createStatement(ProfilerStatements.UPDATE_AGENT_STATUS, "UPDATE Profiler_Processes SET AgentStatus = ?, IsAgentAttachable = ? WHERE DeviceId = ? AND ProcessId = ?");
            this.createStatement(ProfilerStatements.INSERT_BYTES, "INSERT OR REPLACE INTO Profiler_Bytes (Id, Session, Data) VALUES (?, ?, ?)");
            this.createStatement(ProfilerStatements.GET_BYTES, "SELECT Data FROM Profiler_Bytes WHERE Id = ? AND Session = ?");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Profiler.GetDevicesResponse getDevices() {
        if (this.isClosed()) {
            Profiler.GetDevicesResponse getDevicesResponse = Profiler.GetDevicesResponse.getDefaultInstance();
            if (getDevicesResponse != null) return getDevicesResponse;
            ProfilerTable.$$$reportNull$$$0(2);
            return getDevicesResponse;
        }
        Object object = this.myLock;
        // MONITORENTER : object
        Profiler.GetDevicesResponse.Builder responseBuilder = Profiler.GetDevicesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_DEVICE, new Object[0]);
            while (results.next()) {
                responseBuilder.addDevice(Common.Device.parseFrom((byte[])results.getBytes(1)));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetDevicesResponse getDevicesResponse = responseBuilder.build();
        // MONITOREXIT : object
        if (getDevicesResponse != null) return getDevicesResponse;
        ProfilerTable.$$$reportNull$$$0(3);
        return getDevicesResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeviceLastKnownTime(@NotNull DeviceId deviceId) {
        if (deviceId == null) {
            ProfilerTable.$$$reportNull$$$0(4);
        }
        if (this.isClosed()) {
            return Long.MIN_VALUE;
        }
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_DEVICE_LAST_KNOWN_TIME, deviceId.get());
                if (results.next()) {
                    return results.getLong(1);
                }
            }
            catch (SQLException ex) {
                ProfilerTable.onError(ex);
            }
        }
        return Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Profiler.GetProcessesResponse getProcesses(@NotNull Profiler.GetProcessesRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(5);
        }
        if (this.isClosed()) {
            Profiler.GetProcessesResponse getProcessesResponse = Profiler.GetProcessesResponse.getDefaultInstance();
            if (getProcessesResponse != null) return getProcessesResponse;
            ProfilerTable.$$$reportNull$$$0(6);
            return getProcessesResponse;
        }
        Object object = this.myLock;
        // MONITORENTER : object
        Profiler.GetProcessesResponse.Builder responseBuilder = Profiler.GetProcessesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESSES, request.getDeviceId());
            while (results.next()) {
                long deviceId = results.getLong(1);
                int pid = results.getInt(2);
                String name = results.getString(3);
                int state = results.getInt(4);
                long startTimeNs = results.getLong(5);
                String arch = results.getString(6);
                Common.Process process = Common.Process.newBuilder().setDeviceId(deviceId).setPid(pid).setName(name).setState(Common.Process.State.forNumber((int)state)).setStartTimestampNs(startTimeNs).setAbiCpuArch(arch).build();
                responseBuilder.addProcess(process);
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetProcessesResponse getProcessesResponse = responseBuilder.build();
        // MONITOREXIT : object
        if (getProcessesResponse != null) return getProcessesResponse;
        ProfilerTable.$$$reportNull$$$0(7);
        return getProcessesResponse;
    }

    @NotNull
    public Common.Session getSessionById(long sessionId) {
        if (this.isClosed()) {
            Common.Session session = Common.Session.getDefaultInstance();
            if (session == null) {
                ProfilerTable.$$$reportNull$$$0(8);
            }
            return session;
        }
        Common.Session.Builder builder = Common.Session.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSION_BY_ID, sessionId);
            if (results.next()) {
                builder.setSessionId(results.getLong(1)).setDeviceId(results.getLong(2)).setPid(results.getInt(3)).setStartTimestamp(results.getLong(4)).setEndTimestamp(results.getLong(5));
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Common.Session session = builder.build();
        if (session == null) {
            ProfilerTable.$$$reportNull$$$0(9);
        }
        return session;
    }

    @NotNull
    public Profiler.GetSessionMetaDataResponse getSessionMetaData(long sessionId) {
        if (this.isClosed()) {
            Profiler.GetSessionMetaDataResponse getSessionMetaDataResponse = Profiler.GetSessionMetaDataResponse.getDefaultInstance();
            if (getSessionMetaDataResponse == null) {
                ProfilerTable.$$$reportNull$$$0(10);
            }
            return getSessionMetaDataResponse;
        }
        Profiler.GetSessionMetaDataResponse.Builder responseBuilder = Profiler.GetSessionMetaDataResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSION_BY_ID, sessionId);
            while (results.next()) {
                responseBuilder.setData(Common.SessionMetaData.newBuilder().setSessionId(results.getLong(1)).setStartTimestampEpochMs(results.getLong(6)).setSessionName(results.getString(7)).setJvmtiEnabled(results.getBoolean(8)).setLiveAllocationEnabled(results.getBoolean(9)).setType(Common.SessionMetaData.SessionType.forNumber((int)results.getInt(10))).build());
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetSessionMetaDataResponse getSessionMetaDataResponse = responseBuilder.build();
        if (getSessionMetaDataResponse == null) {
            ProfilerTable.$$$reportNull$$$0(11);
        }
        return getSessionMetaDataResponse;
    }

    @NotNull
    public Profiler.GetSessionsResponse getSessions() {
        if (this.isClosed()) {
            Profiler.GetSessionsResponse getSessionsResponse = Profiler.GetSessionsResponse.getDefaultInstance();
            if (getSessionsResponse == null) {
                ProfilerTable.$$$reportNull$$$0(12);
            }
            return getSessionsResponse;
        }
        Profiler.GetSessionsResponse.Builder responseBuilder = Profiler.GetSessionsResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSIONS, new Object[0]);
            while (results.next()) {
                responseBuilder.addSessions(Common.Session.newBuilder().setSessionId(results.getLong(1)).setDeviceId(results.getLong(2)).setPid(results.getInt(3)).setStartTimestamp(results.getLong(4)).setEndTimestamp(results.getLong(5)).build());
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetSessionsResponse getSessionsResponse = responseBuilder.build();
        if (getSessionsResponse == null) {
            ProfilerTable.$$$reportNull$$$0(13);
        }
        return getSessionsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateDevice(@NotNull Common.Device device) {
        if (device == null) {
            ProfilerTable.$$$reportNull$$$0(14);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.execute(ProfilerStatements.INSERT_DEVICE, device.getDeviceId(), device.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSession(long sessionId) {
        Object object = this.myLock;
        synchronized (object) {
            this.execute(ProfilerStatements.DELETE_SESSION_BY_ID, sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeviceLastKnownTime(@NotNull Common.Device device, long lastKnownTimeNs) {
        if (device == null) {
            ProfilerTable.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.execute(ProfilerStatements.UPDATE_DEVICE_LAST_KNOWN_TIME, lastKnownTimeNs, device.getDeviceId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateProcess(@NotNull DeviceId devicdId, @NotNull Common.Process process) {
        if (devicdId == null) {
            ProfilerTable.$$$reportNull$$$0(16);
        }
        if (process == null) {
            ProfilerTable.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESS_BY_ID, devicdId.get(), process.getPid());
                if (results.next()) {
                    this.execute(ProfilerStatements.UPDATE_PROCESS_STATE, process.getStateValue(), devicdId.get(), process.getPid());
                } else {
                    this.execute(ProfilerStatements.INSERT_PROCESS, devicdId.get(), process.getPid(), process.getName(), process.getStateValue(), process.getStartTimestampNs(), process.getAbiCpuArch());
                }
            }
            catch (SQLException ex) {
                ProfilerTable.onError(ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void insertOrUpdateSession(@NotNull Common.Session session, @NotNull String name, long startTimeUtc, boolean jvmtiEnabled, boolean liveAllocationEnabled, Common.SessionMetaData.SessionType sessionType) {
        void sessionType2;
        if (session == null) {
            ProfilerTable.$$$reportNull$$$0(18);
        }
        if (name == null) {
            ProfilerTable.$$$reportNull$$$0(19);
        }
        this.execute(ProfilerStatements.INSERT_SESSION, session.getSessionId(), session.getDeviceId(), session.getPid(), session.getStartTimestamp(), session.getEndTimestamp(), startTimeUtc, name, jvmtiEnabled, liveAllocationEnabled, sessionType2.getNumber());
    }

    public void updateSessionEndTime(long sessionId, long endTimestampNs) {
        this.execute(ProfilerStatements.UPDATE_SESSION, endTimestampNs, sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentStatus(@NotNull DeviceId devicdId, @NotNull Common.Process process, @NotNull Profiler.AgentStatusResponse agentStatus) {
        if (devicdId == null) {
            ProfilerTable.$$$reportNull$$$0(20);
        }
        if (process == null) {
            ProfilerTable.$$$reportNull$$$0(21);
        }
        if (agentStatus == null) {
            ProfilerTable.$$$reportNull$$$0(22);
        }
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, devicdId.get(), process.getPid());
                if (results.next()) {
                    Profiler.AgentStatusResponse.Status status = Profiler.AgentStatusResponse.Status.forNumber((int)results.getInt(1));
                    switch (status) {
                        case DETACHED: 
                        case UNSPECIFIED: 
                        case UNRECOGNIZED: {
                            status = agentStatus.getStatus();
                            break;
                        }
                    }
                    this.execute(ProfilerStatements.UPDATE_AGENT_STATUS, status.ordinal(), agentStatus.getIsAgentAttachable(), devicdId.get(), process.getPid());
                }
            }
            catch (SQLException ex) {
                ProfilerTable.onError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Profiler.AgentStatusResponse getAgentStatus(@NotNull Profiler.AgentStatusRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(23);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        Profiler.AgentStatusResponse.Builder responseBuilder = Profiler.AgentStatusResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, request.getDeviceId(), request.getPid());
            if (results.next()) {
                responseBuilder.setStatusValue(results.getInt(1));
                responseBuilder.setIsAgentAttachable(results.getBoolean(2));
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.AgentStatusResponse agentStatusResponse = responseBuilder.build();
        // MONITOREXIT : object
        if (agentStatusResponse != null) return agentStatusResponse;
        ProfilerTable.$$$reportNull$$$0(24);
        return agentStatusResponse;
    }

    public void insertOrUpdateBytes(@NotNull String id, @NotNull Common.Session session, @NotNull Profiler.BytesResponse response) {
        if (id == null) {
            ProfilerTable.$$$reportNull$$$0(25);
        }
        if (session == null) {
            ProfilerTable.$$$reportNull$$$0(26);
        }
        if (response == null) {
            ProfilerTable.$$$reportNull$$$0(27);
        }
        this.execute(ProfilerStatements.INSERT_BYTES, id, session.getSessionId(), response.toByteArray());
    }

    @Nullable
    public Profiler.BytesResponse getBytes(@NotNull Profiler.BytesRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(28);
        }
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.GET_BYTES, request.getId(), request.getSession().getSessionId());
            if (results.next()) {
                return Profiler.BytesResponse.parseFrom((byte[])results.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            ProfilerTable.onError(ex);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceId";
                break;
            }
            case 5: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devicdId";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentStatus";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcesses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionById";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionMetaData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeConnectionOnly";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceLastKnownTime";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProcesses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateDevice";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateDeviceLastKnownTime";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateProcess";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateSession";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateAgentStatus";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAgentStatus";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateBytes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ProfilerStatements {
        INSERT_DEVICE,
        UPDATE_DEVICE_LAST_KNOWN_TIME,
        INSERT_PROCESS,
        UPDATE_PROCESS_STATE,
        INSERT_SESSION,
        UPDATE_SESSION,
        SELECT_PROCESSES,
        SELECT_PROCESS_BY_ID,
        SELECT_DEVICE,
        SELECT_DEVICE_LAST_KNOWN_TIME,
        SELECT_SESSIONS,
        SELECT_SESSION_BY_ID,
        DELETE_SESSION_BY_ID,
        FIND_AGENT_STATUS,
        UPDATE_AGENT_STATUS,
        INSERT_BYTES,
        GET_BYTES;

    }
}

