/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.energy;

import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.profiler.proto.EnergyProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BatteryModel {
    private static final long DEFAULT_SAMPLE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final long GPS_LOCK_DURATION_NS = TimeUnit.SECONDS.toNanos(7L);
    private static final long NETWORK_SCAN_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(500L);
    private static final int LOCATION_SMOOTHING_SAMPLES = 4;
    @NotNull
    private final List<EnergyProfiler.EnergySample> mySparseSamples;
    @NotNull
    private final PowerProfile myPowerProfile;
    private final long mySampleIntervalNs;
    private PowerProfile.CpuCoreUsage[] myLastCpuCoresUsage;
    @NotNull
    private PowerProfile.NetworkType myNetworkType;
    private long myReceivingBps;
    private long mySendingBps;
    private Map<Integer, Long> myGpsLockonMap;
    private Map<Integer, EnergyProfiler.EnergySample> myLocationSmoothingMap;
    private long myLastNetworkLocationOffTime;
    private final long mySmoothingEndDeltaTime;
    private long myLastGpsOffTime;

    public BatteryModel() {
        this(new PowerProfile.DefaultPowerProfile(), DEFAULT_SAMPLE_INTERVAL_NS);
    }

    public BatteryModel(@NotNull PowerProfile powerProfile, long sampleIntervalNs) {
        if (powerProfile == null) {
            BatteryModel.$$$reportNull$$$0(0);
        }
        this.mySparseSamples = new ArrayList<EnergyProfiler.EnergySample>();
        this.myNetworkType = PowerProfile.NetworkType.NONE;
        this.myGpsLockonMap = new HashMap<Integer, Long>();
        this.myLocationSmoothingMap = new HashMap<Integer, EnergyProfiler.EnergySample>();
        this.myLastNetworkLocationOffTime = 0L;
        this.myLastGpsOffTime = 0L;
        this.myPowerProfile = powerProfile;
        this.mySampleIntervalNs = sampleIntervalNs;
        this.mySmoothingEndDeltaTime = 4L * this.mySampleIntervalNs;
        this.mySparseSamples.add(0, EnergyProfiler.EnergySample.getDefaultInstance());
    }

    static long align(long originalValue, long alignment) {
        long valueMod = originalValue % alignment;
        originalValue = valueMod <= alignment / 2L ? (originalValue -= valueMod) : (originalValue += alignment - valueMod);
        return originalValue;
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(long timestampNs, @NotNull Event energyEvent, Object object) {
        if (energyEvent == null) {
            BatteryModel.$$$reportNull$$$0(1);
        }
        switch (energyEvent) {
            case CPU_USAGE: {
                void eventArg;
                Object[] cpuCoresUsage = (PowerProfile.CpuCoreUsage[])eventArg;
                if (Arrays.equals(this.myLastCpuCoresUsage, cpuCoresUsage)) break;
                this.myLastCpuCoresUsage = cpuCoresUsage;
                this.addNewCpuSample(timestampNs);
                break;
            }
            case NETWORK_USAGE: {
                void eventArg;
                PowerProfile.NetworkStats networkStats = (PowerProfile.NetworkStats)eventArg;
                if (this.myNetworkType == networkStats.myNetworkType && this.myReceivingBps == networkStats.myReceivingBps && this.mySendingBps == networkStats.mySendingBps) break;
                this.myNetworkType = networkStats.myNetworkType;
                this.myReceivingBps = networkStats.myReceivingBps;
                this.mySendingBps = networkStats.mySendingBps;
                this.addNewNetworkSample(timestampNs, new PowerProfile.NetworkStats(this.myNetworkType, this.myReceivingBps, this.mySendingBps));
                break;
            }
            case LOCATION_REGISTER: {
                void eventArg;
                PowerProfile.LocationEvent locationEvent = (PowerProfile.LocationEvent)eventArg;
                if (locationEvent.myLocationType != PowerProfile.LocationType.GPS) break;
                this.myGpsLockonMap.put(locationEvent.myEventId, timestampNs);
                this.addNewLocationSample(timestampNs + this.mySampleIntervalNs, new PowerProfile.LocationStats(PowerProfile.LocationType.GPS_ACQUIRE, 0L, this.mySampleIntervalNs));
                break;
            }
            case LOCATION_UNREGISTER: {
                void eventArg;
                PowerProfile.LocationEvent locationEvent = (PowerProfile.LocationEvent)eventArg;
                Long timestamp = this.myGpsLockonMap.remove(locationEvent.myEventId);
                if (timestamp == null) break;
                this.addNewLocationSample(timestampNs + this.mySampleIntervalNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                break;
            }
            case LOCATION_UPDATE: {
                void eventArg;
                this.handleLocationUpdateEvent(timestampNs, (PowerProfile.LocationEvent)eventArg);
            }
        }
    }

    @NotNull
    public List<EnergyProfiler.EnergySample> getSamplesBetween(long startInclusiveNs, long endExclusiveNs) {
        int currIndex = this.getSampleIndexFor(startInclusiveNs);
        ArrayList<EnergyProfiler.EnergySample> samples = new ArrayList<EnergyProfiler.EnergySample>();
        for (long timestampNs = this.alignToSampleInterval(startInclusiveNs); timestampNs < endExclusiveNs; timestampNs += this.mySampleIntervalNs) {
            EnergyProfiler.EnergySample nextSample;
            EnergyProfiler.EnergySample nearestSample = this.mySparseSamples.get(currIndex);
            int nextIndex = currIndex + 1;
            if (nextIndex < this.mySparseSamples.size() && (nextSample = this.mySparseSamples.get(nextIndex)).getTimestamp() <= timestampNs) {
                ++currIndex;
                nearestSample = nextSample;
            }
            samples.add(nearestSample.toBuilder().setTimestamp(timestampNs).build());
        }
        ArrayList<EnergyProfiler.EnergySample> arrayList = samples;
        if (arrayList == null) {
            BatteryModel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private int getSampleIndexFor(long timestampNs) {
        for (int i = this.mySparseSamples.size() - 1; i >= 0; --i) {
            EnergyProfiler.EnergySample sample = this.mySparseSamples.get(i);
            if (sample.getTimestamp() > timestampNs) continue;
            return i;
        }
        return 0;
    }

    private void addNewCpuSample(long timestampNs) {
        this.addNewSample(timestampNs, sample -> sample.setCpuUsage(this.myPowerProfile.getCpuUsage(this.myLastCpuCoresUsage)));
    }

    /*
     * WARNING - void declaration
     */
    private void addNewNetworkSample(long timestampNs, @NotNull PowerProfile.NetworkStats networkStats) {
        void networkStats2;
        if (networkStats == null) {
            BatteryModel.$$$reportNull$$$0(3);
        }
        this.addNewSample(timestampNs, arg_0 -> this.lambda$addNewNetworkSample$1((PowerProfile.NetworkStats)networkStats2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private EnergyProfiler.EnergySample addNewLocationSample(long timestampNs, @NotNull PowerProfile.LocationStats locationStats) {
        void locationStats2;
        if (locationStats == null) {
            BatteryModel.$$$reportNull$$$0(4);
        }
        EnergyProfiler.EnergySample energySample = this.addNewSample(timestampNs, arg_0 -> this.lambda$addNewLocationSample$2((PowerProfile.LocationStats)locationStats2, arg_0));
        if (energySample == null) {
            BatteryModel.$$$reportNull$$$0(5);
        }
        return energySample;
    }

    private void removeLocationSample(long timestampNs) {
        this.removeDataFromSample(timestampNs, sample -> sample.setLocationUsage(0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private EnergyProfiler.EnergySample addNewSample(long timestampNs, @NotNull Function<EnergyProfiler.EnergySample.Builder, EnergyProfiler.EnergySample.Builder> function) {
        EnergyProfiler.EnergySample newSampleNoTime;
        void produceNewSample;
        int prevSampleIndex;
        EnergyProfiler.EnergySample prevSample;
        if (function == null) {
            BatteryModel.$$$reportNull$$$0(6);
        }
        if ((timestampNs = this.alignToSampleInterval(timestampNs)) < (prevSample = this.mySparseSamples.get(prevSampleIndex = this.getSampleIndexFor(timestampNs))).getTimestamp()) {
            throw new IllegalArgumentException("Received energy events out of order");
        }
        EnergyProfiler.EnergySample newSample = ((EnergyProfiler.EnergySample.Builder)produceNewSample.apply(prevSample.toBuilder().setTimestamp(timestampNs))).build();
        EnergyProfiler.EnergySample prevSampleNoTime = prevSample.toBuilder().setTimestamp(0L).build();
        if (!prevSampleNoTime.equals((Object)(newSampleNoTime = newSample.toBuilder().setTimestamp(0L).build()))) {
            if (prevSample.getTimestamp() == newSample.getTimestamp()) {
                this.mySparseSamples.set(prevSampleIndex, newSample);
            } else {
                this.mySparseSamples.add(prevSampleIndex + 1, newSample);
            }
        }
        EnergyProfiler.EnergySample energySample = newSample;
        if (energySample == null) {
            BatteryModel.$$$reportNull$$$0(7);
        }
        return energySample;
    }

    /*
     * WARNING - void declaration
     */
    private void removeDataFromSample(long timestampNs, @NotNull Function<EnergyProfiler.EnergySample.Builder, EnergyProfiler.EnergySample.Builder> function) {
        void resetSample;
        int sampleIndex;
        EnergyProfiler.EnergySample originalSample;
        if (function == null) {
            BatteryModel.$$$reportNull$$$0(8);
        }
        if ((timestampNs = this.alignToSampleInterval(timestampNs)) != (originalSample = this.mySparseSamples.get(sampleIndex = this.getSampleIndexFor(timestampNs))).getTimestamp()) {
            return;
        }
        EnergyProfiler.EnergySample updatedSample = ((EnergyProfiler.EnergySample.Builder)resetSample.apply(originalSample.toBuilder().setTimestamp(timestampNs))).build();
        EnergyProfiler.EnergySample updatedSampleNoTime = updatedSample.toBuilder().setTimestamp(0L).build();
        if (updatedSampleNoTime.equals((Object)EnergyProfiler.EnergySample.getDefaultInstance())) {
            this.mySparseSamples.remove(sampleIndex);
        } else {
            this.mySparseSamples.set(sampleIndex, updatedSample);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleLocationUpdateEvent(long timestampNs, @NotNull PowerProfile.LocationEvent locationEvent) {
        void locationEvent2;
        if (locationEvent == null) {
            BatteryModel.$$$reportNull$$$0(9);
        }
        switch (locationEvent2.myLocationType) {
            case GPS: {
                if (this.myGpsLockonMap.containsKey(locationEvent2.myEventId)) {
                    this.myGpsLockonMap.remove(locationEvent2.myEventId);
                    this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                } else {
                    EnergyProfiler.EnergySample previousSample = this.myLocationSmoothingMap.get(locationEvent2.myEventId);
                    long residualTime = this.calculateResidualSmoothingTime(previousSample, timestampNs);
                    if (residualTime > 0L) {
                        this.removeLocationSample(previousSample.getTimestamp() + this.mySmoothingEndDeltaTime);
                    }
                    EnergyProfiler.EnergySample eventSample = this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(PowerProfile.LocationType.GPS, Math.min(GPS_LOCK_DURATION_NS, timestampNs - this.myLastGpsOffTime) + residualTime, this.mySampleIntervalNs * 4L));
                    this.myLocationSmoothingMap.put(locationEvent2.myEventId, eventSample);
                    this.addNewLocationSample(timestampNs + this.mySmoothingEndDeltaTime, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                }
                this.myLastGpsOffTime = timestampNs;
                break;
            }
            case NETWORK: {
                this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NETWORK, Math.min(NETWORK_SCAN_DURATION_NS, timestampNs - this.myLastNetworkLocationOffTime), this.mySampleIntervalNs * 4L));
                this.addNewLocationSample(timestampNs + 4L * this.mySampleIntervalNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                this.myLastNetworkLocationOffTime = timestampNs;
                break;
            }
            default: {
                this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(locationEvent2.myLocationType, 0L, this.mySampleIntervalNs));
            }
        }
    }

    private long alignToSampleInterval(long timestampNs) {
        return BatteryModel.align(timestampNs, this.mySampleIntervalNs);
    }

    private long calculateResidualSmoothingTime(@Nullable EnergyProfiler.EnergySample previousSample, long currentTime) {
        if (previousSample == null) {
            return 0L;
        }
        return Math.max(0L, this.alignToSampleInterval(previousSample.getTimestamp() + this.mySmoothingEndDeltaTime) - this.alignToSampleInterval(currentTime));
    }

    private /* synthetic */ EnergyProfiler.EnergySample.Builder lambda$addNewLocationSample$2(@NotNull PowerProfile.LocationStats locationStats, EnergyProfiler.EnergySample.Builder sample) {
        if (locationStats == null) {
            BatteryModel.$$$reportNull$$$0(10);
        }
        return sample.setLocationUsage(this.myPowerProfile.getLocationUsage(locationStats));
    }

    private /* synthetic */ EnergyProfiler.EnergySample.Builder lambda$addNewNetworkSample$1(@NotNull PowerProfile.NetworkStats networkStats, EnergyProfiler.EnergySample.Builder sample) {
        if (networkStats == null) {
            BatteryModel.$$$reportNull$$$0(11);
        }
        return sample.setNetworkUsage(this.myPowerProfile.getNetworkUsage(networkStats));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "powerProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "energyEvent";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/energy/BatteryModel";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "networkStats";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationStats";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "produceNewSample";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetSample";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/energy/BatteryModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSamplesBetween";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewLocationSample";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewSample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addNewNetworkSample";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNewLocationSample";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewSample";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeDataFromSample";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleLocationUpdateEvent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addNewLocationSample$2";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addNewNetworkSample$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Event {
        CPU_USAGE,
        NETWORK_USAGE,
        LOCATION_REGISTER,
        LOCATION_UNREGISTER,
        LOCATION_UPDATE;

    }
}

