/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.EnergyTable;
import com.android.tools.datastore.energy.BatteryModel;
import com.android.tools.datastore.energy.CpuConfig;
import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnergyDataPoller
extends PollRunner {
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final LogService myLogService;
    @NotNull
    private final BatteryModel myBatteryModel;
    @NotNull
    private final EnergyTable myEnergyTable;
    @NotNull
    private final EnergyServiceGrpc.EnergyServiceBlockingStub myEnergyService;
    private long myDataRequestStartTimestampNs;
    @Nullable
    private CpuProfiler.CpuUsageData myLastData;
    private PowerProfile.NetworkType myLastKnownNetworkType;
    @NotNull
    private ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerService;
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myCpuService;
    @NotNull
    private NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    private long myLastRetryTime;
    private int myCpuConfigRetries;
    @NotNull
    private CpuConfig myCpuConfig;

    public EnergyDataPoller(@NotNull Common.Session session, @NotNull BatteryModel batteryModel, @NotNull EnergyTable eventTable, @NotNull ProfilerServiceGrpc.ProfilerServiceBlockingStub profilerService, @NotNull CpuServiceGrpc.CpuServiceBlockingStub cpuService, @NotNull NetworkServiceGrpc.NetworkServiceBlockingStub networkService, @NotNull EnergyServiceGrpc.EnergyServiceBlockingStub energyService, @NotNull LogService logService) {
        if (session == null) {
            EnergyDataPoller.$$$reportNull$$$0(0);
        }
        if (batteryModel == null) {
            EnergyDataPoller.$$$reportNull$$$0(1);
        }
        if (eventTable == null) {
            EnergyDataPoller.$$$reportNull$$$0(2);
        }
        if (profilerService == null) {
            EnergyDataPoller.$$$reportNull$$$0(3);
        }
        if (cpuService == null) {
            EnergyDataPoller.$$$reportNull$$$0(4);
        }
        if (networkService == null) {
            EnergyDataPoller.$$$reportNull$$$0(5);
        }
        if (energyService == null) {
            EnergyDataPoller.$$$reportNull$$$0(6);
        }
        if (logService == null) {
            EnergyDataPoller.$$$reportNull$$$0(7);
        }
        super(POLLING_DELAY_NS);
        this.myLastData = null;
        this.myLastKnownNetworkType = PowerProfile.NetworkType.NONE;
        this.myLastRetryTime = 0L;
        this.myCpuConfigRetries = 5;
        this.myBatteryModel = batteryModel;
        this.myEnergyTable = eventTable;
        this.myProfilerService = profilerService;
        this.myCpuService = cpuService;
        this.myNetworkService = networkService;
        this.myEnergyService = energyService;
        this.mySession = session;
        this.myLogService = logService;
        this.myDataRequestStartTimestampNs = this.queryCurrentTime();
        CpuProfiler.CpuCoreConfigResponse response = CpuProfiler.CpuCoreConfigResponse.getDefaultInstance();
        try {
            this.myLastRetryTime = System.currentTimeMillis();
            response = this.myCpuService.getCpuCoreConfig(CpuProfiler.CpuCoreConfigRequest.newBuilder().setDeviceId(session.getDeviceId()).build());
        }
        catch (StatusRuntimeException e) {
            this.getLog().debug("Unable to parse CPU frequency files.", e);
        }
        this.myCpuConfig = new CpuConfig(response, this.myLogService);
    }

    private long queryCurrentTime() {
        Profiler.TimeRequest timeRequest = Profiler.TimeRequest.newBuilder().setDeviceId(this.mySession.getDeviceId()).build();
        return this.myProfilerService.getCurrentTime(timeRequest).getTimestampNs();
    }

    @Override
    public void poll() throws StatusRuntimeException {
        long endTimestampNs = this.queryCurrentTime();
        EnergyProfiler.EnergyRequest request = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession).setStartTimestamp(this.myDataRequestStartTimestampNs).setEndTimestamp(endTimestampNs).build();
        this.addLatestEvents(request);
        this.addLatestSamples(request);
        this.myDataRequestStartTimestampNs = endTimestampNs;
    }

    private void addLatestEvents(@NotNull EnergyProfiler.EnergyRequest request) {
        if (request == null) {
            EnergyDataPoller.$$$reportNull$$$0(8);
        }
        for (EnergyProfiler.EnergyEvent event : this.myEnergyService.getEvents(request).getEventsList()) {
            if (event.hasLocationUpdateRequested()) {
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_REGISTER, new PowerProfile.LocationEvent(event.getEventId(), PowerProfile.LocationType.from(event.getLocationUpdateRequested().getRequest().getProvider())));
            }
            if (event.hasLocationChanged()) {
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UPDATE, new PowerProfile.LocationEvent(event.getEventId(), PowerProfile.LocationType.from(event.getLocationChanged().getLocation().getProvider())));
            }
            if (event.hasLocationUpdateRemoved()) {
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UNREGISTER, new PowerProfile.LocationEvent(event.getEventId(), PowerProfile.LocationType.NONE));
            }
            this.myEnergyTable.insertOrReplace(this.mySession, event);
        }
    }

    private void addLatestSamples(@NotNull EnergyProfiler.EnergyRequest request) {
        if (request == null) {
            EnergyDataPoller.$$$reportNull$$$0(9);
        }
        NetworkProfiler.NetworkDataRequest networkDataRequest = NetworkProfiler.NetworkDataRequest.newBuilder().setSession(request.getSession()).setStartTimestamp(request.getStartTimestamp()).setEndTimestamp(request.getEndTimestamp()).setType(NetworkProfiler.NetworkDataRequest.Type.ALL).build();
        NetworkProfiler.NetworkDataResponse networkDataResponse = this.myNetworkService.getData(networkDataRequest);
        for (NetworkProfiler.NetworkProfilerData networkData : networkDataResponse.getDataList()) {
            switch (networkData.getDataCase()) {
                case CONNECTIVITY_DATA: {
                    this.myLastKnownNetworkType = PowerProfile.NetworkType.from(networkData.getConnectivityData().getDefaultNetworkType());
                    break;
                }
                case SPEED_DATA: {
                    NetworkProfiler.SpeedData speedData = networkData.getSpeedData();
                    this.myBatteryModel.handleEvent(networkData.getEndTimestamp(), BatteryModel.Event.NETWORK_USAGE, new PowerProfile.NetworkStats(this.myLastKnownNetworkType, speedData.getReceived(), speedData.getSent()));
                    break;
                }
            }
        }
        if (!this.myCpuConfig.getIsMinMaxCoreFreqValid() && this.myCpuConfigRetries > 0 && (this.myLastRetryTime = System.currentTimeMillis()) - this.myLastRetryTime > TimeUnit.SECONDS.toMillis(1L)) {
            --this.myCpuConfigRetries;
            this.myLastRetryTime = System.currentTimeMillis();
            try {
                this.myCpuConfig = new CpuConfig(this.myCpuService.getCpuCoreConfig(CpuProfiler.CpuCoreConfigRequest.newBuilder().setDeviceId(this.mySession.getDeviceId()).build()), this.myLogService);
            }
            catch (StatusRuntimeException e) {
                this.getLog().debug(String.format("Unable to parse CPU frequency files. Retries remaining: %d", this.myCpuConfigRetries), e);
            }
        }
        CpuProfiler.CpuDataRequest cpuDataRequest = CpuProfiler.CpuDataRequest.newBuilder().setSession(request.getSession()).setStartTimestamp(request.getStartTimestamp()).setEndTimestamp(request.getEndTimestamp()).build();
        CpuProfiler.CpuDataResponse cpuDataResponse = this.myCpuService.getData(cpuDataRequest);
        CpuProfiler.CpuUsageData prevUsageData = this.myLastData;
        for (CpuProfiler.CpuUsageData currUsageData : cpuDataResponse.getDataList()) {
            if (prevUsageData == null) {
                prevUsageData = currUsageData;
                continue;
            }
            this.myBatteryModel.handleEvent(currUsageData.getEndTimestamp(), BatteryModel.Event.CPU_USAGE, this.myCpuConfig.getCpuCoreUsages(prevUsageData, currUsageData));
            prevUsageData = currUsageData;
        }
        for (EnergyProfiler.EnergySample sample : this.myBatteryModel.getSamplesBetween(request.getStartTimestamp(), request.getEndTimestamp())) {
            this.myEnergyTable.insertOrReplace(this.mySession, sample);
        }
    }

    @NotNull
    private LogService.Logger getLog() {
        LogService.Logger logger = this.myLogService.getLogger(EnergyDataPoller.class);
        if (logger == null) {
            EnergyDataPoller.$$$reportNull$$$0(10);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batteryModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "networkService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "energyService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/poller/EnergyDataPoller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/poller/EnergyDataPoller";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLatestEvents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLatestSamples";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

