/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import org.jetbrains.annotations.NotNull;

public class MemoryJvmtiDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myPollingService;
    private final MemoryLiveAllocationTable myLiveAllocationTable;
    private final Common.Session mySession;

    public MemoryJvmtiDataPoller(@NotNull Common.Session session, @NotNull MemoryLiveAllocationTable liveAllocationTable, @NotNull MemoryServiceGrpc.MemoryServiceBlockingStub pollingService) {
        if (session == null) {
            MemoryJvmtiDataPoller.$$$reportNull$$$0(0);
        }
        if (liveAllocationTable == null) {
            MemoryJvmtiDataPoller.$$$reportNull$$$0(1);
        }
        if (pollingService == null) {
            MemoryJvmtiDataPoller.$$$reportNull$$$0(2);
        }
        super(POLLING_DELAY_NS);
        this.myDataRequestStartTimestampNs = Long.MIN_VALUE;
        this.mySession = session;
        this.myLiveAllocationTable = liveAllocationTable;
        this.myPollingService = pollingService;
    }

    @Override
    public void poll() {
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(this.myDataRequestStartTimestampNs).setEndTime(Long.MAX_VALUE);
        MemoryProfiler.MemoryData response = this.myPollingService.getJvmtiData(dataRequestBuilder.build());
        for (MemoryProfiler.BatchAllocationSample sample : response.getAllocationSamplesList()) {
            this.myLiveAllocationTable.insertMethodInfo(this.mySession, sample.getMethodsList());
            this.myLiveAllocationTable.insertStackInfo(this.mySession, sample.getStacksList());
            this.myLiveAllocationTable.insertThreadInfo(this.mySession, sample.getThreadInfosList());
            this.myLiveAllocationTable.insertAllocationData(this.mySession, sample);
        }
        for (MemoryProfiler.BatchJNIGlobalRefEvent batchJniEvent : response.getJniReferenceEventBatchesList()) {
            this.myLiveAllocationTable.insertThreadInfo(this.mySession, batchJniEvent.getThreadInfosList());
            this.myLiveAllocationTable.insertJniReferenceData(this.mySession, batchJniEvent);
        }
        if (response.getEndTimestamp() > this.myDataRequestStartTimestampNs) {
            this.myDataRequestStartTimestampNs = response.getEndTimestamp();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "liveAllocationTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pollingService";
                break;
            }
        }
        objectArray[1] = "com/android/tools/datastore/poller/MemoryJvmtiDataPoller";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

