/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.DeviceId;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.database.MemoryStatsTable;
import com.android.tools.datastore.database.ProfilerTable;
import com.android.tools.datastore.poller.MemoryDataPoller;
import com.android.tools.datastore.poller.MemoryJvmtiDataPoller;
import com.android.tools.datastore.poller.NativeSymbolsPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MemoryService
extends MemoryServiceGrpc.MemoryServiceImplBase
implements ServicePassThrough {
    private static final DataStoreService.BackingNamespace LIVE_ALLOCATION_NAMESPACE = new DataStoreService.BackingNamespace("LiveAllocations", DataStoreDatabase.Characteristic.PERFORMANT);
    private final Map<Long, PollRunner> myRunners;
    private final Map<Long, PollRunner> myJvmtiRunners;
    private final Map<Long, PollRunner> mySymbolizationRunners;
    private final MemoryStatsTable myStatsTable;
    private final MemoryLiveAllocationTable myAllocationsTable;
    private final ProfilerTable myProfilerTable;
    private final Consumer<Runnable> myFetchExecutor;
    private final DataStoreService myService;
    private final LogService myLogService;

    public MemoryService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        if (dataStoreService == null) {
            MemoryService.$$$reportNull$$$0(0);
        }
        if (logService == null) {
            MemoryService.$$$reportNull$$$0(1);
        }
        this.myRunners = new HashMap<Long, PollRunner>();
        this.myJvmtiRunners = new HashMap<Long, PollRunner>();
        this.mySymbolizationRunners = new HashMap<Long, PollRunner>();
        this.myLogService = logService;
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myStatsTable = new MemoryStatsTable();
        this.myAllocationsTable = new MemoryLiveAllocationTable(this.myLogService);
        this.myProfilerTable = new ProfilerTable();
    }

    public void startMonitoringApp(MemoryProfiler.MemoryStartRequest request, StreamObserver<MemoryProfiler.MemoryStartResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(DeviceId.fromSession(request.getSession()));
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            Common.Session session = request.getSession();
            long sessionId = session.getSessionId();
            this.myJvmtiRunners.put(sessionId, new MemoryJvmtiDataPoller(session, this.myAllocationsTable, client));
            this.myRunners.put(sessionId, new MemoryDataPoller(session, this.myStatsTable, client, this.myFetchExecutor));
            this.mySymbolizationRunners.put(sessionId, new NativeSymbolsPoller(session, this.myAllocationsTable, this.myProfilerTable, this.myService.getNativeSymbolizer(), this.myLogService));
            this.myFetchExecutor.accept(this.mySymbolizationRunners.get(sessionId));
            this.myFetchExecutor.accept(this.myJvmtiRunners.get(sessionId));
            this.myFetchExecutor.accept(this.myRunners.get(sessionId));
        } else {
            observer.onNext((Object)MemoryProfiler.MemoryStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(MemoryProfiler.MemoryStopRequest request, StreamObserver<MemoryProfiler.MemoryStopResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub service;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((runner = this.myJvmtiRunners.remove(sessionId)) != null) {
            runner.stop();
        }
        if ((runner = this.mySymbolizationRunners.remove(sessionId)) != null) {
            runner.stop();
        }
        if ((service = this.myService.getMemoryClient(DeviceId.fromSession(request.getSession()))) == null) {
            observer.onNext((Object)MemoryProfiler.MemoryStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)service.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    public void triggerHeapDump(MemoryProfiler.TriggerHeapDumpRequest request, StreamObserver<MemoryProfiler.TriggerHeapDumpResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(DeviceId.fromSession(request.getSession()));
        MemoryProfiler.TriggerHeapDumpResponse response = MemoryProfiler.TriggerHeapDumpResponse.getDefaultInstance();
        if (client != null && (response = client.triggerHeapDump(request)).getStatus() == MemoryProfiler.TriggerHeapDumpResponse.Status.SUCCESS) {
            assert (response.getInfo() != null);
            this.myStatsTable.insertOrReplaceHeapInfo(request.getSession(), response.getInfo());
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getHeapDump(MemoryProfiler.DumpDataRequest request, StreamObserver<MemoryProfiler.DumpDataResponse> responseObserver) {
        MemoryProfiler.DumpDataResponse.Builder responseBuilder = MemoryProfiler.DumpDataResponse.newBuilder();
        MemoryProfiler.DumpDataResponse.Status status = this.myStatsTable.getHeapDumpStatus(request.getSession(), request.getDumpTime());
        switch (status) {
            case SUCCESS: {
                byte[] data = this.myStatsTable.getHeapDumpData(request.getSession(), request.getDumpTime());
                assert (data != null);
                responseBuilder.setData(ByteString.copyFrom((byte[])data));
                responseBuilder.setStatus(status);
                break;
            }
            case NOT_READY: 
            case FAILURE_UNKNOWN: 
            case NOT_FOUND: {
                responseBuilder.setStatus(status);
                break;
            }
            default: {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
            }
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest request, StreamObserver<MemoryProfiler.ListHeapDumpInfosResponse> responseObserver) {
        MemoryProfiler.ListHeapDumpInfosResponse.Builder responseBuilder = MemoryProfiler.ListHeapDumpInfosResponse.newBuilder();
        List<MemoryProfiler.HeapDumpInfo> dump = this.myStatsTable.getHeapDumpInfoByRequest(request.getSession(), request);
        responseBuilder.addAllInfos(dump);
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void importHeapDump(MemoryProfiler.ImportHeapDumpRequest request, StreamObserver<MemoryProfiler.ImportHeapDumpResponse> responseObserver) {
        MemoryProfiler.ImportHeapDumpResponse.Builder responseBuilder = MemoryProfiler.ImportHeapDumpResponse.newBuilder();
        this.myStatsTable.insertOrReplaceHeapInfo(request.getSession(), request.getInfo());
        this.myStatsTable.insertHeapDumpData(request.getSession(), request.getInfo().getStartTime(), MemoryProfiler.DumpDataResponse.Status.SUCCESS, request.getData());
        responseBuilder.setStatus(MemoryProfiler.ImportHeapDumpResponse.Status.SUCCESS);
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void trackAllocations(MemoryProfiler.TrackAllocationsRequest request, StreamObserver<MemoryProfiler.TrackAllocationsResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(DeviceId.fromSession(request.getSession()));
        MemoryProfiler.TrackAllocationsResponse response = MemoryProfiler.TrackAllocationsResponse.getDefaultInstance();
        if (client != null) {
            response = client.trackAllocations(request);
            if (request.getEnabled() && response.getStatus() == MemoryProfiler.TrackAllocationsResponse.Status.SUCCESS) {
                assert (response.getInfo() != null);
                this.myStatsTable.insertOrReplaceAllocationsInfo(request.getSession(), response.getInfo());
            }
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationContexts(MemoryProfiler.LegacyAllocationContextsRequest request, StreamObserver<MemoryProfiler.AllocationContextsResponse> responseObserver) {
        responseObserver.onNext((Object)this.myStatsTable.getLegacyAllocationContexts(request));
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationDump(MemoryProfiler.DumpDataRequest request, StreamObserver<MemoryProfiler.DumpDataResponse> responseObserver) {
        MemoryProfiler.DumpDataResponse.Builder responseBuilder = MemoryProfiler.DumpDataResponse.newBuilder();
        MemoryProfiler.AllocationsInfo response = this.myStatsTable.getAllocationsInfo(request.getSession(), request.getDumpTime());
        if (response == null) {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.NOT_FOUND);
        } else if (response.getStatus() == MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN) {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
        } else if (response.getLegacy()) {
            byte[] data = this.myStatsTable.getLegacyAllocationDumpData(request.getSession(), request.getDumpTime());
            if (data == null) {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.NOT_READY);
            } else {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.SUCCESS);
                responseBuilder.setData(ByteString.copyFrom((byte[])data));
            }
        } else {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void getStackFrameInfo(MemoryProfiler.StackFrameInfoRequest request, StreamObserver<MemoryProfiler.StackFrameInfoResponse> responseObserver) {
        responseObserver.onNext((Object)this.myAllocationsTable.getStackFrameInfo(request.getSession(), request.getMethodId()));
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationEvents(MemoryProfiler.LegacyAllocationEventsRequest request, StreamObserver<MemoryProfiler.LegacyAllocationEventsResponse> responseObserver) {
        MemoryProfiler.LegacyAllocationEventsResponse.Builder builder = MemoryProfiler.LegacyAllocationEventsResponse.newBuilder();
        MemoryProfiler.AllocationsInfo response = this.myStatsTable.getAllocationsInfo(request.getSession(), request.getStartTime());
        if (response == null) {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_FOUND);
        } else if (response.getStatus() == MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN) {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN);
        } else if (response.getLegacy()) {
            MemoryProfiler.LegacyAllocationEventsResponse events = this.myStatsTable.getLegacyAllocationData(request.getSession(), request.getStartTime());
            if (events == null) {
                builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_READY);
            } else {
                builder.mergeFrom(events);
            }
        } else {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void getData(MemoryProfiler.MemoryRequest request, StreamObserver<MemoryProfiler.MemoryData> responseObserver) {
        MemoryProfiler.MemoryData response = this.myStatsTable.getData(request);
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getAllocations(MemoryProfiler.AllocationSnapshotRequest request, StreamObserver<MemoryProfiler.BatchAllocationSample> responseObserver) {
        MemoryProfiler.BatchAllocationSample response = request.getLiveObjectsOnly() ? this.myAllocationsTable.getSnapshot(request.getSession(), request.getEndTime()) : this.myAllocationsTable.getAllocations(request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getJNIGlobalRefsEvents(MemoryProfiler.JNIGlobalRefsEventsRequest request, StreamObserver<MemoryProfiler.BatchJNIGlobalRefEvent> responseObserver) {
        MemoryProfiler.BatchJNIGlobalRefEvent result = request.getLiveObjectsOnly() ? this.myAllocationsTable.getJniReferencesSnapshot(request.getSession(), request.getEndTime()) : this.myAllocationsTable.getJniReferencesEventsFromRange(request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)result);
        responseObserver.onCompleted();
    }

    public void resolveNativeBacktrace(MemoryProfiler.ResolveNativeBacktraceRequest request, StreamObserver<MemoryProfiler.NativeCallStack> responseObserver) {
        MemoryProfiler.NativeCallStack callStack = this.myAllocationsTable.resolveNativeBacktrace(request.getSession(), request.getBacktrace());
        responseObserver.onNext((Object)callStack);
        responseObserver.onCompleted();
    }

    public void getLatestAllocationTime(MemoryProfiler.LatestAllocationTimeRequest request, StreamObserver<MemoryProfiler.LatestAllocationTimeResponse> responseObserver) {
        MemoryProfiler.LatestAllocationTimeResponse response = this.myAllocationsTable.getLatestDataTimestamp(request.getSession());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getAllocationContexts(MemoryProfiler.AllocationContextsRequest request, StreamObserver<MemoryProfiler.AllocationContextsResponse> responseObserver) {
        MemoryProfiler.AllocationContextsResponse response = this.myAllocationsTable.getAllocationContexts(request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest request, StreamObserver<MemoryProfiler.ForceGarbageCollectionResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(DeviceId.fromSession(request.getSession()));
        if (client != null) {
            observer.onNext((Object)client.forceGarbageCollection(request));
        } else {
            observer.onNext((Object)MemoryProfiler.ForceGarbageCollectionResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Arrays.asList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE, LIVE_ALLOCATION_NAMESPACE);
        if (list == null) {
            MemoryService.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            MemoryService.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            MemoryService.$$$reportNull$$$0(4);
        }
        assert (this.getBackingNamespaces().contains(namespace));
        if (namespace.equals(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE)) {
            this.myStatsTable.initialize(connection);
            this.myProfilerTable.initializeConnectionOnly(connection);
        } else {
            this.myAllocationsTable.initialize(connection);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/MemoryService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/MemoryService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

