/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.DeviceId;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.ProfilerTable;
import com.android.tools.datastore.poller.ProfilerDevicePoller;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.google.common.collect.Maps;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ProfilerService
extends ProfilerServiceGrpc.ProfilerServiceImplBase
implements ServicePassThrough {
    private final Map<Channel, ProfilerDevicePoller> myPollers;
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final LogService myLogService;
    private final ProfilerTable myTable;
    @NotNull
    private final DataStoreService myService;

    public ProfilerService(@NotNull DataStoreService service, Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        if (service == null) {
            ProfilerService.$$$reportNull$$$0(0);
        }
        if (logService == null) {
            ProfilerService.$$$reportNull$$$0(1);
        }
        this.myPollers = Maps.newHashMap();
        this.myService = service;
        this.myFetchExecutor = fetchExecutor;
        this.myLogService = logService;
        this.myTable = new ProfilerTable();
    }

    @NotNull
    private LogService.Logger getLogger() {
        LogService.Logger logger = this.myLogService.getLogger(ProfilerService.class);
        if (logger == null) {
            ProfilerService.$$$reportNull$$$0(2);
        }
        return logger;
    }

    public void getCurrentTime(Profiler.TimeRequest request, StreamObserver<Profiler.TimeResponse> observer) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(DeviceId.of(request.getDeviceId()));
        if (client != null) {
            observer.onNext((Object)client.getCurrentTime(request));
        } else {
            observer.onNext((Object)Profiler.TimeResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void getVersion(Profiler.VersionRequest request, StreamObserver<Profiler.VersionResponse> observer) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(DeviceId.of(request.getDeviceId()));
        if (client != null) {
            observer.onNext((Object)client.getVersion(request));
        }
        observer.onCompleted();
    }

    public void getDevices(Profiler.GetDevicesRequest request, StreamObserver<Profiler.GetDevicesResponse> observer) {
        Profiler.GetDevicesResponse response = this.myTable.getDevices();
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getProcesses(Profiler.GetProcessesRequest request, StreamObserver<Profiler.GetProcessesResponse> observer) {
        Profiler.GetProcessesResponse response = this.myTable.getProcesses(request);
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getAgentStatus(Profiler.AgentStatusRequest request, StreamObserver<Profiler.AgentStatusResponse> observer) {
        observer.onNext((Object)this.myTable.getAgentStatus(request));
        observer.onCompleted();
    }

    public void configureStartupAgent(Profiler.ConfigureStartupAgentRequest request, StreamObserver<Profiler.ConfigureStartupAgentResponse> observer) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(DeviceId.of(request.getDeviceId()));
        if (client != null) {
            observer.onNext((Object)client.configureStartupAgent(request));
        } else {
            observer.onNext((Object)Profiler.ConfigureStartupAgentResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void beginSession(Profiler.BeginSessionRequest request, StreamObserver<Profiler.BeginSessionResponse> responseObserver) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(DeviceId.of(request.getDeviceId()));
        if (client == null) {
            responseObserver.onNext((Object)Profiler.BeginSessionResponse.getDefaultInstance());
        } else {
            Profiler.BeginSessionResponse response = client.beginSession(request);
            this.getLogger().info("Session (ID " + response.getSession().getSessionId() + ") begins.");
            this.myTable.insertOrUpdateSession(response.getSession(), request.getSessionName(), request.getRequestTimeEpochMs(), request.getJvmtiConfig().getAttachAgent(), request.getJvmtiConfig().getLiveAllocationEnabled(), Common.SessionMetaData.SessionType.FULL);
            responseObserver.onNext((Object)response);
        }
        responseObserver.onCompleted();
    }

    public void endSession(Profiler.EndSessionRequest request, StreamObserver<Profiler.EndSessionResponse> responseObserver) {
        this.getLogger().info("Session (ID " + request.getSessionId() + ") ends.");
        DeviceId deviceId = DeviceId.of(request.getDeviceId());
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(deviceId);
        if (client == null) {
            long timeNs = this.myTable.getDeviceLastKnownTime(deviceId);
            this.myTable.updateSessionEndTime(request.getSessionId(), timeNs);
            Common.Session session = this.myTable.getSessionById(request.getSessionId());
            responseObserver.onNext((Object)Profiler.EndSessionResponse.newBuilder().setSession(session).build());
        } else {
            Profiler.EndSessionResponse response = client.endSession(request);
            Common.Session session = response.getSession();
            this.myTable.updateSessionEndTime(session.getSessionId(), session.getEndTimestamp());
            responseObserver.onNext((Object)response);
        }
        responseObserver.onCompleted();
    }

    public void getSessionMetaData(Profiler.GetSessionMetaDataRequest request, StreamObserver<Profiler.GetSessionMetaDataResponse> responseObserver) {
        responseObserver.onNext((Object)this.myTable.getSessionMetaData(request.getSessionId()));
        responseObserver.onCompleted();
    }

    public void getSessions(Profiler.GetSessionsRequest request, StreamObserver<Profiler.GetSessionsResponse> responseObserver) {
        responseObserver.onNext((Object)this.myTable.getSessions());
        responseObserver.onCompleted();
    }

    public void deleteSession(Profiler.DeleteSessionRequest request, StreamObserver<Profiler.DeleteSessionResponse> responseObserver) {
        this.myTable.deleteSession(request.getSessionId());
        responseObserver.onNext((Object)Profiler.DeleteSessionResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void importSession(Profiler.ImportSessionRequest request, StreamObserver<Profiler.ImportSessionResponse> responseObserver) {
        this.myTable.insertOrUpdateSession(request.getSession(), request.getSessionName(), request.getStartTimestampEpochMs(), false, false, request.getSessionType());
        responseObserver.onNext((Object)Profiler.ImportSessionResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void startMonitoring(Channel channel) {
        assert (!this.myPollers.containsKey(channel));
        ProfilerServiceGrpc.ProfilerServiceBlockingStub stub = ProfilerServiceGrpc.newBlockingStub((Channel)channel);
        ProfilerDevicePoller poller = new ProfilerDevicePoller(this.myService, this.myTable, stub);
        this.myPollers.put(channel, poller);
        DataStoreTable.addDataStoreErrorCallback(poller);
        this.myFetchExecutor.accept(this.myPollers.get(channel));
    }

    public void stopMonitoring(Channel channel) {
        if (this.myPollers.containsKey(channel)) {
            ProfilerDevicePoller poller = this.myPollers.remove(channel);
            poller.stop();
            DataStoreTable.removeDataStoreErrorCallback(poller);
        }
    }

    public void getBytes(Profiler.BytesRequest request, StreamObserver<Profiler.BytesResponse> responseObserver) {
        Profiler.BytesResponse response = this.myTable.getBytes(request);
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(DeviceId.fromSession(request.getSession()));
        if (response == null && client != null) {
            response = this.myService.getProfilerClient(DeviceId.fromSession(request.getSession())).getBytes(request);
            this.myTable.insertOrUpdateBytes(request.getId(), request.getSession(), response);
        } else if (response == null) {
            response = Profiler.BytesResponse.getDefaultInstance();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            ProfilerService.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            ProfilerService.$$$reportNull$$$0(4);
        }
        if (connection == null) {
            ProfilerService.$$$reportNull$$$0(5);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myTable.initialize(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/ProfilerService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/ProfilerService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

