/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class HoverRowTable
extends JBTable {
    private int myHoveredRow;
    private final Color myHoverColor;

    public HoverRowTable(@NotNull TableModel model, @NotNull Color hoverColor) {
        if (model == null) {
            HoverRowTable.$$$reportNull$$$0(0);
        }
        if (hoverColor == null) {
            HoverRowTable.$$$reportNull$$$0(1);
        }
        super(model);
        this.myHoveredRow = -1;
        this.myHoverColor = hoverColor;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(HoverRowTable.this.rowAtPoint(e.getPoint()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(-1);
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.getEmptyText().clear();
        this.setIntercellSpacing(new Dimension());
    }

    private void hoveredRowChanged(int row) {
        if (row == this.myHoveredRow) {
            return;
        }
        this.myHoveredRow = row;
        this.repaint();
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        Component comp;
        if (renderer == null) {
            HoverRowTable.$$$reportNull$$$0(2);
        }
        Component toChangeComp = comp = super.prepareRenderer(renderer, row, column);
        if (comp instanceof ExpandedItemRendererComponentWrapper) {
            toChangeComp = ((ExpandedItemRendererComponentWrapper)comp).getComponent(0);
        }
        if (this.getRowSelectionAllowed() && this.isRowSelected(row)) {
            toChangeComp.setForeground(this.getSelectionForeground());
            toChangeComp.setBackground(this.getSelectionBackground());
        } else if (row == this.myHoveredRow) {
            toChangeComp.setBackground(this.myHoverColor);
            toChangeComp.setForeground(this.getForeground());
        } else {
            toChangeComp.setBackground(this.getBackground());
            toChangeComp.setForeground(this.getForeground());
        }
        Component component = comp;
        if (component == null) {
            HoverRowTable.$$$reportNull$$$0(3);
        }
        return component;
    }

    public void paint(@NotNull Graphics g) {
        if (g == null) {
            HoverRowTable.$$$reportNull$$$0(4);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, UIUtil.getLcdContrastValue());
        }
        super.paint(g);
        if (this.isEmpty() && !StringUtil.isEmpty((String)this.getEmptyText().getText())) {
            return;
        }
        TableColumnModel columnModel = this.getColumnModel();
        ArrayList<Integer> columnX = new ArrayList<Integer>();
        int x2 = 0;
        for (int index = 0; index < columnModel.getColumnCount() - 1; ++index) {
            int column = this.getComponentOrientation().isLeftToRight() ? index : columnModel.getColumnCount() - 1 - index;
            columnX.add((x2 += columnModel.getColumn(column).getWidth()) - 1);
        }
        g.setColor(this.getGridColor());
        int lastRowBottom = this.getRowCount() * this.getRowHeight();
        columnX.forEach(x -> {
            if (g == null) {
                HoverRowTable.$$$reportNull$$$0(6);
            }
            g.drawLine((int)x, lastRowBottom, (int)x, this.getHeight());
        });
        if (this.getSelectedRow() != -1 && this.getCellSelectionEnabled()) {
            g.setColor(AdtUiUtils.overlayColor((int)this.getSelectionBackground().getRGB(), (int)this.getGridColor().getRGB(), (float)0.25f));
            Rectangle selectedRowRect = this.getCellRect(this.getSelectedRow(), 0, true);
            columnX.forEach(x -> {
                if (g == null) {
                    HoverRowTable.$$$reportNull$$$0(5);
                }
                g.drawLine((int)x, selectedRowRect.y, (int)x, selectedRowRect.y + selectedRowRect.height - 1);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hoverColor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/HoverRowTable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/HoverRowTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$paint$1";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$paint$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

