/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.FpsTimer;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.energy.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.event.EventProfiler;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.network.NetworkProfiler;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.text.StringUtil;
import io.grpc.StatusRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProfilers
extends AspectModel<ProfilerAspect>
implements Updatable {
    public static final int PROFILERS_UPDATE_RATE = 60;
    @Nullable
    private final ProfilerClient myClient;
    private final ProfilerTimeline myTimeline;
    private final List<StudioProfiler> myProfilers;
    @NotNull
    private final IdeProfilerServices myIdeServices;
    private Map<Common.Device, List<Common.Process>> myProcesses;
    @NotNull
    private final SessionsManager mySessionsManager;
    @Nullable
    private Common.Process myProcess;
    @NotNull
    private Profiler.AgentStatusResponse myAgentStatus;
    @Nullable
    private String myPreferredDeviceName;
    @Nullable
    private String myPreferredProcessName;
    private Predicate<Common.Process> myPreferredProcessFilter;
    private Common.Device myDevice;
    @NotNull
    private Common.Session mySelectedSession;
    @NotNull
    private Common.Session myProfilingSession;
    @NotNull
    private Stage myStage;
    private Updater myUpdater;
    private AxisComponentModel myViewAxis;
    private long myRefreshDevices;
    private final Map<Common.SessionMetaData.SessionType, Runnable> mySessionChangeListener;
    private boolean myAutoProfilingEnabled;

    public StudioProfilers(@Nullable ProfilerClient client, @NotNull IdeProfilerServices ideServices) {
        if (ideServices == null) {
            StudioProfilers.$$$reportNull$$$0(0);
        }
        this(client, ideServices, (StopwatchTimer)new FpsTimer(60));
    }

    @VisibleForTesting
    public StudioProfilers(@Nullable ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull StopwatchTimer timer) {
        if (ideServices == null) {
            StudioProfilers.$$$reportNull$$$0(1);
        }
        if (timer == null) {
            StudioProfilers.$$$reportNull$$$0(2);
        }
        this.myAutoProfilingEnabled = true;
        this.myClient = client;
        this.myIdeServices = ideServices;
        this.myPreferredProcessName = null;
        this.myPreferredProcessFilter = null;
        this.myStage = new NullMonitorStage(this);
        this.mySessionsManager = new SessionsManager(this);
        this.mySessionChangeListener = new HashMap<Common.SessionMetaData.SessionType, Runnable>();
        this.myStage.enter();
        this.myUpdater = new Updater(timer);
        ImmutableList.Builder profilersBuilder = new ImmutableList.Builder();
        profilersBuilder.add((Object)new EventProfiler(this));
        profilersBuilder.add((Object)new CpuProfiler(this));
        profilersBuilder.add((Object)new MemoryProfiler(this));
        profilersBuilder.add((Object)new NetworkProfiler(this));
        if (this.myIdeServices.getFeatureConfig().isEnergyProfilerEnabled()) {
            profilersBuilder.add((Object)new EnergyProfiler(this));
        }
        this.myProfilers = profilersBuilder.build();
        this.myTimeline = new ProfilerTimeline(this.myUpdater);
        this.myProcesses = Maps.newHashMap();
        this.myDevice = null;
        this.myProcess = null;
        this.mySelectedSession = this.myProfilingSession = Common.Session.getDefaultInstance();
        this.myAgentStatus = Profiler.AgentStatusResponse.getDefaultInstance();
        if (this.myClient != null) {
            this.myTimeline.getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> {
                if (!this.myTimeline.getSelectionRange().isEmpty()) {
                    this.myTimeline.setStreaming(false);
                }
            });
            this.registerSessionChangeListener(Common.SessionMetaData.SessionType.FULL, () -> {
                this.setStage(new StudioMonitorStage(this));
                if (SessionsManager.isSessionAlive(this.mySelectedSession)) {
                    Profiler.TimeResponse timeResponse = this.myClient.getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(this.mySelectedSession.getDeviceId()).build());
                    this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), timeResponse.getTimestampNs());
                    if (this.startupCpuProfilingStarted()) {
                        this.setStage(new CpuProfilerStage(this));
                    }
                } else {
                    this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), this.mySelectedSession.getEndTimestamp());
                    this.myTimeline.setIsPaused(true);
                    this.myTimeline.setStreaming(false);
                    this.myTimeline.getViewRange().set(this.mySessionsManager.getSessionPreferredViewRange(this.mySelectedSession));
                }
            });
            this.mySessionsManager.addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::selectedSessionChanged).onChange((Enum)SessionAspect.PROFILING_SESSION, this::profilingSessionChanged);
            this.myViewAxis = new ResizingAxisComponentModel.Builder(this.myTimeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).setGlobalRange(this.myTimeline.getDataRange()).build();
            this.myUpdater.register((Updatable)this);
        }
    }

    public boolean isStopped() {
        return !this.myUpdater.isRunning();
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.myUpdater.stop();
        this.setDevice(null);
        this.changed(ProfilerAspect.STAGE);
    }

    public Map<Common.Device, List<Common.Process>> getDeviceProcessMap() {
        return this.myProcesses;
    }

    public List<Common.Device> getDevices() {
        return Lists.newArrayList(this.myProcesses.keySet());
    }

    public void setPreferredProcess(@Nullable String deviceName, @NotNull String processName, @Nullable Predicate<Common.Process> processFilter) {
        if (processName == null) {
            StudioProfilers.$$$reportNull$$$0(3);
        }
        this.myPreferredDeviceName = deviceName;
        this.myPreferredProcessName = processName;
        this.myPreferredProcessFilter = processFilter;
        this.myAutoProfilingEnabled = true;
        this.setDevice(this.findPreferredDevice());
        this.setProcess(null);
    }

    @Nullable
    public String getPreferredProcessName() {
        return this.myPreferredProcessName;
    }

    public void setAutoProfilingEnabled(boolean enabled) {
        this.myAutoProfilingEnabled = enabled;
        if (this.myAutoProfilingEnabled) {
            this.setDevice(this.findPreferredDevice());
            this.setProcess(null);
        }
    }

    public boolean getAutoProfilingEnabled() {
        return this.myAutoProfilingEnabled;
    }

    public void update(long elapsedNs) {
        this.myRefreshDevices += elapsedNs;
        if (this.myRefreshDevices < TimeUnit.SECONDS.toNanos(1L)) {
            return;
        }
        this.myRefreshDevices = 0L;
        try {
            Profiler.AgentStatusResponse agentStatus;
            Profiler.GetDevicesResponse response = this.myClient.getProfilerClient().getDevices(Profiler.GetDevicesRequest.getDefaultInstance());
            HashSet devices = new HashSet(response.getDeviceList());
            HashMap<Common.Device, List<Common.Process>> newProcesses = new HashMap<Common.Device, List<Common.Process>>();
            for (Common.Device device : devices) {
                Profiler.GetProcessesRequest request = Profiler.GetProcessesRequest.newBuilder().setDeviceId(device.getDeviceId()).build();
                Profiler.GetProcessesResponse processes = this.myClient.getProfilerClient().getProcesses(request);
                int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                List processList = processes.getProcessList().stream().filter(process -> process.getState() == Common.Process.State.ALIVE || process.getPid() == lastProcessId).collect(Collectors.toList());
                newProcesses.put(device, processList);
            }
            if (!newProcesses.equals(this.myProcesses)) {
                this.myProcesses = newProcesses;
                this.setDevice(this.findPreferredDevice());
                this.setProcess(null);
                this.changed(ProfilerAspect.DEVICES);
                this.changed(ProfilerAspect.PROCESSES);
            }
            this.mySessionsManager.update();
            if (SessionsManager.isSessionAlive(this.mySelectedSession) && !this.myAgentStatus.equals((Object)(agentStatus = this.getAgentStatus(this.mySelectedSession)))) {
                if (this.myAgentStatus.getStatus() != Profiler.AgentStatusResponse.Status.ATTACHED && agentStatus.getStatus() == Profiler.AgentStatusResponse.Status.ATTACHED) {
                    this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                }
                this.myAgentStatus = agentStatus;
                this.changed(ProfilerAspect.AGENT);
            }
        }
        catch (StatusRuntimeException e) {
            System.err.println("Cannot find profiler service, retrying...");
        }
    }

    @Nullable
    private Common.Device findPreferredDevice() {
        Set<Common.Device> devices = this.myProcesses.keySet();
        Set onlineDevices = devices.stream().filter(device -> device.getState().equals((Object)Common.Device.State.ONLINE)).collect(Collectors.toSet());
        if (this.myAutoProfilingEnabled && this.myPreferredDeviceName != null) {
            for (Common.Device device2 : onlineDevices) {
                if (!this.myPreferredDeviceName.equals(StudioProfilers.buildDeviceName(device2))) continue;
                return device2;
            }
        }
        if (this.myDevice != null) {
            for (Common.Device device2 : devices) {
                if (this.myDevice.getDeviceId() != device2.getDeviceId()) continue;
                return device2;
            }
        }
        return null;
    }

    public void setDevice(@Nullable Common.Device device) {
        if (device != null) {
            this.myPreferredDeviceName = null;
        }
        if (!Objects.equals(device, this.myDevice)) {
            this.mySessionsManager.endCurrentSession();
            this.myDevice = device;
            this.changed(ProfilerAspect.DEVICES);
            this.setProcess(null);
        }
    }

    public void setMonitoringStage() {
        this.setStage(new StudioMonitorStage(this));
    }

    public void setProcess(@Nullable Common.Process process) {
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        if (process == null || processes == null || !processes.contains(process)) {
            process = this.getPreferredProcess(processes);
        } else {
            this.myAutoProfilingEnabled = false;
        }
        if (process == null || !Objects.equals(process, this.myProcess)) {
            this.mySessionsManager.endCurrentSession();
            this.myProcess = process;
            this.changed(ProfilerAspect.PROCESSES);
            if (this.myDevice != null) {
                this.mySessionsManager.beginSession(this.myDevice, this.myProcess);
            }
        }
    }

    public void registerSessionChangeListener(Common.SessionMetaData.SessionType sessionType, Runnable listener) {
        this.mySessionChangeListener.put(sessionType, listener);
    }

    private void selectedSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getSelectedSession();
        if (this.mySelectedSession.getSessionId() == newSession.getSessionId() && SessionsManager.isSessionAlive(this.mySelectedSession) && !SessionsManager.isSessionAlive(newSession)) {
            this.mySelectedSession = newSession;
            this.myTimeline.setIsPaused(true);
            return;
        }
        this.mySelectedSession = newSession;
        this.myAgentStatus = this.getAgentStatus(this.mySelectedSession);
        if (Common.Session.getDefaultInstance().equals((Object)newSession)) {
            this.myTimeline.setIsPaused(true);
            this.setStage(new NullMonitorStage(this));
            return;
        }
        Common.SessionMetaData.SessionType sessionType = this.mySessionsManager.getSelectedSessionMetaData().getType();
        assert (this.mySessionChangeListener.containsKey(sessionType));
        this.mySessionChangeListener.get(sessionType).run();
        this.changed(ProfilerAspect.AGENT);
    }

    private void profilingSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getProfilingSession();
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.stopProfiling(this.myProfilingSession));
        }
        this.myProfilingSession = newSession;
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.startProfiling(this.myProfilingSession));
            this.myIdeServices.getFeatureTracker().trackProfilingStarted();
            if (this.getAgentStatus(this.myProfilingSession).getStatus() == Profiler.AgentStatusResponse.Status.ATTACHED) {
                this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
            }
        }
    }

    private boolean startupCpuProfilingStarted() {
        if (!this.getIdeServices().getFeatureConfig().isStartupCpuProfilingEnabled()) {
            return false;
        }
        CpuProfiler.ProfilingStateResponse response = this.getClient().getCpuClient().checkAppProfilingState(CpuProfiler.ProfilingStateRequest.newBuilder().setSession(this.mySelectedSession).build());
        return response.getBeingProfiled() && response.getIsStartupProfiling();
    }

    @Nullable
    private Common.Process getPreferredProcess(List<Common.Process> processes) {
        if (processes == null || processes.isEmpty()) {
            return null;
        }
        if (this.myAutoProfilingEnabled && this.myPreferredProcessName != null) {
            for (Common.Process process : processes) {
                if (!process.getName().equals(this.myPreferredProcessName) || process.getState() != Common.Process.State.ALIVE || this.myPreferredProcessFilter != null && !this.myPreferredProcessFilter.test(process)) continue;
                return process;
            }
        }
        if (this.myProcess != null) {
            for (Common.Process process : processes) {
                if (!StudioProfilers.isSameProcess(this.myProcess, process) || this.myProcess.getState() != process.getState() && (this.myProcess.getState() != Common.Process.State.ALIVE || process.getState() != Common.Process.State.DEAD)) continue;
                return process;
            }
        }
        return null;
    }

    @NotNull
    private Profiler.AgentStatusResponse getAgentStatus(@NotNull Common.Session session) {
        if (session == null) {
            StudioProfilers.$$$reportNull$$$0(4);
        }
        if (Common.Session.getDefaultInstance().equals((Object)session)) {
            Profiler.AgentStatusResponse agentStatusResponse = Profiler.AgentStatusResponse.getDefaultInstance();
            if (agentStatusResponse == null) {
                StudioProfilers.$$$reportNull$$$0(5);
            }
            return agentStatusResponse;
        }
        Profiler.AgentStatusRequest statusRequest = Profiler.AgentStatusRequest.newBuilder().setPid(session.getPid()).setDeviceId(session.getDeviceId()).build();
        Profiler.AgentStatusResponse agentStatusResponse = this.myClient.getProfilerClient().getAgentStatus(statusRequest);
        if (agentStatusResponse == null) {
            StudioProfilers.$$$reportNull$$$0(6);
        }
        return agentStatusResponse;
    }

    private static boolean isSameProcess(@Nullable Common.Process process1, @Nullable Common.Process process2) {
        return process1 != null && process2 != null && process1.getPid() == process2.getPid() && process1.getName().equals(process2.getName()) && process1.getStartTimestampNs() == process2.getStartTimestampNs();
    }

    public List<Common.Process> getProcesses() {
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        return processes == null ? ImmutableList.of() : processes;
    }

    @NotNull
    public Stage getStage() {
        Stage stage = this.myStage;
        if (stage == null) {
            StudioProfilers.$$$reportNull$$$0(7);
        }
        return stage;
    }

    @Nullable
    public ProfilerClient getClient() {
        return this.myClient;
    }

    @NotNull
    public SessionsManager getSessionsManager() {
        SessionsManager sessionsManager = this.mySessionsManager;
        if (sessionsManager == null) {
            StudioProfilers.$$$reportNull$$$0(8);
        }
        return sessionsManager;
    }

    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySelectedSession;
        if (session == null) {
            StudioProfilers.$$$reportNull$$$0(9);
        }
        return session;
    }

    @NotNull
    public String getSelectedAppName() {
        String name = "";
        if (!this.getSession().equals((Object)Common.Session.getDefaultInstance())) {
            name = this.mySessionsManager.getSelectedSessionMetaData().getSessionName();
        } else if (this.myProcess != null) {
            name = this.myProcess.getName();
        }
        String[] nameSplit = name.split(" \\(", 2);
        String string = nameSplit.length > 0 ? nameSplit[0] : "";
        if (string == null) {
            StudioProfilers.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setStage(@NotNull Stage stage) {
        if (stage == null) {
            StudioProfilers.$$$reportNull$$$0(11);
        }
        this.myStage.exit();
        this.getTimeline().getSelectionRange().clear();
        this.myStage = stage;
        this.myStage.getStudioProfilers().getUpdater().reset();
        this.myStage.enter();
        this.changed(ProfilerAspect.STAGE);
    }

    @NotNull
    public ProfilerTimeline getTimeline() {
        ProfilerTimeline profilerTimeline = this.myTimeline;
        if (profilerTimeline == null) {
            StudioProfilers.$$$reportNull$$$0(12);
        }
        return profilerTimeline;
    }

    @Nullable
    public Common.Device getDevice() {
        return this.myDevice;
    }

    @Nullable
    public Common.Process getProcess() {
        return this.myProcess;
    }

    public boolean isAgentAttached() {
        return this.myAgentStatus.getStatus() == Profiler.AgentStatusResponse.Status.ATTACHED;
    }

    @NotNull
    public Profiler.AgentStatusResponse getAgentStatus() {
        Profiler.AgentStatusResponse agentStatusResponse = this.myAgentStatus;
        if (agentStatusResponse == null) {
            StudioProfilers.$$$reportNull$$$0(13);
        }
        return agentStatusResponse;
    }

    public List<StudioProfiler> getProfilers() {
        return this.myProfilers;
    }

    public ProfilerMode getMode() {
        return this.myStage.getProfilerMode();
    }

    public void modeChanged() {
        this.changed(ProfilerAspect.MODE);
    }

    @NotNull
    public IdeProfilerServices getIdeServices() {
        IdeProfilerServices ideProfilerServices = this.myIdeServices;
        if (ideProfilerServices == null) {
            StudioProfilers.$$$reportNull$$$0(14);
        }
        return ideProfilerServices;
    }

    public Updater getUpdater() {
        return this.myUpdater;
    }

    public AxisComponentModel getViewAxis() {
        return this.myViewAxis;
    }

    public List<Class<? extends Stage>> getDirectStages() {
        boolean isEnergyStageEnabled;
        boolean hasSession;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(CpuProfilerStage.class);
        listBuilder.add(MemoryProfilerStage.class);
        listBuilder.add(NetworkProfilerStage.class);
        boolean bl = hasSession = this.mySelectedSession.getSessionId() != 0L;
        boolean bl2 = hasSession ? this.mySessionsManager.getSelectedSessionMetaData().getJvmtiEnabled() : (isEnergyStageEnabled = this.myDevice != null && this.myDevice.getFeatureLevel() >= 26);
        if (this.getIdeServices().getFeatureConfig().isEnergyProfilerEnabled() && isEnergyStageEnabled) {
            listBuilder.add(EnergyProfilerStage.class);
        }
        return listBuilder.build();
    }

    @NotNull
    public Class<? extends Stage> getStageClass() {
        Class<?> clazz = ((Object)((Object)this.myStage)).getClass();
        if (clazz == null) {
            StudioProfilers.$$$reportNull$$$0(15);
        }
        return clazz;
    }

    public void setNewStage(Class<? extends Stage> clazz) {
        try {
            Constructor<? extends Stage> constructor = clazz.getConstructor(StudioProfilers.class);
            Stage stage = constructor.newInstance(new Object[]{this});
            this.setStage(stage);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @NotNull
    public static String buildSessionName(@NotNull Common.Device device, @NotNull Common.Process process) {
        if (device == null) {
            StudioProfilers.$$$reportNull$$$0(16);
        }
        if (process == null) {
            StudioProfilers.$$$reportNull$$$0(17);
        }
        String string = String.format("%s (%s)", process.getName(), StudioProfilers.buildDeviceName(device));
        if (string == null) {
            StudioProfilers.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String buildDeviceName(@NotNull Common.Device device) {
        if (device == null) {
            StudioProfilers.$$$reportNull$$$0(19);
        }
        StringBuilder deviceNameBuilder = new StringBuilder();
        String manufacturer = device.getManufacturer();
        String model = device.getModel();
        String serial = device.getSerial();
        String suffix = String.format("-%s", serial);
        if (model.endsWith(suffix)) {
            model = model.substring(0, model.length() - suffix.length());
        }
        if (!StringUtil.isEmpty((String)manufacturer)) {
            deviceNameBuilder.append(manufacturer);
            deviceNameBuilder.append(" ");
        }
        deviceNameBuilder.append(model);
        String string = deviceNameBuilder.toString();
        if (string == null) {
            StudioProfilers.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideServices";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/StudioProfilers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/StudioProfilers";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentStatus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionsManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAppName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeServices";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStageClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSessionName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDeviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredProcess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAgentStatus";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setStage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildSessionName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildDeviceName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

