/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.TraceParser;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCapture
implements ConfigurableDurationData {
    private final int myMainThreadId;
    @NotNull
    private ClockType myClockType;
    @NotNull
    private final TraceParser myParser;
    private final int myTraceId;
    private final CpuProfiler.CpuProfilerType myType;

    public CpuCapture(@NotNull TraceParser parser, int traceId, CpuProfiler.CpuProfilerType type) {
        if (parser == null) {
            CpuCapture.$$$reportNull$$$0(0);
        }
        this.myParser = parser;
        this.myTraceId = traceId;
        this.myType = type;
        Map.Entry<CpuThreadInfo, CaptureNode> main = null;
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : this.myParser.getCaptureTrees().entrySet()) {
            if (entry.getKey().isMainThread()) {
                main = entry;
                break;
            }
            if (main != null && main.getValue().getDuration() >= entry.getValue().getDuration()) continue;
            main = entry;
        }
        assert (main != null);
        this.myMainThreadId = ((CpuThreadInfo)main.getKey()).getId();
        CaptureNode mainNode = this.getCaptureNode(this.myMainThreadId);
        assert (mainNode != null);
        this.myClockType = mainNode.getClockType();
    }

    public int getMainThreadId() {
        return this.myMainThreadId;
    }

    @NotNull
    public Range getRange() {
        Range range = this.myParser.getRange();
        if (range == null) {
            CpuCapture.$$$reportNull$$$0(1);
        }
        return range;
    }

    @Nullable
    public CaptureNode getCaptureNode(int threadId) {
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : this.myParser.getCaptureTrees().entrySet()) {
            if (entry.getKey().getId() != threadId) continue;
            return entry.getValue();
        }
        return null;
    }

    @NotNull
    Set<CpuThreadInfo> getThreads() {
        Set<CpuThreadInfo> set = this.myParser.getCaptureTrees().keySet();
        if (set == null) {
            CpuCapture.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean containsThread(int threadId) {
        return this.myParser.getCaptureTrees().keySet().stream().anyMatch(info -> info.getId() == threadId);
    }

    public long getDurationUs() {
        return (long)this.myParser.getRange().getLength();
    }

    public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    public int getTraceId() {
        return this.myTraceId;
    }

    public boolean canSelectPartialRange() {
        return true;
    }

    public void updateClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuCapture.$$$reportNull$$$0(3);
        }
        if (this.myClockType == clockType) {
            return;
        }
        this.myClockType = clockType;
        for (CaptureNode tree : this.myParser.getCaptureTrees().values()) {
            CpuCapture.updateClockType(tree, clockType);
        }
    }

    private static void updateClockType(@Nullable CaptureNode node, @NotNull ClockType clockType) {
        if (clockType == null) {
            CpuCapture.$$$reportNull$$$0(4);
        }
        if (node == null) {
            return;
        }
        node.setClockType(clockType);
        for (CaptureNode child : node.getChildren()) {
            CpuCapture.updateClockType(child, clockType);
        }
    }

    public boolean isDualClock() {
        return this.myParser.supportsDualClock();
    }

    public CpuProfiler.CpuProfilerType getType() {
        return this.myType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCapture";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCapture";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateClockType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

