/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.art.ArtTraceParser;
import com.android.tools.profilers.cpu.atrace.AtraceDecompressor;
import com.android.tools.profilers.cpu.atrace.AtraceParser;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfTraceParser;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureParser {
    @VisibleForTesting
    static final int MAX_SUPPORTED_TRACE_SIZE = 0x6400000;
    static final int IMPORTED_TRACE_ID = 42;
    private final Map<Integer, CompletableFuture<CpuCapture>> myCaptures;
    private final Map<Integer, String> myTraceFiles;
    @NotNull
    private final IdeProfilerServices myServices;

    public CpuCaptureParser(@NotNull IdeProfilerServices services) {
        if (services == null) {
            CpuCaptureParser.$$$reportNull$$$0(0);
        }
        this.myServices = services;
        this.myCaptures = new HashMap<Integer, CompletableFuture<CpuCapture>>();
        this.myTraceFiles = new HashMap<Integer, String>();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuCaptureParser.class);
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCapture(int traceId) {
        return this.myCaptures.get(traceId);
    }

    @Nullable
    String getTraceFilePath(int traceId) {
        return this.myTraceFiles.get(traceId);
    }

    void abortParsing() {
        this.myCaptures.forEach((id, capture) -> {
            boolean isCaptureCancelled = capture.cancel(true);
            if (!isCaptureCancelled) {
                CpuCaptureParser.getLogger().warn(String.format("Parsing of capture %d was not properly cancelled.", id));
            }
        });
    }

    @Nullable
    public CompletableFuture<CpuCapture> parse(@NotNull Common.Session session, int traceId, @NotNull ByteString traceData, CpuProfiler.CpuProfilerType profilerType) {
        if (session == null) {
            CpuCaptureParser.$$$reportNull$$$0(1);
        }
        if (traceData == null) {
            CpuCaptureParser.$$$reportNull$$$0(2);
        }
        if (!this.myCaptures.containsKey(traceId)) {
            if (traceData.size() <= 0x6400000) {
                this.myCaptures.put(traceId, this.createCaptureFuture(session, traceId, traceData, profilerType));
            } else {
                Runnable yesCallback = () -> {
                    if (traceData == null) {
                        CpuCaptureParser.$$$reportNull$$$0(8);
                    }
                    if (session == null) {
                        CpuCaptureParser.$$$reportNull$$$0(9);
                    }
                    CpuCaptureParser.getLogger().warn(String.format("Parsing long (%d bytes) trace file.", traceData.size()));
                    this.myCaptures.put(traceId, this.createCaptureFuture(session, traceId, traceData, profilerType));
                };
                Runnable noCallback = () -> {
                    if (traceData == null) {
                        CpuCaptureParser.$$$reportNull$$$0(7);
                    }
                    CpuCaptureParser.getLogger().warn(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", traceData.size()));
                    this.myCaptures.put(traceId, null);
                };
                this.myServices.openParseLargeTracesDialog(yesCallback, noCallback);
            }
        }
        return this.myCaptures.get(traceId);
    }

    @Nullable
    public CompletableFuture<CpuCapture> parse(File traceFile) {
        if (!traceFile.exists() || traceFile.isDirectory()) {
            CpuCaptureParser.getLogger().info("Trace not parsed, as its path doesn't exist or points to a directory.");
            return null;
        }
        this.myTraceFiles.put(42, traceFile.getAbsolutePath());
        long fileLength = traceFile.length();
        if (fileLength > 0x6400000L) {
            Runnable yesCallback = () -> {
                CpuCaptureParser.getLogger().warn(String.format("Parsing long (%d bytes) trace file.", fileLength));
                this.myCaptures.put(42, CompletableFuture.supplyAsync(() -> this.tryParsingFileWithDifferentParsers(traceFile), this.myServices.getPoolExecutor()));
            };
            Runnable noCallback = () -> {
                CpuCaptureParser.getLogger().warn(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", fileLength));
                this.myCaptures.put(42, null);
            };
            this.myServices.openParseLargeTracesDialog(yesCallback, noCallback);
        } else {
            this.myCaptures.put(42, CompletableFuture.supplyAsync(() -> this.tryParsingFileWithDifferentParsers(traceFile), this.myServices.getPoolExecutor()));
        }
        return this.myCaptures.get(42);
    }

    private CpuCapture tryParsingFileWithDifferentParsers(File traceFile) {
        try {
            ArtTraceParser artTraceParser = new ArtTraceParser();
            return artTraceParser.parse(traceFile, 42);
        }
        catch (Exception artTraceParser) {
            if (this.myServices.getFeatureConfig().isSimpleperfEnabled()) {
                try {
                    SimpleperfTraceParser simpleperfParser = new SimpleperfTraceParser();
                    return simpleperfParser.parse(traceFile, 42);
                }
                catch (Exception simpleperfParser) {
                    // empty catch block
                }
            }
            if (this.myServices.getFeatureConfig().isAtraceEnabled()) {
                try {
                    AtraceParser parser;
                    CpuThreadSliceInfo[] processList;
                    CpuThreadSliceInfo selected;
                    if (AtraceDecompressor.verifyFileHasAtraceHeader(traceFile) && (selected = this.myServices.openListBoxChooserDialog("Select a process", "Select the process you want to analyze.", processList = (parser = new AtraceParser(traceFile)).getProcessList(this.myServices.getApplicationId()), t -> t.getProcessName())) != null) {
                        parser.setSelectProcess(selected);
                        return parser.parse(traceFile, 42);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CpuCaptureParser.getLogger().warn(String.format("Parsing %s has failed.", traceFile.getPath()));
            return null;
        }
    }

    private CompletableFuture<CpuCapture> createCaptureFuture(@NotNull Common.Session session, int traceId, ByteString traceBytes, CpuProfiler.CpuProfilerType profilerType) {
        if (session == null) {
            CpuCaptureParser.$$$reportNull$$$0(3);
        }
        return CompletableFuture.supplyAsync(() -> {
            if (session == null) {
                CpuCaptureParser.$$$reportNull$$$0(6);
            }
            return this.traceBytesToCapture(session, traceId, traceBytes, profilerType);
        }, this.myServices.getPoolExecutor());
    }

    private CpuCapture traceBytesToCapture(@NotNull Common.Session session, int traceId, @NotNull ByteString traceData, CpuProfiler.CpuProfilerType profilerType) {
        if (session == null) {
            CpuCaptureParser.$$$reportNull$$$0(4);
        }
        if (traceData == null) {
            CpuCaptureParser.$$$reportNull$$$0(5);
        }
        try {
            TraceParser parser;
            File trace = FileUtil.createTempFile((String)String.format("cpu_trace_%d", traceId), (String)".trace", (boolean)true);
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(traceData.toByteArray());
            }
            this.myTraceFiles.put(traceId, trace.getAbsolutePath());
            if (profilerType == CpuProfiler.CpuProfilerType.ART) {
                parser = new ArtTraceParser();
            } else if (profilerType == CpuProfiler.CpuProfilerType.SIMPLEPERF) {
                parser = new SimpleperfTraceParser();
            } else if (profilerType == CpuProfiler.CpuProfilerType.ATRACE) {
                parser = new AtraceParser(session.getPid());
            } else {
                throw new IllegalStateException("Trace file cannot be parsed. Profiler type (ART, simpleperf, or atrace) needs to be set.");
            }
            return parser.parse(trace, traceId);
        }
        catch (IOException | BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceData";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaptureFuture";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "traceBytesToCapture";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createCaptureFuture$8";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$parse$2";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$parse$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

