/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuChartTooltipViewBase;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class CpuChartTooltipView
extends CpuChartTooltipViewBase {
    public CpuChartTooltipView(@NotNull HTreeChart<CaptureNode> chart, @NotNull CpuProfilerStageView stageView) {
        if (chart == null) {
            CpuChartTooltipView.$$$reportNull$$$0(0);
        }
        if (stageView == null) {
            CpuChartTooltipView.$$$reportNull$$$0(1);
        }
        super(chart, stageView);
    }

    @Override
    protected void showTooltip(@NotNull CaptureNode node) {
        if (node == null) {
            CpuChartTooltipView.$$$reportNull$$$0(2);
        }
        Range dataRange = this.myStageView.getTimeline().getDataRange();
        long start = (long)((double)node.getStart() - dataRange.getMin());
        long end = (long)((double)node.getEnd() - dataRange.getMin());
        long totalDuration = node.getDuration();
        this.getTooltipContainer().removeAll();
        JLabel nameLabel = new JLabel(node.getData().getFullName());
        nameLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.getTooltipContainer().add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        JLabel timelineLabel = new JLabel(String.format("%s - %s", TimeFormatter.getFullClockString((long)start), TimeFormatter.getFullClockString((long)end)));
        timelineLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        timelineLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        timelineLabel.setBorder((Border)JBUI.Borders.empty());
        JLabel durationLabel = new JLabel(String.format("%s", TimeFormatter.getSingleUnitDurationString((long)totalDuration)));
        durationLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        durationLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        durationLabel.setBorder((Border)JBUI.Borders.empty());
        this.getTooltipContainer().add((Component)timelineLabel, new TabularLayout.Constraint(1, 0));
        this.getTooltipContainer().add((Component)durationLabel, new TabularLayout.Constraint(2, 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuChartTooltipView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

