/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.FilterModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuKernelModel;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.TraceIdsIterator;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    public static int CPU_ART_STOP_TIMEOUT_SEC = Math.max(5, Math.min(Integer.getInteger("profiler.cpu.art.stop.timeout.sec", 5), 300));
    static final double IMPORTED_TRACE_VIEW_EXPAND_PERCENTAGE = 0.1;
    @VisibleForTesting
    static final String PARSING_FAILURE_BALLOON_TITLE = "Trace data was not recorded";
    @VisibleForTesting
    static final String PARSING_FAILURE_BALLOON_TEXT = "The profiler was unable to parse the method trace data. Try recording another method trace, or ";
    @VisibleForTesting
    static final String PARSING_FILE_FAILURE_BALLOON_TITLE = "Trace file was not parsed";
    @VisibleForTesting
    static final String PARSING_FILE_FAILURE_BALLOON_TEXT = "The profiler was unable to parse the trace file. Please make sure the file selected is a valid trace. Alternatively, try importing another file, or ";
    @VisibleForTesting
    static final String PARSING_ABORTED_BALLOON_TITLE = "Parsing trace file aborted";
    @VisibleForTesting
    static final String PARSING_IMPORTED_TRACE_ABORTED_BALLOON_TEXT = "The profiler changed to a different session before the imported trace file could be parsed. Please try importing your trace file again.";
    @VisibleForTesting
    static final String PARSING_RECORDED_TRACE_ABORTED_BALLOON_TEXT = "The CPU profiler was closed before the recorded trace file could be parsed. Please record another trace.";
    @VisibleForTesting
    static final String CAPTURE_START_FAILURE_BALLOON_TITLE = "Recording failed to start";
    @VisibleForTesting
    static final String CAPTURE_START_FAILURE_BALLOON_TEXT = "Try recording again, or ";
    @VisibleForTesting
    static final String CAPTURE_STOP_FAILURE_BALLOON_TITLE = "Recording failed to stop";
    @VisibleForTesting
    static final String CAPTURE_STOP_FAILURE_BALLOON_TEXT = "Try recording another method trace, or ";
    @VisibleForTesting
    static final String CPU_BUG_TEMPLATE_URL = "https://issuetracker.google.com/issues/new?component=192754";
    @VisibleForTesting
    static final String REPORT_A_BUG_TEXT = "report a bug";
    private static final CaptureModel.Details.Type DEFAULT_CAPTURE_DETAILS = CaptureModel.Details.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final CpuKernelModel myCpuKernelModel;
    private final ClampedAxisComponentModel myCpuUsageAxis;
    private final ClampedAxisComponentModel myThreadCountAxis;
    private final ResizingAxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuProfilerConfigModel myProfilerConfigModel;
    private final DurationDataModel<CpuTraceInfo> myRecentTraceDurations;
    @NotNull
    private final DurationDataModel<DefaultDurationData> myInProgressTraceDuration;
    @NotNull
    private final DefaultDataSeries<DefaultDurationData> myInProgressTraceSeries;
    private CpuProfiler.TraceInitiationType myInProgressTraceInitiationType;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect;
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    private final CpuCaptureStateUpdatable myCaptureStateUpdatable;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    private boolean mySelectionFailure;
    @NotNull
    private final TraceIdsIterator myTraceIdsIterator;
    private final boolean myIsImportTraceMode;
    @Nullable
    private File myImportedTrace;
    private Common.Session mySession;

    public CpuProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(0);
        }
        this(profilers, null);
    }

    public CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(1);
        }
        this(profilers, importedTrace, new CpuCaptureParser(profilers.getIdeServices()));
    }

    @VisibleForTesting
    CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace, @NotNull CpuCaptureParser captureParser) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(2);
        }
        if (captureParser == null) {
            CpuProfilerStage.$$$reportNull$$$0(3);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myImportedTrace = importedTrace;
        this.mySession = profilers.getSession();
        this.myIsImportTraceMode = this.getStudioProfilers().getIdeServices().getFeatureConfig().isImportCpuTraceEnabled() && this.getStudioProfilers().getIdeServices().getFeatureConfig().isSessionsEnabled() && importedTrace != null;
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myProfilerConfigModel = new CpuProfilerConfigModel(profilers, this);
        Range viewRange = this.getStudioProfilers().getTimeline().getViewRange();
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER).build();
        this.myThreadCountAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS).build();
        this.myTimeAxisGuide = new ResizingAxisComponentModel.Builder(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS).setGlobalRange(dataRange).build();
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, this, this.mySession);
        this.myCpuKernelModel = new CpuKernelModel(viewRange, this);
        this.myInProgressTraceSeries = new DefaultDataSeries();
        this.myInProgressTraceDuration = new DurationDataModel(new RangedSeries(viewRange, this.myInProgressTraceSeries));
        this.myInProgressTraceInitiationType = CpuProfiler.TraceInitiationType.UNSPECIFIED_INITIATION;
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = this.buildSelectionModel(selectionRange);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myCaptureState = CaptureState.IDLE;
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.myCaptureStateUpdatable = new CpuCaptureStateUpdatable(() -> this.updateProfilingState());
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = captureParser;
        this.myTraceIdsIterator = new TraceIdsIterator(this, this.getTraceInfoFromRange(new Range(-1.7976931348623157E308, Double.MAX_VALUE)));
        this.myRecentTraceDurations = new DurationDataModel(new RangedSeries(new Range(-1.7976931348623157E308, Double.MAX_VALUE), (DataSeries)this.getCpuTraceDataSeries()));
        this.myRecentTraceDurations.addDependency((AspectObserver)this).onChange((Enum)DurationDataModel.Aspect.DURATION_DATA, () -> {
            Range xRange = this.myRecentTraceDurations.getSeries().getXRange();
            CpuTraceInfo candidateToSelect = null;
            List recentTraceInfo = this.myRecentTraceDurations.getSeries().getDataSeries().getDataForXRange(xRange);
            for (SeriesData series : recentTraceInfo) {
                CpuTraceInfo trace = (CpuTraceInfo)series.value;
                if (trace.getInitiationType().equals((Object)CpuProfiler.TraceInitiationType.INITIATED_BY_API) && !this.myTraceIdsIterator.contains(trace.getTraceId())) {
                    this.myTraceIdsIterator.addTrace(trace.getTraceId());
                    if (candidateToSelect == null || trace.getRange().getMax() > candidateToSelect.getRange().getMax()) {
                        candidateToSelect = trace;
                    }
                    this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuApiTracing(false, !trace.getTraceFilePath().equals(""), -1, -1, -1);
                }
                if (!(trace.getRange().getMax() > xRange.getMin())) continue;
                xRange.setMin(trace.getRange().getMax());
            }
            if (candidateToSelect != null) {
                this.setAndSelectCapture(candidateToSelect.getTraceId());
            }
        });
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    private SelectionModel buildSelectionModel(Range selectionRange) {
        SelectionModel selectionModel = new SelectionModel(selectionRange);
        selectionModel.addConstraint(this.myTraceDurations);
        if (this.myIsImportTraceMode) {
            selectionModel.addListener(new SelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.mySelectionFailure = false;
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                }

                public void selectionCleared() {
                    CpuProfilerStage.this.mySelectionFailure = false;
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }

                public void selectionCreationFailure() {
                    CpuProfilerStage.this.mySelectionFailure = false;
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }
            });
        } else {
            selectionModel.addListener(new SelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.mySelectionFailure = false;
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCleared() {
                    CpuProfilerStage.this.mySelectionFailure = false;
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCreationFailure() {
                    CpuProfilerStage.this.mySelectionFailure = true;
                    CpuProfilerStage.this.selectionChanged();
                }
            });
        }
        return selectionModel;
    }

    public boolean isImportTraceMode() {
        return this.myIsImportTraceMode;
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(4);
        }
        return selectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        EaseOutModel easeOutModel = this.myInstructionsEaseOutModel;
        if (easeOutModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(5);
        }
        return easeOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    @NotNull
    public DurationDataModel<DefaultDurationData> getInProgressTraceDuration() {
        DurationDataModel<DefaultDurationData> durationDataModel = this.myInProgressTraceDuration;
        if (durationDataModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(6);
        }
        return durationDataModel;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public CpuProfilerConfigModel getProfilerConfigModel() {
        CpuProfilerConfigModel cpuProfilerConfigModel = this.myProfilerConfigModel;
        if (cpuProfilerConfigModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(7);
        }
        return cpuProfilerConfigModel;
    }

    public boolean isSelectionFailure() {
        return this.mySelectionFailure;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register(this.myRecentTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuApiTracingEnabled()) {
            this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureStateUpdatable);
        }
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.DEVICES, this.myProfilerConfigModel::updateProfilingConfigurations);
        this.updateProfilingState();
        this.myProfilerConfigModel.updateProfilingConfigurations();
        if (this.myIsImportTraceMode) {
            assert (this.myImportedTrace != null);
            this.parseAndSelectImportedTrace(this.myImportedTrace);
        }
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myRecentTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuApiTracingEnabled()) {
            this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureStateUpdatable);
        }
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.getStudioProfilers().removeDependencies(this);
        this.myCaptureParser.abortParsing();
        this.mySelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        UpdatableManager updatableManager = this.myUpdatableManager;
        if (updatableManager == null) {
            CpuProfilerStage.$$$reportNull$$$0(8);
        }
        return updatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void startCapturing() {
        ProfilingConfiguration config = this.myProfilerConfigModel.getProfilingConfiguration();
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setSession(this.mySession).setConfiguration(config.toProto()).setAbiCpuArch(this.getStudioProfilers().getProcess().getAbiCpuArch()).build();
        this.myInProgressTraceInitiationType = CpuProfiler.TraceInitiationType.INITIATED_BY_UI;
        this.setCaptureState(CaptureState.STARTING);
        CompletableFuture.supplyAsync(() -> cpuService.startProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> this.startCapturingCallback((CpuProfiler.CpuProfilingAppStartResponse)response, config), this.getStudioProfilers().getIdeServices().getMainExecutor());
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void startCapturingCallback(CpuProfiler.CpuProfilingAppStartResponse response, ProfilingConfiguration profilingConfiguration) {
        if (response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS)) {
            this.myProfilerConfigModel.setProfilingConfiguration(profilingConfiguration);
            this.setCaptureState(CaptureState.CAPTURING);
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            this.getStudioProfilers().getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.START_FAILURE);
            this.getStudioProfilers().getIdeServices().showErrorBalloon(CAPTURE_START_FAILURE_BALLOON_TITLE, CAPTURE_START_FAILURE_BALLOON_TEXT, CPU_BUG_TEMPLATE_URL, REPORT_A_BUG_TEXT);
            this.setCaptureState(CaptureState.IDLE);
        }
    }

    public void stopCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStopRequest request = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setProfilerType(this.myProfilerConfigModel.getProfilingConfiguration().getProfilerType()).setSession(this.mySession).build();
        this.myInProgressTraceSeries.clear();
        long captureStartTimeUs = TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs);
        long currentTimeUs = TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs());
        this.myInProgressTraceSeries.add(captureStartTimeUs, (Object)new DefaultDurationData(currentTimeUs - captureStartTimeUs));
        this.setCaptureState(CaptureState.STOPPING);
        CompletableFuture.supplyAsync(() -> cpuService.stopProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(this::stopCapturingCallback, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    public long getCaptureElapsedTimeUs() {
        return TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs() - this.myCaptureStartTimeNs);
    }

    private List<CpuProfiler.TraceInfo> getTraceInfoFromRange(Range rangeUs) {
        long rangeMinNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long rangeMaxNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.GetTraceInfoResponse response = cpuService.getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(this.mySession).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
        return response.getTraceInfoList();
    }

    @NotNull
    public TraceIdsIterator getTraceIdsIterator() {
        TraceIdsIterator traceIdsIterator = this.myTraceIdsIterator;
        if (traceIdsIterator == null) {
            CpuProfilerStage.$$$reportNull$$$0(9);
        }
        return traceIdsIterator;
    }

    void navigateNext() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.next());
    }

    void navigatePrevious() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.previous());
    }

    private void handleCaptureNavigation(int traceId) {
        if (traceId == -1) {
            return;
        }
        this.setAndSelectCapture(traceId);
    }

    private void stopCapturingCallback(CpuProfiler.CpuProfilingAppStopResponse response) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerConfigModel.getProfilingConfiguration());
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS)) {
            CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.STOP_FAILURE);
            this.getStudioProfilers().getIdeServices().showErrorBalloon(CAPTURE_STOP_FAILURE_BALLOON_TITLE, CAPTURE_STOP_FAILURE_BALLOON_TEXT, CPU_BUG_TEMPLATE_URL, REPORT_A_BUG_TEXT);
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        } else {
            this.setCaptureState(CaptureState.PARSING);
            ByteString traceBytes = response.getTrace();
            captureMetadata.setTraceFileSizeBytes(traceBytes.size());
            this.handleCaptureParsing(response.getTraceId(), traceBytes, captureMetadata);
        }
    }

    private void parseAndSelectImportedTrace(File traceFile) {
        assert (this.myIsImportTraceMode);
        this.setCaptureState(CaptureState.PARSING);
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(traceFile);
        if (capture == null) {
            CpuProfilerStage.getLogger().info("Imported trace file was not parsed.");
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            if (parsedCapture != null) {
                ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
                Range captureRangeNs = new Range((double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMin()), (double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMax()));
                double expandAmountNs = 0.1 * captureRangeNs.getLength();
                timeline.reset((long)captureRangeNs.getMin(), (long)(captureRangeNs.getMax() + expandAmountNs));
                timeline.setIsPaused(true);
                this.myThreadsStates.buildImportedTraceThreads((CpuCapture)parsedCapture);
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                double expandAmountUs = TimeUnit.NANOSECONDS.toMicros((long)expandAmountNs);
                timeline.getViewRange().set(parsedCapture.getRange().getMin() - expandAmountUs, parsedCapture.getRange().getMax() + expandAmountUs);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                if (!this.myTraceIdsIterator.contains(42)) {
                    this.saveTraceInfo(42, (CpuCapture)parsedCapture);
                    this.myTraceIdsIterator.addTrace(42);
                }
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackImportTrace(parsedCapture.getType(), true);
            } else if (capture.isCancelled()) {
                this.getStudioProfilers().getIdeServices().showErrorBalloon(PARSING_ABORTED_BALLOON_TITLE, PARSING_IMPORTED_TRACE_ABORTED_BALLOON_TEXT, null, null);
            } else {
                this.setCaptureState(CaptureState.PARSING_FAILURE);
                this.getStudioProfilers().getIdeServices().showErrorBalloon(PARSING_FILE_FAILURE_BALLOON_TITLE, PARSING_FILE_FAILURE_BALLOON_TEXT, CPU_BUG_TEMPLATE_URL, REPORT_A_BUG_TEXT);
                this.setCaptureState(CaptureState.IDLE);
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackImportTrace(CpuProfiler.CpuProfilerType.UNSPECIFIED_PROFILER, false);
            }
        };
        capture.handleAsync((parsedCapture, exception) -> {
            parsingCallback.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private void handleCaptureParsing(int traceId, ByteString traceBytes, CpuCaptureMetadata captureMetadata) {
        long beforeParsingTime = System.currentTimeMillis();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.mySession, traceId, traceBytes, this.myProfilerConfigModel.getProfilingConfiguration().getProfilerType());
        if (capture == null) {
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            this.myInProgressTraceSeries.clear();
            if (parsedCapture != null) {
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                this.saveTraceInfo(traceId, (CpuCapture)parsedCapture);
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                captureMetadata.setParsingTimeMs(System.currentTimeMillis() - beforeParsingTime);
                captureMetadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(parsedCapture.getDurationUs()));
                captureMetadata.setRecordDurationMs(CpuProfilerStage.calculateRecordDurationMs(parsedCapture));
            } else if (capture.isCancelled()) {
                this.getStudioProfilers().getIdeServices().showErrorBalloon(PARSING_ABORTED_BALLOON_TITLE, PARSING_RECORDED_TRACE_ABORTED_BALLOON_TEXT, null, null);
            } else {
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                this.setCaptureState(CaptureState.PARSING_FAILURE);
                this.getStudioProfilers().getIdeServices().showErrorBalloon(PARSING_FAILURE_BALLOON_TITLE, PARSING_FAILURE_BALLOON_TEXT, CPU_BUG_TEMPLATE_URL, REPORT_A_BUG_TEXT);
                this.setCaptureState(CaptureState.IDLE);
                this.setCapture(null);
            }
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        };
        capture.handleAsync((parsedCapture, exception) -> {
            if (parsedCapture == null) {
                assert (exception != null);
                CpuProfilerStage.getLogger().warn("Unable to parse capture: " + exception.getMessage(), exception);
            }
            parsingCallback.accept((CpuCapture)parsedCapture);
            this.myTraceIdsIterator.addTrace(traceId);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private static long calculateRecordDurationMs(CpuCapture capture) {
        Range maxDataRange = new Range();
        for (CpuThreadInfo thread2 : capture.getThreads()) {
            CaptureNode threadMainNode = capture.getCaptureNode(thread2.getId());
            assert (threadMainNode != null);
            maxDataRange.expand((double)threadMainNode.getStartGlobal(), (double)threadMainNode.getEndGlobal());
        }
        return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
    }

    private void saveTraceInfo(int traceId, @NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(10);
        }
        long captureFrom = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin());
        long captureTo = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax());
        ArrayList<CpuProfiler.Thread> threads = new ArrayList<CpuProfiler.Thread>();
        for (CpuThreadInfo thread2 : capture.getThreads()) {
            threads.add(CpuProfiler.Thread.newBuilder().setTid(thread2.getId()).setName(thread2.getName()).build());
        }
        CpuProfiler.TraceInfo traceInfo = CpuProfiler.TraceInfo.newBuilder().setTraceId(traceId).setFromTimestamp(captureFrom).setToTimestamp(captureTo).setProfilerType(capture.getType()).setTraceFilePath(this.myCaptureParser.getTraceFilePath(traceId)).addAllThreads(threads).build();
        CpuProfiler.SaveTraceInfoRequest request = CpuProfiler.SaveTraceInfoRequest.newBuilder().setSession(this.mySession).setTraceInfo(traceInfo).build();
        CpuServiceGrpc.CpuServiceBlockingStub service = this.getStudioProfilers().getClient().getCpuClient();
        service.saveTraceInfo(request);
    }

    private CpuProfiler.ProfilingStateResponse checkProfilingState() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.ProfilingStateRequest request = CpuProfiler.ProfilingStateRequest.newBuilder().setSession(this.mySession).build();
        return cpuService.checkAppProfilingState(request);
    }

    @VisibleForTesting
    void updateProfilingState() {
        CpuProfiler.ProfilingStateResponse response = this.checkProfilingState();
        if (response.getBeingProfiled()) {
            ProfilingConfiguration configuration = ProfilingConfiguration.fromProto(response.getConfiguration());
            if (this.myCaptureState == CaptureState.IDLE) {
                if (response.getInitiationType() == CpuProfiler.TraceInitiationType.INITIATED_BY_STARTUP) {
                    this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuStartupProfiling(configuration);
                }
                this.myInProgressTraceInitiationType = response.getInitiationType();
                this.setCaptureState(CaptureState.CAPTURING);
                this.myCaptureStartTimeNs = response.getStartTimestamp();
                this.myInProgressTraceSeries.clear();
                this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
                this.getStudioProfilers().getTimeline().setStreaming(true);
                if (this.myInProgressTraceInitiationType == CpuProfiler.TraceInitiationType.INITIATED_BY_API) {
                    this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
                } else {
                    this.myProfilerConfigModel.setProfilingConfiguration(configuration);
                }
            }
        } else if (this.myCaptureState == CaptureState.CAPTURING) {
            this.setCaptureState(CaptureState.IDLE);
            this.myInProgressTraceSeries.clear();
            this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
        }
    }

    private void selectionChanged() {
        CpuTraceInfo intersectingTraceInfo = this.getIntersectingTraceInfo(this.getStudioProfilers().getTimeline().getSelectionRange());
        if (intersectingTraceInfo == null) {
            this.setCapture(null);
        } else {
            this.setCapture(intersectingTraceInfo.getTraceId());
        }
    }

    @Nullable
    CpuTraceInfo getIntersectingTraceInfo(Range range) {
        List infoList = this.getTraceDurations().getSeries().getDataSeries().getDataForXRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (captureRange.getIntersection(range).isEmpty()) continue;
            return (CpuTraceInfo)info.value;
        }
        return null;
    }

    private long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax());
    }

    @VisibleForTesting
    void setCapture(@Nullable CpuCapture capture) {
        this.myCaptureModel.setCapture(capture);
        if (capture != null) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    private void setCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.checkProfilingState().getBeingProfiled() ? CaptureState.CAPTURING : CaptureState.IDLE);
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.checkProfilingState().getBeingProfiled() ? CaptureState.CAPTURING : CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(11);
        }
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        timeline.getSelectionRange().set(capture.getRange());
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
        Range range = this.getStudioProfilers().getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.mySelectionFailure = true;
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        ImmutableList immutableList = ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
        if (immutableList == null) {
            CpuProfilerStage.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myCaptureModel.getClockType();
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(13);
        }
        return clockType;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(14);
        }
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        CaptureState captureState = this.myCaptureState;
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(15);
        }
        return captureState;
    }

    @NotNull
    public CpuProfiler.TraceInitiationType getCaptureInitiationType() {
        CpuProfiler.TraceInitiationType traceInitiationType = this.myInProgressTraceInitiationType;
        if (traceInitiationType == null) {
            CpuProfilerStage.$$$reportNull$$$0(16);
        }
        return traceInitiationType;
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(17);
        }
        if (!this.myCaptureState.equals((Object)captureState)) {
            this.myCaptureState = captureState;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
            if (captureState == CaptureState.PARSING) {
                this.setProfilerMode(ProfilerMode.EXPANDED);
            }
        }
    }

    public void setCaptureFilter(@Nullable Pattern filter, @NotNull FilterModel model) {
        if (model == null) {
            CpuProfilerStage.$$$reportNull$$$0(18);
        }
        this.myCaptureModel.setFilter(filter);
        this.trackFilterUsage(filter, model);
    }

    private void trackFilterUsage(@Nullable Pattern filter, @NotNull FilterModel model) {
        if (model == null) {
            CpuProfilerStage.$$$reportNull$$$0(19);
        }
        FilterMetadata filterMetadata = new FilterMetadata();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        CaptureModel.Details details = this.getCaptureDetails();
        switch (details.getType()) {
            case TOP_DOWN: {
                filterMetadata.setView(FilterMetadata.View.CPU_TOP_DOWN);
                break;
            }
            case BOTTOM_UP: {
                filterMetadata.setView(FilterMetadata.View.CPU_BOTTOM_UP);
                break;
            }
            case CALL_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_CALL_CHART);
                break;
            }
            case FLAME_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_FLAME_CHART);
            }
        }
        filterMetadata.setFeaturesUsed(model.getIsMatchCase(), model.getIsRegex());
        filterMetadata.setMatchedElementCount(this.myCaptureModel.getFilterNodeCount());
        filterMetadata.setTotalElementCount(this.myCaptureModel.getNodeCount());
        filterMetadata.setFilterTextLength(filter == null ? 0 : filter.pattern().length());
        featureTracker.trackFilterMetadata(filterMetadata);
    }

    public boolean isApiInitiatedTracingInProgress() {
        return this.myCaptureState == CaptureState.CAPTURING && this.getCaptureInitiationType().equals((Object)CpuProfiler.TraceInitiationType.INITIATED_BY_API);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        CpuTraceDataSeries cpuTraceDataSeries = this.myCpuTraceDataSeries;
        if (cpuTraceDataSeries == null) {
            CpuProfilerStage.$$$reportNull$$$0(20);
        }
        return cpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        CpuThreadsModel cpuThreadsModel = this.myThreadsStates;
        if (cpuThreadsModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(21);
        }
        return cpuThreadsModel;
    }

    @NotNull
    public CpuKernelModel getCpuKernelModel() {
        CpuKernelModel cpuKernelModel = this.myCpuKernelModel;
        if (cpuKernelModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(22);
        }
        return cpuKernelModel;
    }

    @VisibleForTesting
    @Nullable
    CompletableFuture<CpuCapture> getCaptureFuture(int traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            this.setCaptureState(CaptureState.PARSING);
            CpuProfiler.GetTraceRequest request = CpuProfiler.GetTraceRequest.newBuilder().setSession(this.mySession).setTraceId(traceId).build();
            CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
            CpuProfiler.GetTraceResponse trace = cpuService.getTrace(request);
            if (trace.getStatus() == CpuProfiler.GetTraceResponse.Status.SUCCESS) {
                capture = this.myCaptureParser.parse(this.mySession, traceId, trace.getData(), trace.getProfilerType());
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureModel.Details.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureModel.Details getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            CpuProfilerStage.$$$reportNull$$$0(23);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureParser";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureState";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionsEaseOutModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInProgressTraceDuration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerConfigModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatableManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceIdsIterator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureState";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureInitiationType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuTraceDataSeries";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStates";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuKernelModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveTraceInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setAndSelectCapture";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureFilter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "trackFilterUsage";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            if (cpuUsage == null) {
                CpuStageLegends.$$$reportNull$$$0(0);
            }
            if (dataRange == null) {
                CpuStageLegends.$$$reportNull$$$0(1);
            }
            super(100);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            SeriesLegend seriesLegend = this.myOthersLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            SeriesLegend seriesLegend = this.myThreadsLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataRange";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOthersLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreadsLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForXRange(Range xRange) {
            List traceInfo = CpuProfilerStage.this.getTraceInfoFromRange(xRange);
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (CpuProfiler.TraceInfo protoTraceInfo : traceInfo) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    private class CpuCaptureStateUpdatable
    implements Updatable {
        @NotNull
        private final Runnable myCallback;
        private static final int UPDATE_COUNT_TO_CALL_CALLBACK = 6;
        private int myUpdateCount;

        public CpuCaptureStateUpdatable(Runnable callback) {
            if (callback == null) {
                CpuCaptureStateUpdatable.$$$reportNull$$$0(0);
            }
            this.myUpdateCount = 5;
            this.myCallback = callback;
        }

        public void update(long elapsedNs) {
            if (this.myUpdateCount++ >= 6) {
                this.myCallback.run();
                this.myUpdateCount = 0;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/profilers/cpu/CpuProfilerStage$CpuCaptureStateUpdatable", "<init>"));
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.myCaptureState == CaptureState.CAPTURING) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        PARSING,
        PARSING_FAILURE,
        STARTING,
        START_FAILURE,
        STOPPING,
        STOP_FAILURE;

    }

    public static enum ThreadState {
        RUNNING,
        RUNNING_CAPTURED,
        SLEEPING,
        SLEEPING_CAPTURED,
        DEAD,
        DEAD_CAPTURED,
        WAITING,
        WAITING_CAPTURED,
        HAS_ACTIVITY,
        NO_ACTIVITY,
        RUNNABLE_CAPTURED,
        WAITING_IO_CAPTURED,
        UNKNOWN;

    }
}

